/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support;

import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.support.AbstractEncryptedKeyResolver;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.KeyInfoReference;
import org.slf4j.Logger;

public class SimpleKeyInfoReferenceEncryptedKeyResolver
extends AbstractEncryptedKeyResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SimpleKeyInfoReferenceEncryptedKeyResolver.class);
    private int depthLimit = 5;

    public SimpleKeyInfoReferenceEncryptedKeyResolver() {
        this((Set<String>)null);
    }

    @Deprecated
    public SimpleKeyInfoReferenceEncryptedKeyResolver(@Nullable Set<String> recipients) {
        super(recipients);
    }

    @Deprecated
    public SimpleKeyInfoReferenceEncryptedKeyResolver(@Nullable String recipient) {
        this(recipient != null ? CollectionSupport.singleton((Object)recipient) : null);
    }

    public int getDepthLimit() {
        return this.depthLimit;
    }

    public void setDepthLimit(int limit) {
        this.depthLimit = Math.max(1, limit);
    }

    @Override
    @Nonnull
    public Iterable<EncryptedKey> resolve(@Nonnull EncryptedData encryptedData, @Nullable Set<String> recipients) {
        Constraint.isNotNull((Object)encryptedData, (String)"EncryptedData cannot be null");
        Set<String> validRecipients = this.getEffectiveRecipients(recipients);
        return this.resolveKeyInfo(encryptedData.getKeyInfo(), this.depthLimit, validRecipients);
    }

    @Nonnull
    protected Iterable<EncryptedKey> resolveKeyInfo(@Nullable KeyInfo keyInfo, int limit, @Nonnull @NonnullElements @Unmodifiable @NotLive Set<String> validRecipients) {
        ArrayList<EncryptedKey> resolvedEncKeys = new ArrayList<EncryptedKey>();
        if (keyInfo == null) {
            return resolvedEncKeys;
        }
        if (limit < this.depthLimit) {
            for (EncryptedKey encKey : keyInfo.getEncryptedKeys()) {
                if (!this.matchRecipient(encKey.getRecipient(), validRecipients)) continue;
                resolvedEncKeys.add(encKey);
            }
        }
        if (limit == 0) {
            this.log.info("Reached depth limit for KeyInfoReferences");
        } else {
            for (KeyInfoReference ref : keyInfo.getKeyInfoReferences()) {
                assert (ref != null);
                for (EncryptedKey encKey : this.resolveKeyInfo(this.dereferenceURI(ref), limit - 1, validRecipients)) {
                    resolvedEncKeys.add(encKey);
                }
            }
        }
        return resolvedEncKeys;
    }

    @Nullable
    protected KeyInfo dereferenceURI(@Nonnull KeyInfoReference ref) {
        String uri = ref.getURI();
        if (uri == null || uri.isEmpty() || !uri.startsWith("#")) {
            this.log.warn("EncryptedKey KeyInfoReference did not contain a same-document URI reference, cannot process");
            return null;
        }
        XMLObject target = ref.resolveIDFromRoot(uri.substring(1));
        if (target == null) {
            this.log.warn("EncryptedKey KeyInfoReference URI could not be dereferenced");
            return null;
        }
        if (!(target instanceof KeyInfo)) {
            this.log.warn("The product of dereferencing the EncryptedKey KeyInfoReference was not a KeyInfo");
            return null;
        }
        return (KeyInfo)target;
    }
}

