/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.job;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.Path;
import jakarta.validation.ValidationException;
import jakarta.validation.metadata.BeanDescriptor;
import jakarta.validation.metadata.ContainerDescriptor;
import jakarta.validation.metadata.ContainerElementTypeDescriptor;
import jakarta.validation.metadata.ElementDescriptor;
import jakarta.validation.metadata.PropertyDescriptor;
import jakarta.validation.valueextraction.ValueExtractor;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.bval.jsr.ApacheFactoryContext;
import org.apache.bval.jsr.ConstraintViolationImpl;
import org.apache.bval.jsr.GraphContext;
import org.apache.bval.jsr.descriptor.BeanD;
import org.apache.bval.jsr.descriptor.CascadableContainerD;
import org.apache.bval.jsr.descriptor.ComposedD;
import org.apache.bval.jsr.descriptor.ConstraintD;
import org.apache.bval.jsr.descriptor.ContainerElementTypeD;
import org.apache.bval.jsr.descriptor.DescriptorManager;
import org.apache.bval.jsr.descriptor.ElementD;
import org.apache.bval.jsr.descriptor.PropertyD;
import org.apache.bval.jsr.groups.GroupStrategy;
import org.apache.bval.jsr.job.ConstraintValidatorContextImpl;
import org.apache.bval.jsr.job.ValidationJob;
import org.apache.bval.jsr.metadata.ContainerElementKey;
import org.apache.bval.jsr.util.PathImpl;
import org.apache.bval.jsr.util.PathNavigation;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.ObjectWrapper;
import org.apache.bval.util.StringUtils;
import org.apache.bval.util.Validate;
import org.apache.bval.util.reflection.TypeUtils;

public final class ValidateProperty<T>
extends ValidationJob<T> {
    private final Strategy<T> strategy;
    private final Class<T> rootBeanClass;
    private final PathImpl propertyPath;
    private final T rootBean;
    private final boolean reachable;
    private ElementD<?, ?> descriptor;
    private boolean cascade;

    private ValidateProperty(Strategy<T> strategy, ApacheFactoryContext validatorContext, Class<T> rootBeanClass, String property, Class<?>[] groups) {
        super(validatorContext, groups);
        Exceptions.raiseIf(StringUtils.isBlank(property), IllegalArgumentException::new, "property cannot be null/empty/blank", new Object[0]);
        this.strategy = strategy;
        this.rootBeanClass = Validate.notNull(rootBeanClass, IllegalArgumentException::new, "rootBeanClass", new Object[0]);
        PathImpl.Builder pathBuilder = new PathImpl.Builder();
        FindDescriptor findDescriptor = new FindDescriptor(validatorContext, rootBeanClass);
        ObjectWrapper<Boolean> reachable = new ObjectWrapper<Boolean>(Boolean.TRUE);
        PathNavigation.navigate(property, strategy.callback(pathBuilder, findDescriptor, reachable));
        this.propertyPath = pathBuilder.result();
        this.descriptor = findDescriptor.result();
        this.rootBean = strategy.getRootBean();
        this.reachable = reachable.get();
    }

    ValidateProperty(ApacheFactoryContext validatorContext, Class<T> rootBeanClass, String property, Object value, Class<?>[] groups) {
        this(new ForPropertyValue(validatorContext, rootBeanClass, value), validatorContext, rootBeanClass, property, groups);
        Class propertyType;
        if (this.descriptor == null) {
            Class t = value == null ? Object.class : value.getClass();
            this.descriptor = (ElementD)validatorContext.getDescriptorManager().getBeanDescriptor(t);
        } else if (this.hasWork() && !TypeUtils.isInstance(value, propertyType = this.descriptor.getElementClass())) {
            Exceptions.raise(IllegalArgumentException::new, "%s is not an instance of %s", value, propertyType);
        }
    }

    ValidateProperty(ApacheFactoryContext validatorContext, T bean, String property, Class<?>[] groups) throws Exception {
        this(new ForBeanProperty<T>(validatorContext, Validate.notNull(bean, IllegalArgumentException::new, "bean", new Object[0])), validatorContext, bean.getClass(), property, groups);
        if (this.descriptor == null) {
            Exceptions.raise(IllegalArgumentException::new, "Could not resolve property name/path: %s", property);
        }
    }

    public ValidateProperty<T> cascade(boolean cascade) {
        this.cascade = cascade;
        return this;
    }

    @Override
    protected ValidationJob.Frame<?> computeBaseFrame() {
        return this.strategy.frame(this, this.propertyPath);
    }

    @Override
    protected Class<T> getRootBeanClass() {
        return this.rootBeanClass;
    }

    @Override
    protected boolean hasWork() {
        if (!this.reachable) {
            return false;
        }
        if (this.descriptor instanceof BeanDescriptor) {
            return ((BeanDescriptor)this.descriptor).isBeanConstrained();
        }
        return DescriptorManager.isConstrained((PropertyDescriptor)this.descriptor);
    }

    @Override
    ConstraintViolationImpl<T> createViolation(String messageTemplate, String message, ConstraintValidatorContextImpl<T> context, PathImpl propertyPath) {
        return new ConstraintViolationImpl<T>(messageTemplate, message, this.rootBean, context.getFrame().getBean(), propertyPath, context.getFrame().context.getValue(), context.getConstraintDescriptor(), this.rootBeanClass, ((ConstraintD)context.getConstraintDescriptor().unwrap(ConstraintD.class)).getDeclaredOn(), null, null);
    }

    static class PropertyFrame<D extends ElementD<?, ?> & ContainerDescriptor>
    extends ValidationJob.SproutFrame<D> {
        final /* synthetic */ ValidateProperty this$0;

        PropertyFrame(ValidationJob.Frame<?> parent, D descriptor, GraphContext context) {
            this.this$0 = this$0;
            super((ValidationJob)this$0, parent, descriptor, context);
        }

        @Override
        void recurse(GroupStrategy groups, Consumer<ConstraintViolation<T>> sink) {
            if (this.this$0.cascade) {
                super.recurse(groups, sink);
            }
        }
    }

    class LeafFrame<L>
    extends ValidationJob.BeanFrame<L> {
        LeafFrame(GraphContext context) {
            super(ValidateProperty.this, context);
        }

        @Override
        protected ValidationJob.Frame<?> propertyFrame(PropertyD<?> d, GraphContext context) {
            return new PropertyFrame(ValidateProperty.this, (ValidationJob.Frame)this, d, context);
        }
    }

    private static class WalkGraph
    extends PathNavigation.CallbackProcedure {
        final ApacheFactoryContext validatorContext;
        final Class<?> rootBeanClass;
        final PathImpl.Builder pathBuilder;
        final FindDescriptor findDescriptor;
        final ObjectWrapper<Object> value;
        final ObjectWrapper<Boolean> reachable;
        final BiConsumer<PathImpl, Object> recordLeaf;

        WalkGraph(ApacheFactoryContext validatorContext, Class<?> rootBeanClass, PathImpl.Builder pathBuilder, FindDescriptor findDescriptor, ObjectWrapper<Object> value, ObjectWrapper<Boolean> reachable, BiConsumer<PathImpl, Object> recordLeaf) {
            this.validatorContext = validatorContext;
            this.rootBeanClass = rootBeanClass;
            this.pathBuilder = pathBuilder;
            this.findDescriptor = findDescriptor;
            this.value = value;
            this.reachable = reachable;
            this.recordLeaf = recordLeaf;
        }

        @Override
        public void handleProperty(String name) {
            PathImpl p = PathImpl.copy(this.pathBuilder.result());
            this.pathBuilder.handleProperty(name);
            this.findDescriptor.handleProperty(name);
            if (this.reachable.get().booleanValue()) {
                try {
                    this.reachable.accept(this.validatorContext.getTraversableResolver().isReachable(this.value.get(), (Path.Node)this.pathBuilder.result().getLeafNode(), this.rootBeanClass, (Path)p, ((ElementD)this.findDescriptor.result()).getElementType()));
                }
                catch (ValidationException ve) {
                    throw ve;
                }
                catch (Exception e) {
                    throw new ValidationException((Throwable)e);
                }
            }
            if (this.reachable.get().booleanValue() && this.value.optional().isPresent() && this.recordLeaf != null) {
                this.recordLeaf.accept(p, this.value.get());
                PropertyD propertyD = ComposedD.unwrap(this.findDescriptor.current.element(), PropertyD.class).findFirst().get();
                try {
                    this.value.accept(propertyD.getValue(this.value.get()));
                }
                catch (Exception e) {
                    Exceptions.raise(IllegalStateException::new, e, "Unable to get value of property %s", propertyD.getPropertyName());
                }
            }
        }

        @Override
        public void handleIndexOrKey(String indexOrKey) {
            this.pathBuilder.handleIndexOrKey(indexOrKey);
            this.findDescriptor.handleIndexOrKey(indexOrKey);
            if (this.value.optional().isPresent()) {
                ElementD<?, ?> element = this.findDescriptor.current.element();
                if (element instanceof ContainerElementTypeD) {
                    this.value.accept(this.handleContainer(this.value.get(), ((ContainerElementTypeD)element).getKey(), indexOrKey));
                } else {
                    this.value.accept(this.handleBasic(this.value.get(), indexOrKey));
                    if (element == null && this.value.optional().isPresent()) {
                        this.findDescriptor.current = new TypeWrapper(this.validatorContext, this.value.get().getClass());
                        element = this.findDescriptor.current.element();
                    }
                    if (element instanceof BeanDescriptor) {
                        this.recordLeaf.accept(PathImpl.copy(this.pathBuilder.result()), this.value.get());
                    }
                }
            }
        }

        private Object handleContainer(Object o, ContainerElementKey key, final String indexOrKey) {
            ValueExtractor<?> valueExtractor = this.validatorContext.getValueExtractors().find(key);
            final ObjectWrapper result = new ObjectWrapper();
            valueExtractor.extractValues(o, new ValueExtractor.ValueReceiver(){

                public void indexedValue(String nodeName, int index, Object object) {
                    if (Integer.toString(index).equals(indexOrKey)) {
                        result.accept(object);
                    }
                }

                public void iterableValue(String nodeName, Object object) {
                    result.accept(object);
                }

                public void keyedValue(String nodeName, Object key, Object object) {
                    if (String.valueOf(key).equals(indexOrKey)) {
                        result.accept(object);
                    }
                }

                public void value(String nodeName, Object object) {
                    result.accept(object);
                }
            });
            return result.get();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Object handleBasic(Object o, String indexOrKey) {
            if (Map.class.isInstance(o)) {
                for (Map.Entry e : ((Map)o).entrySet()) {
                    if (!String.valueOf(e.getKey()).equals(indexOrKey)) continue;
                    return e.getValue();
                }
                return null;
            } else {
                try {
                    int index = Integer.parseInt(indexOrKey);
                    if (index < 0) {
                        Exceptions.raise(IllegalArgumentException::new, "Invalid index %d", index);
                    }
                    if (o != null && TypeUtils.isArrayType(o.getClass())) {
                        if (Array.getLength(o) <= index) return null;
                        return Array.get(o, index);
                    }
                    if (List.class.isInstance(o)) {
                        List l = (List)o;
                        if (l.size() <= index) return null;
                        return l.get(index);
                    }
                    if (!Iterable.class.isInstance(o)) return null;
                    int i = -1;
                    for (Object e : (Iterable)o) {
                        if (++i != index) continue;
                        return e;
                    }
                    return null;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public void handleGenericInIterable() {
            throw new UnsupportedOperationException("Cannot resolve generic inIterable against actual object graph");
        }
    }

    private static class FindDescriptor
    implements PathNavigation.Callback<ElementD<?, ?>> {
        private final ApacheFactoryContext validatorContext;
        Step current;

        FindDescriptor(ApacheFactoryContext validatorContext, Class<?> beanClass) {
            this.validatorContext = validatorContext;
            this.current = new DescriptorWrapper((ElementDescriptor)validatorContext.getDescriptorManager().getBeanDescriptor(beanClass));
        }

        @Override
        public void handleProperty(String name) {
            ElementD<?, ?> element = this.current.element();
            BeanD bean = element instanceof BeanD ? (BeanD)element : (BeanD)this.validatorContext.getDescriptorManager().getBeanDescriptor(element.getElementClass());
            PropertyDescriptor property = bean.getProperty(name);
            if (property == null) {
                Exceptions.raise(IllegalArgumentException::new, "Unknown property %s of %s", name, bean.getElementClass());
            }
            this.current = new DescriptorWrapper((ElementDescriptor)property);
        }

        @Override
        public void handleIndexOrKey(String value) {
            this.handleGenericInIterable();
        }

        @Override
        public void handleGenericInIterable() {
            Step containerElement;
            ElementD<?, ?> desc = this.current.element();
            if (desc instanceof CascadableContainerD && (containerElement = this.handleContainerElement((CascadableContainerD)desc)) != null) {
                this.current = containerElement;
                return;
            }
            this.current = this.handleElementByType(this.current.type());
        }

        private Step handleContainerElement(CascadableContainerD<?, ?> desc) {
            ContainerElementTypeDescriptor element;
            Set<ContainerElementTypeDescriptor> containerElements = desc.getConstrainedContainerElementTypes();
            if (containerElements.isEmpty()) {
                return null;
            }
            if (containerElements.size() == 1) {
                element = containerElements.iterator().next();
            } else {
                List<TypeVariable> wellKnown = Arrays.asList(ValidationJob.MAP_VALUE, ValidationJob.ITERABLE_ELEMENT);
                Optional<ContainerElementTypeD> found = containerElements.stream().map(ContainerElementTypeD.class::cast).filter(d -> wellKnown.stream().anyMatch(d.getKey()::represents)).findFirst();
                if (!found.isPresent()) {
                    return null;
                }
                element = found.get();
            }
            return new DescriptorWrapper((ElementDescriptor)element);
        }

        private Step handleElementByType(Type type) {
            Type elementType;
            if (TypeUtils.isArrayType(type)) {
                elementType = TypeUtils.getArrayComponentType(type);
            } else if (TypeUtils.isAssignable(type, Map.class)) {
                elementType = Optional.ofNullable(TypeUtils.getTypeArguments(type, Map.class).get(ValidationJob.MAP_VALUE)).orElse(ValidationJob.MAP_VALUE);
            } else if (TypeUtils.isAssignable(type, Iterable.class)) {
                elementType = Optional.ofNullable(TypeUtils.getTypeArguments(type, Iterable.class).get(ValidationJob.ITERABLE_ELEMENT)).orElse(ValidationJob.ITERABLE_ELEMENT);
            } else {
                throw Exceptions.create(IllegalArgumentException::new, "Unable to resolve element type of %s", type);
            }
            return new TypeWrapper(this.validatorContext, elementType);
        }

        @Override
        public ElementD<?, ?> result() {
            return this.current.element();
        }
    }

    private static class TypeWrapper
    implements Step {
        final ApacheFactoryContext validatorContext;
        final Type type;

        TypeWrapper(ApacheFactoryContext validatorContext, Type type) {
            this.validatorContext = validatorContext;
            this.type = type;
        }

        @Override
        public Type type() {
            return this.type;
        }

        @Override
        public ElementD<?, ?> element() {
            Class<?> beanClass = TypeUtils.getRawType(this.type, null);
            return beanClass == null ? null : (BeanD)this.validatorContext.getDescriptorManager().getBeanDescriptor(beanClass);
        }
    }

    private static class DescriptorWrapper
    implements Step {
        final ElementD<?, ?> wrapped;

        DescriptorWrapper(ElementDescriptor wrapped) {
            this.wrapped = (ElementD)wrapped;
        }

        @Override
        public Type type() {
            return this.wrapped.getGenericType();
        }

        @Override
        public ElementD<?, ?> element() {
            return this.wrapped;
        }
    }

    private static interface Step {
        public Type type();

        public ElementD<?, ?> element();
    }

    static class ForPropertyValue<T>
    implements Strategy<T> {
        final ApacheFactoryContext validatorContext;
        final Class<?> rootBeanClass;
        final Object value;

        ForPropertyValue(ApacheFactoryContext validatorContext, Class<?> rootBeanClass, Object value) {
            this.validatorContext = validatorContext;
            this.rootBeanClass = rootBeanClass;
            this.value = value;
        }

        @Override
        public T getRootBean() {
            return null;
        }

        @Override
        public PathNavigation.Callback<?> callback(PathImpl.Builder pathBuilder, FindDescriptor findDescriptor, ObjectWrapper<Boolean> reachable) {
            return new WalkGraph(this.validatorContext, this.rootBeanClass, pathBuilder, findDescriptor, new ObjectWrapper<Object>(), reachable, null);
        }

        @Override
        public ValidationJob.Frame<?> frame(ValidateProperty<T> job, PathImpl path) {
            GraphContext context = new GraphContext(job.validatorContext, path, this.value);
            if (job.descriptor instanceof BeanDescriptor) {
                ValidateProperty<T> validateProperty = job;
                Objects.requireNonNull(validateProperty);
                return validateProperty.new LeafFrame(context);
            }
            ValidateProperty<T> validateProperty = job;
            Objects.requireNonNull(validateProperty);
            return new PropertyFrame(validateProperty, null, (ElementD)((PropertyD)job.descriptor), context);
        }
    }

    static class ForBeanProperty<T>
    implements Strategy<T> {
        final ApacheFactoryContext validatorContext;
        final T rootBean;
        final GraphContext rootContext;
        final ObjectWrapper<GraphContext> leafContext;
        final ObjectWrapper<Object> value;

        ForBeanProperty(ApacheFactoryContext validatorContext, T bean) {
            this.validatorContext = validatorContext;
            this.rootBean = bean;
            this.rootContext = new GraphContext(validatorContext, PathImpl.create(), bean);
            this.leafContext = new ObjectWrapper<GraphContext>(this.rootContext);
            this.value = new ObjectWrapper<T>(bean);
        }

        @Override
        public T getRootBean() {
            return this.rootBean;
        }

        @Override
        public PathNavigation.Callback<?> callback(PathImpl.Builder pathBuilder, FindDescriptor findDescriptor, ObjectWrapper<Boolean> reachable) {
            return new WalkGraph(this.validatorContext, this.rootBean.getClass(), pathBuilder, findDescriptor, this.value, reachable, (p, v) -> this.leafContext.accept(p.isRootPath() ? this.rootContext : this.rootContext.child((Path)p, v)));
        }

        @Override
        public ValidationJob.Frame<?> frame(ValidateProperty<T> job, PathImpl path) {
            if (job.descriptor instanceof BeanDescriptor) {
                ValidateProperty<T> validateProperty = job;
                Objects.requireNonNull(validateProperty);
                return validateProperty.new LeafFrame(this.leafContext.get());
            }
            ValidateProperty<T> validateProperty = job;
            Objects.requireNonNull(validateProperty);
            ValidateProperty<T> validateProperty2 = job;
            Objects.requireNonNull(validateProperty2);
            return new PropertyFrame(validateProperty, new ValidationJob.BeanFrame(validateProperty2, this.leafContext.get()), (ElementD)((PropertyD)job.descriptor), this.leafContext.get().child(path, this.value.get()));
        }
    }

    static interface Strategy<T> {
        public T getRootBean();

        public PathNavigation.Callback<?> callback(PathImpl.Builder var1, FindDescriptor var2, ObjectWrapper<Boolean> var3);

        public ValidationJob.Frame<?> frame(ValidateProperty<T> var1, PathImpl var2);
    }
}

