/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.Component;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.markup.ContainerInfo;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.resource.IFixedLocationResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkupResourceStream
implements IResourceStream,
IFixedLocationResourceStream {
    private static final long serialVersionUID = 1846489965076612828L;
    private static final Logger log = LoggerFactory.getLogger(MarkupResourceStream.class);
    public static final String WICKET_XHTML_DTD = "http://wicket.apache.org/dtds.data/wicket-xhtml1.4-strict.dtd";
    private static final Pattern DOCTYPE_REGEX = Pattern.compile("!DOCTYPE\\s+(.*)\\s*");
    private final IResourceStream resourceStream;
    private final transient ContainerInfo containerInfo;
    private final String markupClassName;
    private String cacheKey;
    private transient Markup baseMarkup;
    private String encoding;
    private String wicketNamespace;
    private String wicketId;
    private String doctype;

    public MarkupResourceStream(IResourceStream resourceStream) {
        this(resourceStream, null, null);
    }

    public MarkupResourceStream(IResourceStream resourceStream, ContainerInfo containerInfo, Class<?> markupClass) {
        this.resourceStream = Args.notNull(resourceStream, "resourceStream");
        this.containerInfo = containerInfo;
        this.markupClassName = markupClass == null ? null : markupClass.getName();
        this.setWicketNamespace("wicket");
    }

    @Override
    public String locationAsString() {
        if (this.resourceStream instanceof IFixedLocationResourceStream) {
            return ((IFixedLocationResourceStream)((Object)this.resourceStream)).locationAsString();
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.resourceStream.close();
    }

    @Override
    public String getContentType() {
        return this.resourceStream.getContentType();
    }

    @Override
    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        return this.resourceStream.getInputStream();
    }

    @Override
    public Locale getLocale() {
        return this.resourceStream.getLocale();
    }

    @Override
    public Instant lastModifiedTime() {
        return this.resourceStream.lastModifiedTime();
    }

    @Override
    public Bytes length() {
        return this.resourceStream.length();
    }

    @Override
    public void setLocale(Locale locale) {
        this.resourceStream.setLocale(locale);
    }

    public Class<? extends Component> getMarkupClass() {
        if (this.markupClassName == null) {
            throw new MarkupException("no associated markup class");
        }
        return WicketObjects.resolveClass(this.markupClassName);
    }

    public ContainerInfo getContainerInfo() {
        return this.containerInfo;
    }

    public final String getCacheKey() {
        return this.cacheKey;
    }

    public final void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    public IResourceStream getResource() {
        return this.resourceStream;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getWicketNamespace() {
        return this.wicketNamespace;
    }

    public final String getWicketId() {
        return this.wicketId;
    }

    final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public final void setWicketNamespace(String wicketNamespace) {
        this.wicketNamespace = wicketNamespace;
        this.wicketId = (wicketNamespace + ":id").intern();
        if (!"wicket".equals(wicketNamespace) && log.isDebugEnabled()) {
            log.debug("You are using a non-standard namespace name: '{}'", (Object)wicketNamespace);
        }
    }

    public MarkupResourceStream getBaseMarkupResourceStream() {
        if (this.baseMarkup == null) {
            return null;
        }
        return this.baseMarkup.getMarkupResourceStream();
    }

    public void setBaseMarkup(Markup baseMarkup) {
        this.baseMarkup = baseMarkup;
    }

    public Markup getBaseMarkup() {
        return this.baseMarkup;
    }

    @Override
    public String getStyle() {
        return this.resourceStream.getStyle();
    }

    @Override
    public String getVariation() {
        return this.resourceStream.getVariation();
    }

    @Override
    public void setStyle(String style) {
        this.resourceStream.setStyle(style);
    }

    @Override
    public void setVariation(String variation) {
        this.resourceStream.setVariation(variation);
    }

    public String toString() {
        if (this.resourceStream != null) {
            return this.resourceStream.toString();
        }
        return "(unknown resource)";
    }

    public final String getDoctype() {
        MarkupResourceStream baseMarkupResourceStream;
        if (this.doctype == null && (baseMarkupResourceStream = this.getBaseMarkupResourceStream()) != null) {
            this.doctype = baseMarkupResourceStream.getDoctype();
        }
        return this.doctype;
    }

    public final void setDoctype(CharSequence doctype) {
        if (!Strings.isEmpty(doctype)) {
            String doc = doctype.toString().replaceAll("[\n\r]+", "");
            Matcher matcher = DOCTYPE_REGEX.matcher(doc = doc.replaceAll("\\s+", " "));
            if (!matcher.matches()) {
                throw new MarkupException("Invalid DOCTYPE: '" + doctype + "'");
            }
            this.doctype = matcher.group(1).trim();
        }
    }

    public boolean isHtml5() {
        return "html".equalsIgnoreCase(this.getDoctype());
    }
}

