/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.loader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.apache.wicket.settings.ResourceSettings;
import org.apache.wicket.util.lang.Args;

public class NestedStringResourceLoader
implements IStringResourceLoader {
    private final Pattern pattern;
    private final List<IStringResourceLoader> loaders;
    private final ResourceSettings resourceSettings;

    public NestedStringResourceLoader(List<IStringResourceLoader> loaders, Pattern pattern) {
        this.loaders = new ArrayList<IStringResourceLoader>(loaders);
        this.pattern = (Pattern)Args.notNull((Object)pattern, (String)"pattern");
        this.resourceSettings = Application.get().getResourceSettings();
    }

    @Override
    public String loadStringResource(Component component, String key, Locale locale, String style, String variation) {
        return this.loadNestedStringResource(component, key, locale, style, variation);
    }

    @Override
    public String loadStringResource(Class<?> clazz, String key, Locale locale, String style, String variation) {
        return this.loadNestedStringResource(clazz, key, locale, style, variation);
    }

    private String loadNestedStringResource(Object scope, String key, Locale locale, String style, String variation) {
        Class clazz = null;
        Component component = null;
        if (scope instanceof Component) {
            component = (Component)scope;
        } else {
            clazz = (Class)scope;
        }
        Iterator<IStringResourceLoader> iter = this.loaders.iterator();
        String value = null;
        while (iter.hasNext() && value == null) {
            IStringResourceLoader loader = iter.next();
            value = component != null ? loader.loadStringResource(component, key, locale, style, variation) : loader.loadStringResource(clazz, key, locale, style, variation);
        }
        if (value == null) {
            return null;
        }
        StringBuffer output = new StringBuffer();
        Matcher matcher = this.pattern.matcher(value);
        while (matcher.find()) {
            String replacedPlaceHolder;
            String nestedKey = matcher.group(1);
            String string = replacedPlaceHolder = component != null ? this.loadNestedStringResource(component, nestedKey, locale, style, variation) : this.loadNestedStringResource(clazz, nestedKey, locale, style, variation);
            if (replacedPlaceHolder == null) {
                return null;
            }
            matcher.appendReplacement(output, replacedPlaceHolder);
        }
        matcher.appendTail(output);
        return output.toString();
    }
}

