/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.description;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/contracts/description/LazyContractProvider;", "Lorg/jetbrains/kotlin/contracts/description/AbstractContractProvider;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "computation", "Lkotlin/Function0;", "", "<init>", "(Lorg/jetbrains/kotlin/storage/StorageManager;Lkotlin/jvm/functions/Function0;)V", "isComputed", "", "contractDescription", "Lorg/jetbrains/kotlin/contracts/description/ContractDescription;", "getContractDescription", "setContractDescription", "", "resolution"})
@SourceDebugExtension(value={"SMAP\nLazyContractProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyContractProvider.kt\norg/jetbrains/kotlin/contracts/description/LazyContractProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class LazyContractProvider
extends AbstractContractProvider {
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final Function0<Object> computation;
    private volatile boolean isComputed;
    @Nullable
    private ContractDescription contractDescription;

    public LazyContractProvider(@NotNull StorageManager storageManager, @NotNull Function0<? extends Object> computation) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter(computation, (String)"computation");
        this.storageManager = storageManager;
        this.computation = computation;
    }

    @Override
    @Nullable
    public ContractDescription getContractDescription() {
        if (!this.isComputed) {
            this.storageManager.compute(this.computation);
            boolean bl = this.isComputed;
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "Computation of contract hasn't initialized contract properly";
                throw new AssertionError((Object)string2);
            }
        }
        return this.contractDescription;
    }

    public final void setContractDescription(@Nullable ContractDescription contractDescription) {
        this.contractDescription = contractDescription;
        this.isComputed = true;
    }
}

