/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;

public final class StreamIterator<E>
implements Iterator<E>,
AutoCloseable {
    private final Iterator<E> iterator;
    private final Stream<E> stream;
    private boolean closed;

    public static <T> StreamIterator<T> iterator(Stream<T> stream2) {
        return new StreamIterator<T>(stream2);
    }

    private StreamIterator(Stream<E> stream2) {
        this.stream = Objects.requireNonNull(stream2, "stream");
        this.iterator = stream2.iterator();
    }

    @Override
    public void close() {
        this.closed = true;
        this.stream.close();
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        boolean hasNext = this.iterator.hasNext();
        if (!hasNext) {
            this.close();
        }
        return hasNext;
    }

    @Override
    public E next() {
        E next = this.iterator.next();
        if (next == null) {
            this.close();
        }
        return next;
    }
}

