/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.graph.sequences;

import jlibs.core.graph.Sequence;
import jlibs.core.graph.sequences.AbstractSequence;

public class ConcatSequence<E>
extends AbstractSequence<E> {
    private Sequence<? extends E>[] sequences;
    private int curSeq;

    public ConcatSequence(Sequence<? extends E> ... sequences) {
        this.sequences = sequences;
        this._reset();
    }

    @Override
    protected E findNext() {
        while (this.curSeq < this.sequences.length) {
            E elem = this.sequences[this.curSeq].next();
            if (elem == null) {
                ++this.curSeq;
                continue;
            }
            return elem;
        }
        return null;
    }

    @Override
    public void reset() {
        super.reset();
        this._reset();
    }

    private void _reset() {
        this.curSeq = 0;
        for (Sequence<E> sequence : this.sequences) {
            sequence.reset();
        }
    }

    @Override
    public ConcatSequence<E> copy() {
        Sequence[] sequences = new Sequence[this.sequences.length];
        for (int i = 0; i < sequences.length; ++i) {
            sequences[i] = this.sequences[i].copy();
        }
        return new ConcatSequence<E>(sequences);
    }

    @Override
    public int length() {
        int len = 0;
        for (Sequence<E> sequence : this.sequences) {
            len += sequence.length();
        }
        return len;
    }
}

