/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.java;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.CollationKey;
import java.text.Collator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Platform;
import net.sf.saxon.dom.DOMEnvelope;
import net.sf.saxon.dom.DOMObjectModel;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.sort.AlphanumericCollator;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.CollationMatchKey;
import net.sf.saxon.expr.sort.SimpleCollation;
import net.sf.saxon.expr.sort.UcaCollatorUsingJava;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.java.JavaCollationFactory;
import net.sf.saxon.lib.ActiveSource;
import net.sf.saxon.lib.IDynamicLoader;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.lib.StandardModuleURIResolver;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.pull.ActiveStAXSource;
import net.sf.saxon.regex.ARegularExpression;
import net.sf.saxon.regex.JavaRegularExpression;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.resource.ActiveSAXSource;
import net.sf.saxon.resource.ActiveStreamSource;
import net.sf.saxon.resource.StandardCollectionFinder;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.DynamicLoader;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.xpath.JAXPXPathStaticContext;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JavaPlatform
implements Platform {
    static boolean tryJdk9 = true;
    private static SAXParserFactory saxParserFactory;

    @Override
    public String getDefaultLanguage() {
        return Locale.getDefault().getLanguage();
    }

    @Override
    public String getDefaultCountry() {
        return Locale.getDefault().getCountry();
    }

    @Override
    public InputStream locateResource(String filename, List<String> messages) {
        URL url;
        filename = "net/sf/saxon/data/" + filename;
        ClassLoader loader = null;
        try {
            loader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception err) {
            messages.add("Failed to getContextClassLoader() - continuing\n");
        }
        InputStream in = null;
        if (loader != null) {
            URL u = loader.getResource(filename);
            in = loader.getResourceAsStream(filename);
            if (in == null) {
                messages.add("Cannot read " + filename + " file located using ClassLoader " + loader + " - continuing\n");
            }
        }
        if (in == null && (loader = Configuration.class.getClassLoader()) != null && (in = loader.getResourceAsStream(filename)) == null) {
            messages.add("Cannot read " + filename + " file located using ClassLoader " + loader + " - continuing\n");
        }
        if (in == null && (url = ClassLoader.getSystemResource(filename)) != null) {
            try {
                in = url.openStream();
            }
            catch (IOException ioe) {
                messages.add("IO error " + ioe.getMessage() + " reading " + filename + " located using getSystemResource(): using defaults");
                in = null;
            }
        }
        return in;
    }

    @Override
    public boolean JAXPStaticContextCheck(RetainedStaticContext retainedStaticContext, StaticContext sc) {
        if (sc instanceof JAXPXPathStaticContext && !(((JAXPXPathStaticContext)sc).getNamespaceContext() instanceof NamespaceResolver)) {
            this.setNamespacesFromJAXP(retainedStaticContext, (JAXPXPathStaticContext)sc);
            return true;
        }
        return false;
    }

    private void setNamespacesFromJAXP(RetainedStaticContext retainedStaticContext, JAXPXPathStaticContext sc) {
        final NamespaceContext nc = sc.getNamespaceContext();
        retainedStaticContext.setNamespaces(new NamespaceResolver(){

            @Override
            public NamespaceUri getURIForPrefix(String prefix, boolean useDefault) {
                return NamespaceUri.of(nc.getNamespaceURI(prefix));
            }

            @Override
            public Iterator<String> iteratePrefixes() {
                throw new UnsupportedOperationException();
            }
        });
    }

    @Override
    public void initialize(Configuration config) {
        config.registerExternalObjectModel(DOMEnvelope.getInstance());
        config.registerExternalObjectModel(DOMObjectModel.getInstance());
        config.setCollectionFinder(new StandardCollectionFinder());
    }

    @Override
    public boolean isJava() {
        return true;
    }

    @Override
    public boolean isDotNet() {
        return false;
    }

    @Override
    public String getPlatformVersion() {
        return "Java version " + System.getProperty("java.version");
    }

    @Override
    public boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    @Override
    public String getPlatformSuffix() {
        return "J";
    }

    @Override
    public IDynamicLoader getDefaultDynamicLoader() {
        return new DynamicLoader();
    }

    @Override
    public XMLReader loadParser() {
        XMLReader parser;
        if (saxParserFactory == null) {
            saxParserFactory = SAXParserFactory.newInstance();
        }
        try {
            parser = saxParserFactory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException | SAXException err) {
            throw new TransformerFactoryConfigurationError(err);
        }
        return parser;
    }

    @Override
    public XMLReader loadParserForXmlFragments() {
        SAXParserFactory factory = null;
        if (tryJdk9) {
            try {
                Method method = SAXParserFactory.class.getMethod("newDefaultInstance", new Class[0]);
                Object result = method.invoke(null, new Object[0]);
                factory = (SAXParserFactory)result;
            }
            catch (Exception e) {
                tryJdk9 = false;
            }
        }
        if (factory == null) {
            try {
                Class<?> factoryClass = Class.forName("com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
                factory = (SAXParserFactory)factoryClass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (factory != null) {
            try {
                return factory.newSAXParser().getXMLReader();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.loadParser();
    }

    @Override
    public ActiveSource resolveSource(Source source, Configuration config) throws XPathException {
        if (source instanceof ActiveSource) {
            return (ActiveSource)source;
        }
        if (source instanceof SAXSource) {
            if (((SAXSource)source).getXMLReader() == null) {
                XMLReader sourceParser = config.getSourceParser();
                ((SAXSource)source).setXMLReader(sourceParser);
                ActiveSAXSource activeSource = new ActiveSAXSource((SAXSource)source);
                activeSource.setParserPool(config::reuseSourceParser);
                return activeSource;
            }
            return new ActiveSAXSource((SAXSource)source);
        }
        if (source instanceof StreamSource) {
            return new ActiveStreamSource((StreamSource)source);
        }
        if (source instanceof StAXSource) {
            try {
                return ActiveStAXSource.fromStAXSource((StAXSource)source);
            }
            catch (XMLStreamException e) {
                throw new XPathException(e);
            }
        }
        return null;
    }

    @Override
    public StringCollator makeCollation(Configuration config, Properties props, String uri) throws XPathException {
        return JavaCollationFactory.makeCollation(config, uri, props);
    }

    @Override
    public boolean canReturnCollationKeys(StringCollator collation) {
        return !(collation instanceof SimpleCollation) || ((SimpleCollation)collation).getComparator() instanceof Collator;
    }

    @Override
    public AtomicMatchKey getCollationKey(SimpleCollation namedCollation, String value) {
        CollationKey ck = ((Collator)namedCollation.getComparator()).getCollationKey(value);
        return new CollationMatchKey(ck);
    }

    @Override
    public boolean hasICUCollator() {
        return false;
    }

    @Override
    public boolean hasICUNumberer() {
        return false;
    }

    @Override
    public StringCollator makeUcaCollator(String uri, Configuration config) throws XPathException {
        UcaCollatorUsingJava collator = new UcaCollatorUsingJava(uri, config);
        if ("yes".equals(collator.getProperties().getProperty("numeric"))) {
            return new AlphanumericCollator(collator);
        }
        return collator;
    }

    @Override
    public RegularExpression compileRegularExpression(Configuration config, UnicodeString regex, String flags, String hostLanguage, List<String> warnings) throws XPathException {
        if (flags.contains("!")) {
            return new JavaRegularExpression(regex, flags.replace("!", ""));
        }
        boolean useJava = false;
        boolean useSaxon = false;
        int semi = flags.indexOf(59);
        if (semi >= 0) {
            useJava = flags.indexOf(106, semi) >= 0;
            boolean bl = useSaxon = flags.indexOf(115, semi) >= 0;
        }
        if ("J".equals(config.getDefaultRegexEngine()) && !useSaxon) {
            useJava = true;
        }
        if (useJava) {
            flags = flags.substring(0, semi);
            return new JavaRegularExpression(regex, flags);
        }
        return new ARegularExpression(regex, flags, hostLanguage, warnings, config);
    }

    public void addFunctionLibraries(FunctionLibraryList list, Configuration config, int hostLanguage) {
    }

    @Override
    public ExternalObjectType getExternalObjectType(Configuration config, NamespaceUri uri, String localName) {
        throw new UnsupportedOperationException("getExternalObjectType for Java");
    }

    @Override
    public String getInstallationDirectory(String edition, Configuration config) {
        try {
            return System.getenv("SAXON_HOME");
        }
        catch (SecurityException e) {
            return null;
        }
    }

    @Override
    public void registerAllBuiltInObjectModels(Configuration config) {
    }

    @Override
    public void setDefaultSAXParserFactory(Configuration config) {
    }

    @Override
    public ModuleURIResolver makeStandardModuleURIResolver(Configuration config) {
        return new StandardModuleURIResolver(config);
    }
}

