/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.abi;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.metadata.jvm.JvmFieldSignature;
import kotlin.metadata.jvm.JvmMemberSignature;
import kotlin.metadata.jvm.JvmMethodSignature;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.extensions.ClassGenerator;
import org.jetbrains.kotlin.backend.jvm.extensions.ClassGeneratorExtension;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.jvm.abi.AbiClassInfo;
import org.jetbrains.kotlin.jvm.abi.AbiMethodInfo;
import org.jetbrains.kotlin.jvm.abi.JvmAbiClassBuilderInterceptorKt;
import org.jetbrains.kotlin.jvm.abi.JvmAbiClassInfoBuilder;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.RecordComponentVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bJ\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/JvmAbiClassBuilderInterceptor;", "Lorg/jetbrains/kotlin/backend/jvm/extensions/ClassGeneratorExtension;", "removeDataClassCopyIfConstructorIsPrivate", "", "removePrivateClasses", "treatInternalAsPrivate", "<init>", "(ZZZ)V", "abiClassInfoBuilder", "Lorg/jetbrains/kotlin/jvm/abi/JvmAbiClassInfoBuilder;", "buildAbiClassInfoAndReleaseResources", "", "", "Lorg/jetbrains/kotlin/jvm/abi/AbiClassInfo;", "generateClass", "Lorg/jetbrains/kotlin/backend/jvm/extensions/ClassGenerator;", "generator", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "AbiInfoClassGenerator", "jvm-abi-gen"})
public final class JvmAbiClassBuilderInterceptor
implements ClassGeneratorExtension {
    private final boolean removeDataClassCopyIfConstructorIsPrivate;
    private final boolean removePrivateClasses;
    private final boolean treatInternalAsPrivate;
    @NotNull
    private JvmAbiClassInfoBuilder abiClassInfoBuilder;

    public JvmAbiClassBuilderInterceptor(boolean removeDataClassCopyIfConstructorIsPrivate, boolean removePrivateClasses, boolean treatInternalAsPrivate) {
        this.removeDataClassCopyIfConstructorIsPrivate = removeDataClassCopyIfConstructorIsPrivate;
        this.removePrivateClasses = removePrivateClasses;
        this.treatInternalAsPrivate = treatInternalAsPrivate;
        this.abiClassInfoBuilder = new JvmAbiClassInfoBuilder(this.removePrivateClasses);
    }

    @NotNull
    public final Map<String, AbiClassInfo> buildAbiClassInfoAndReleaseResources() {
        Map<String, AbiClassInfo> map;
        Map<String, AbiClassInfo> it = map = this.abiClassInfoBuilder.buildClassInfo();
        boolean bl = false;
        this.abiClassInfoBuilder = new JvmAbiClassInfoBuilder(this.removePrivateClasses);
        return map;
    }

    @NotNull
    public ClassGenerator generateClass(@NotNull ClassGenerator generator, @Nullable IrClass declaration) {
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        return new AbiInfoClassGenerator(generator, declaration);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006JG\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u00020\u000f2\b\u00103\u001a\u0004\u0018\u00010\u000f2\u0006\u00104\u001a\u00020\u000f2\u000e\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f06H\u0016\u00a2\u0006\u0002\u00107J$\u00108\u001a\u00020.2\u0006\u00109\u001a\u00020\u000f2\b\u00102\u001a\u0004\u0018\u00010\u000f2\b\u0010:\u001a\u0004\u0018\u00010\u000fH\u0016J>\u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010>2\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u000f2\b\u00103\u001a\u0004\u0018\u00010\u000f2\b\u0010?\u001a\u0004\u0018\u00010@H\u0016JK\u0010A\u001a\u00020B2\b\u0010=\u001a\u0004\u0018\u00010C2\u0006\u00101\u001a\u0002002\u0006\u00102\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u000f2\b\u00103\u001a\u0004\u0018\u00010\u000f2\u0010\u0010D\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000f\u0018\u000106H\u0016\u00a2\u0006\u0002\u0010EJ\u0018\u0010F\u001a\u00020G2\u0006\u0010:\u001a\u00020\u000f2\u0006\u0010H\u001a\u00020\bH\u0016J,\u0010I\u001a\u00020.2\u0006\u00102\u001a\u00020\u000f2\b\u0010J\u001a\u0004\u0018\u00010\u000f2\b\u0010K\u001a\u0004\u0018\u00010\u000f2\u0006\u00101\u001a\u000200H\u0016J\u0010\u0010L\u001a\u00020.2\u0006\u0010M\u001a\u00020\bH\u0016J#\u0010O\u001a\u00020P2\u0006\u00102\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u000f2\b\u00103\u001a\u0004\u0018\u00010\u000fH\u0096\u0001J\u001b\u0010Q\u001a\u00020.2\u0006\u00102\u001a\u00020\u000f2\b\u0010R\u001a\u0004\u0018\u00010\u000fH\u0096\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u001d\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010N\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010\u001c\u00a8\u0006S"}, d2={"Lorg/jetbrains/kotlin/jvm/abi/JvmAbiClassBuilderInterceptor$AbiInfoClassGenerator;", "Lorg/jetbrains/kotlin/backend/jvm/extensions/ClassGenerator;", "delegate", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "<init>", "(Lorg/jetbrains/kotlin/jvm/abi/JvmAbiClassBuilderInterceptor;Lorg/jetbrains/kotlin/backend/jvm/extensions/ClassGenerator;Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "isPrivateClass", "", "isDataClass", "removeClassFromAbi", "primaryConstructorIsNotInAbi", "getPrimaryConstructorIsNotInAbi$annotations", "()V", "internalName", "", "getInternalName", "()Ljava/lang/String;", "setInternalName", "(Ljava/lang/String;)V", "superInterfaces", "", "getSuperInterfaces", "()Ljava/util/List;", "setSuperInterfaces", "(Ljava/util/List;)V", "localOrAnonymousClass", "getLocalOrAnonymousClass", "()Z", "setLocalOrAnonymousClass", "(Z)V", "keepClassAsIs", "getKeepClassAsIs", "setKeepClassAsIs", "memberInfos", "", "Lkotlin/metadata/jvm/JvmMemberSignature;", "Lorg/jetbrains/kotlin/jvm/abi/AbiMethodInfo;", "getMemberInfos", "()Ljava/util/Map;", "maskedMethods", "", "Lkotlin/metadata/jvm/JvmMethodSignature;", "getMaskedMethods", "()Ljava/util/Set;", "defineClass", "", "version", "", "access", "name", "signature", "superName", "interfaces", "", "(IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "visitEnclosingMethod", "owner", "desc", "newField", "Lorg/jetbrains/org/objectweb/asm/FieldVisitor;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "value", "", "newMethod", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "exceptions", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "visitAnnotation", "Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "visible", "visitInnerClass", "outerName", "innerName", "done", "generateSmapCopyToAnnotation", "isWhenMappingClass", "newRecordComponent", "Lorg/jetbrains/org/objectweb/asm/RecordComponentVisitor;", "visitSource", "debug", "jvm-abi-gen"})
    private final class AbiInfoClassGenerator
    implements ClassGenerator {
        @NotNull
        private final ClassGenerator delegate;
        private final boolean isPrivateClass;
        private final boolean isDataClass;
        private final boolean removeClassFromAbi;
        private final boolean primaryConstructorIsNotInAbi;
        public String internalName;
        public List<String> superInterfaces;
        private boolean localOrAnonymousClass;
        private boolean keepClassAsIs;
        @NotNull
        private final Map<JvmMemberSignature, AbiMethodInfo> memberInfos;
        @NotNull
        private final Set<JvmMethodSignature> maskedMethods;

        /*
         * WARNING - void declaration
         */
        public AbiInfoClassGenerator(@Nullable ClassGenerator delegate, IrClass irClass) {
            boolean bl;
            DescriptorVisibility descriptorVisibility;
            IrConstructor irConstructor;
            Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
            this.delegate = delegate;
            this.isPrivateClass = irClass != null && DescriptorVisibilities.isPrivate((DescriptorVisibility)irClass.getVisibility());
            this.isDataClass = irClass != null && irClass.isData();
            this.removeClassFromAbi = JvmAbiClassBuilderInterceptorKt.access$shouldRemoveFromAbi(irClass, JvmAbiClassBuilderInterceptor.this.removePrivateClasses, JvmAbiClassBuilderInterceptor.this.treatInternalAsPrivate);
            AbiInfoClassGenerator abiInfoClassGenerator = this;
            if (irClass != null && (irConstructor = IrUtilsKt.getPrimaryConstructor((IrClass)irClass)) != null && (descriptorVisibility = irConstructor.getVisibility()) != null) {
                void it;
                DescriptorVisibility descriptorVisibility2 = descriptorVisibility;
                JvmAbiClassBuilderInterceptor jvmAbiClassBuilderInterceptor = JvmAbiClassBuilderInterceptor.this;
                DescriptorVisibility descriptorVisibility3 = descriptorVisibility2;
                AbiInfoClassGenerator abiInfoClassGenerator2 = abiInfoClassGenerator;
                boolean bl2 = false;
                boolean bl3 = DescriptorVisibilities.isPrivate((DescriptorVisibility)it) || jvmAbiClassBuilderInterceptor.treatInternalAsPrivate && Intrinsics.areEqual((Object)it, (Object)DescriptorVisibilities.INTERNAL);
                abiInfoClassGenerator = abiInfoClassGenerator2;
                bl = bl3;
            } else {
                bl = false;
            }
            abiInfoClassGenerator.primaryConstructorIsNotInAbi = bl;
            this.memberInfos = new LinkedHashMap();
            this.maskedMethods = new LinkedHashSet();
        }

        private static /* synthetic */ void getPrimaryConstructorIsNotInAbi$annotations() {
        }

        @NotNull
        public final String getInternalName() {
            String string = this.internalName;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"internalName");
            return null;
        }

        public final void setInternalName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.internalName = string;
        }

        @NotNull
        public final List<String> getSuperInterfaces() {
            List<String> list = this.superInterfaces;
            if (list != null) {
                return list;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"superInterfaces");
            return null;
        }

        public final void setSuperInterfaces(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.superInterfaces = list;
        }

        public final boolean getLocalOrAnonymousClass() {
            return this.localOrAnonymousClass;
        }

        public final void setLocalOrAnonymousClass(boolean bl) {
            this.localOrAnonymousClass = bl;
        }

        public final boolean getKeepClassAsIs() {
            return this.keepClassAsIs;
        }

        public final void setKeepClassAsIs(boolean bl) {
            this.keepClassAsIs = bl;
        }

        @NotNull
        public final Map<JvmMemberSignature, AbiMethodInfo> getMemberInfos() {
            return this.memberInfos;
        }

        @NotNull
        public final Set<JvmMethodSignature> getMaskedMethods() {
            return this.maskedMethods;
        }

        public void defineClass(int version, int access, @NotNull String name, @Nullable String signature, @NotNull String superName, @NotNull String[] interfaces) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)superName, (String)"superName");
            Intrinsics.checkNotNullParameter((Object)interfaces, (String)"interfaces");
            this.keepClassAsIs = this.keepClassAsIs || (access & 0x2000) != 0;
            this.setInternalName(name);
            this.setSuperInterfaces(ArraysKt.asList((Object[])interfaces));
            this.delegate.defineClass(version, access, name, signature, superName, interfaces);
        }

        public void visitEnclosingMethod(@NotNull String owner, @Nullable String name, @Nullable String desc) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            this.localOrAnonymousClass = true;
            this.delegate.visitEnclosingMethod(owner, name, desc);
        }

        @NotNull
        public FieldVisitor newField(@Nullable IrField declaration, int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable Object value) {
            IrField visibility2;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            FieldVisitor field = this.delegate.newField(declaration, access, name, desc, signature, value);
            if (this.keepClassAsIs || this.removeClassFromAbi) {
                return field;
            }
            IrField irField = declaration;
            if (irField == null || (irField = irField.getVisibility()) == null) {
                irField = DescriptorVisibilities.DEFAULT_VISIBILITY;
            }
            if (DescriptorVisibilities.isPrivate((DescriptorVisibility)(visibility2 = irField))) {
                return field;
            }
            if (JvmAbiClassBuilderInterceptor.this.treatInternalAsPrivate && Intrinsics.areEqual((Object)visibility2, (Object)DescriptorVisibilities.INTERNAL)) {
                return field;
            }
            this.memberInfos.put(new JvmFieldSignature(name, desc), AbiMethodInfo.KEEP);
            return field;
        }

        @NotNull
        public MethodVisitor newMethod(@Nullable IrFunction declaration, int access, @NotNull String name, @NotNull String desc, @Nullable String signature, @Nullable String[] exceptions) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            MethodVisitor method = this.delegate.newMethod(declaration, access, name, desc, signature, exceptions);
            if (this.keepClassAsIs || this.removeClassFromAbi) {
                return method;
            }
            if (StringsKt.endsWith$default((String)name, (String)"$$forInline", (boolean)false, (int)2, null) && !this.isPrivateClass) {
                this.memberInfos.put(new JvmMethodSignature(name, desc), AbiMethodInfo.KEEP);
                ((Collection)this.maskedMethods).add(new JvmMethodSignature(StringsKt.removeSuffix((String)name, (CharSequence)"$$forInline"), desc));
                return method;
            }
            if ((access & 2) != 0 && declaration != null && DescriptorVisibilities.isPrivate((DescriptorVisibility)declaration.getVisibility()) || Intrinsics.areEqual((Object)name, (Object)"<clinit>") || StringsKt.startsWith$default((String)name, (String)"access$", (boolean)false, (int)2, null) && (access & 0x1000) != 0) {
                return method;
            }
            if (JvmAbiClassBuilderInterceptor.this.treatInternalAsPrivate) {
                IrFunction irFunction = declaration;
                if (Intrinsics.areEqual((Object)(irFunction != null ? irFunction.getVisibility() : null), (Object)DescriptorVisibilities.INTERNAL)) {
                    return method;
                }
            }
            if (this.isDataClass && this.primaryConstructorIsNotInAbi) {
                boolean removeCopy;
                String string = name;
                boolean bl = Intrinsics.areEqual((Object)string, (Object)"copy") ? JvmAbiClassBuilderInterceptor.this.removeDataClassCopyIfConstructorIsPrivate : (Intrinsics.areEqual((Object)string, (Object)"copy$default") ? JvmAbiClassBuilderInterceptor.this.removeDataClassCopyIfConstructorIsPrivate || (access & 1) == 0 : (removeCopy = false));
                if (removeCopy) {
                    return method;
                }
            }
            IrFunction irFunction = declaration;
            boolean bl = irFunction != null ? irFunction.isInline() : false;
            if (bl && !this.isPrivateClass) {
                this.memberInfos.put(new JvmMethodSignature(name, desc), AbiMethodInfo.KEEP);
            } else {
                this.memberInfos.put(new JvmMethodSignature(name, desc), AbiMethodInfo.STRIP);
            }
            return method;
        }

        @NotNull
        public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            AnnotationVisitor delegate = this.delegate.visitAnnotation(desc, visible);
            if (this.keepClassAsIs || !Intrinsics.areEqual((Object)desc, (Object)JvmAnnotationNames.METADATA_DESC)) {
                return delegate;
            }
            return new AnnotationVisitor(delegate, this){
                final /* synthetic */ AbiInfoClassGenerator this$0;
                {
                    this.this$0 = $receiver;
                    super(589824, $delegate);
                }

                public void visit(String name, Object value) {
                    if (Intrinsics.areEqual((Object)name, (Object)"xi") && value instanceof Integer) {
                        this.this$0.setKeepClassAsIs(this.this$0.getKeepClassAsIs() || (((Number)value).intValue() & 0x80) != 0);
                    }
                    super.visit(name, value);
                }
            };
        }

        public void visitInnerClass(@NotNull String name, @Nullable String outerName, @Nullable String innerName, int access) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            JvmAbiClassBuilderInterceptor.this.abiClassInfoBuilder.addInnerClass(name, outerName);
            this.delegate.visitInnerClass(name, outerName, innerName, access);
        }

        public void done(boolean generateSmapCopyToAnnotation) {
            AbiClassInfo abiClassInfo;
            if (this.keepClassAsIs) {
                abiClassInfo = AbiClassInfo.Public.INSTANCE;
            } else if (this.removeClassFromAbi) {
                abiClassInfo = AbiClassInfo.Deleted.INSTANCE;
            } else if (this.localOrAnonymousClass) {
                abiClassInfo = AbiClassInfo.Deleted.INSTANCE;
            } else if (this.isWhenMappingClass()) {
                abiClassInfo = AbiClassInfo.Deleted.INSTANCE;
            } else {
                for (JvmMethodSignature method : this.maskedMethods) {
                    this.memberInfos.put(method, AbiMethodInfo.STRIP);
                }
                abiClassInfo = new AbiClassInfo.Stripped(this.memberInfos, false, 2, null);
            }
            AbiClassInfo classInfo = abiClassInfo;
            JvmAbiClassBuilderInterceptor.this.abiClassInfoBuilder.recordInitialClassInfo(this.getInternalName(), classInfo, this.getSuperInterfaces());
            this.delegate.done(generateSmapCopyToAnnotation);
        }

        private final boolean isWhenMappingClass() {
            return StringsKt.endsWith$default((String)this.getInternalName(), (String)"$WhenMappings", (boolean)false, (int)2, null);
        }

        @NotNull
        public RecordComponentVisitor newRecordComponent(@NotNull String name, @NotNull String desc, @Nullable String signature) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            return this.delegate.newRecordComponent(name, desc, signature);
        }

        public void visitSource(@NotNull String name, @Nullable String debug) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.delegate.visitSource(name, debug);
        }
    }
}

