/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.xmpp.util;

import java.io.ByteArrayInputStream;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;

public class XMPPClientSidePacketListener
implements PacketListener {
    private static Log log = LogFactory.getLog(XMPPClientSidePacketListener.class);
    private MessageContext messageContext = null;
    private boolean responseReceived;

    public XMPPClientSidePacketListener(MessageContext messageContext) {
        this.messageContext = messageContext;
    }

    public void processPacket(Packet packet) {
        Message message = (Message)packet;
        String xml = StringEscapeUtils.unescapeXml((String)message.getBody());
        log.info((Object)("Client received message : " + xml));
        this.responseReceived = true;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes());
        this.messageContext.setProperty("TRANSPORT_IN", (Object)inputStream);
    }

    public boolean isResponseReceived() {
        return this.responseReceived;
    }
}

