/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.beanutils.BasicDynaBean;
import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.BenchBean;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.LazyDynaBean;
import org.apache.commons.beanutils.LazyDynaList;
import org.apache.commons.beanutils.LazyDynaMap;
import org.apache.commons.beanutils.TestBean;
import org.apache.commons.beanutils.WrapDynaBean;

public class LazyDynaListTestCase
extends TestCase {
    private static final String BASIC_PROP1 = "BasicDynaClass_Property1";
    private static final String BASIC_PROP2 = "BasicDynaClass_Property2";
    protected DynaProperty[] properties = new DynaProperty[]{new DynaProperty("BasicDynaClass_Property1", String.class), new DynaProperty("BasicDynaClass_Property2", HashMap.class)};
    protected DynaClass treeMapDynaClass = new LazyDynaMap(new TreeMap());
    protected DynaClass hashMapDynaClass = new LazyDynaMap(new HashMap());
    protected DynaClass pojoDynaClass = new WrapDynaBean((Object)new TestBean()).getDynaClass();
    protected DynaClass basicDynaClass = new BasicDynaClass("test", BasicDynaBean.class, this.properties);

    public static void main(String[] args) {
        TestRunner.run((Test)LazyDynaListTestCase.suite());
    }

    public static Test suite() {
        return new TestSuite(LazyDynaListTestCase.class);
    }

    public LazyDynaListTestCase(String name) {
        super(name);
    }

    private void dynaBeanTest(LazyDynaList list, Class<?> testClass, DynaClass testDynaClass, Object wrongBean) {
        Object dynaBean = list.get(1);
        LazyDynaListTestCase.assertNotNull((String)"1. DynaBean Not Created", (Object)dynaBean);
        LazyDynaListTestCase.assertEquals((String)"2. Wrong Type", testClass, dynaBean.getClass());
        Object[] array = list.toArray();
        LazyDynaListTestCase.assertNotNull((String)"3. Array Not Created", (Object)array);
        LazyDynaListTestCase.assertEquals((String)"4. Not DynaBean[]", testClass, array.getClass().getComponentType());
        DynaBean[] dynaArray = (DynaBean[])array;
        LazyDynaListTestCase.assertEquals((String)"5. Array Size Wrong", (int)2, (int)dynaArray.length);
        dynaBean = list.get(3);
        LazyDynaListTestCase.assertNotNull((String)"6. DynaBean Not Created", (Object)dynaBean);
        LazyDynaListTestCase.assertEquals((String)"7. Wrong type", testClass, dynaBean.getClass());
        array = list.toArray();
        LazyDynaListTestCase.assertNotNull((String)"8. Array Not Created", (Object)array);
        LazyDynaListTestCase.assertEquals((String)"9. Not DynaBean[]", testClass, array.getClass().getComponentType());
        dynaArray = (DynaBean[])array;
        LazyDynaListTestCase.assertEquals((String)"10. Array Size Wrong", (int)4, (int)dynaArray.length);
        try {
            list.add(2, wrongBean);
            LazyDynaListTestCase.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String testProperty = this.findStringProperty(testDynaClass);
        LazyDynaListTestCase.assertNotNull((String)"Test Property Not Found", (Object)testProperty);
        dynaArray = list.toDynaBeanArray();
        for (int i = 0; i < dynaArray.length; ++i) {
            dynaArray[i].set(testProperty, (Object)("orig_pos" + i));
        }
        ArrayList<DynaBean> collection = new ArrayList<DynaBean>();
        try {
            collection.add(testDynaClass.newInstance());
            collection.add(testDynaClass.newInstance());
            collection.add(testDynaClass.newInstance());
        }
        catch (Exception ex) {
            LazyDynaListTestCase.fail((String)("1. FAILED: " + ex));
        }
        int expectedSize = dynaArray.length + collection.size();
        String origValue = (String)((DynaBean)collection.get(0)).get(testProperty);
        ((DynaBean)collection.get(0)).set(testProperty, (Object)(origValue + "_updated_" + 0));
        ((DynaBean)collection.get(1)).set(testProperty, (Object)(origValue + "_updated_" + 1));
        ((DynaBean)collection.get(2)).set(testProperty, (Object)(origValue + "_updated_" + 2));
        list.addAll(1, collection);
        dynaArray = list.toDynaBeanArray();
        dynaArray = list.toDynaBeanArray();
        LazyDynaListTestCase.assertEquals((String)"11. Array Size Wrong", (int)expectedSize, (int)dynaArray.length);
        LazyDynaListTestCase.assertEquals((String)"12. Wrong Value", (Object)"orig_pos0", (Object)dynaArray[0].get(testProperty));
        LazyDynaListTestCase.assertEquals((String)"13. Wrong Value", (Object)(origValue + "_updated_" + 0), (Object)dynaArray[1].get(testProperty));
        LazyDynaListTestCase.assertEquals((String)"14. Wrong Value", (Object)(origValue + "_updated_" + 1), (Object)dynaArray[2].get(testProperty));
        LazyDynaListTestCase.assertEquals((String)"15. Wrong Value", (Object)(origValue + "_updated_" + 2), (Object)dynaArray[3].get(testProperty));
        LazyDynaListTestCase.assertEquals((String)"16. Wrong Value", (Object)"orig_pos1", (Object)dynaArray[4].get(testProperty));
        try {
            DynaBean extraElement = testDynaClass.newInstance();
            extraElement.set(testProperty, (Object)"extraOne");
            list.add(2, (Object)extraElement);
            dynaArray = list.toDynaBeanArray();
            LazyDynaListTestCase.assertEquals((String)"17. Wrong Value", (Object)(origValue + "_updated_" + 0), (Object)dynaArray[1].get(testProperty));
            LazyDynaListTestCase.assertEquals((String)"18. Wrong Value", (Object)"extraOne", (Object)dynaArray[2].get(testProperty));
            LazyDynaListTestCase.assertEquals((String)"19. Wrong Value", (Object)(origValue + "_updated_" + 1), (Object)dynaArray[3].get(testProperty));
        }
        catch (Exception ex) {
            LazyDynaListTestCase.fail((String)("2. FAILED: " + ex));
        }
    }

    private String findStringProperty(DynaClass dynaClass) {
        DynaProperty[] properties;
        for (DynaProperty propertie : properties = dynaClass.getDynaProperties()) {
            if (propertie.getType() != String.class) continue;
            return propertie.getName();
        }
        return null;
    }

    private void mapTest(LazyDynaList list, Class<?> testClass, Object wrongBean) {
        Object dynaBean = list.get(0);
        LazyDynaListTestCase.assertNotNull((String)"1. DynaBean Not Created", (Object)dynaBean);
        LazyDynaListTestCase.assertEquals((String)"2. Not LazyDynaMap", LazyDynaMap.class, dynaBean.getClass());
        Map map = ((LazyDynaMap)dynaBean).getMap();
        LazyDynaListTestCase.assertNotNull((String)"3. Map Not Created", (Object)map);
        LazyDynaListTestCase.assertEquals((String)"4. Wrong Map", testClass, map.getClass());
        Object[] array = list.toArray();
        LazyDynaListTestCase.assertNotNull((String)"5. Array Not Created", (Object)array);
        LazyDynaListTestCase.assertEquals((String)"6. Not Map[]", testClass, array.getClass().getComponentType());
        Map[] mapArray = (Map[])array;
        LazyDynaListTestCase.assertEquals((String)"7. Array Size Wrong", (int)1, (int)mapArray.length);
        dynaBean = list.get(2);
        LazyDynaListTestCase.assertNotNull((String)"8. DynaBean Not Created", (Object)dynaBean);
        LazyDynaListTestCase.assertEquals((String)"9. Not LazyDynaMap", LazyDynaMap.class, dynaBean.getClass());
        map = ((LazyDynaMap)dynaBean).getMap();
        LazyDynaListTestCase.assertNotNull((String)"10. Map Not Created", (Object)map);
        LazyDynaListTestCase.assertEquals((String)"11. Wrong Map", testClass, map.getClass());
        array = list.toArray();
        LazyDynaListTestCase.assertNotNull((String)"12. Array Not Created", (Object)array);
        LazyDynaListTestCase.assertEquals((String)"13. Not Map[]", testClass, array.getClass().getComponentType());
        mapArray = (Map[])array;
        LazyDynaListTestCase.assertEquals((String)"14. Array Size Wrong", (int)3, (int)mapArray.length);
        try {
            list.add(2, wrongBean);
            LazyDynaListTestCase.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void pojoTest(LazyDynaList list, Class<?> testClass, Object wrongBean) {
        Object dynaBean = list.get(0);
        LazyDynaListTestCase.assertNotNull((String)"1. DynaBean Not Created", (Object)dynaBean);
        LazyDynaListTestCase.assertEquals((String)"2. Not WrapDynaBean", WrapDynaBean.class, dynaBean.getClass());
        Object pojoBean = ((WrapDynaBean)dynaBean).getInstance();
        LazyDynaListTestCase.assertNotNull((String)"3. POJO Not Created", (Object)pojoBean);
        LazyDynaListTestCase.assertEquals((String)"4. Not WrapDynaBean", testClass, pojoBean.getClass());
        Object[] array = list.toArray();
        LazyDynaListTestCase.assertNotNull((String)"5. Array Not Created", (Object)array);
        LazyDynaListTestCase.assertEquals((String)"6. Wrong array", testClass, array.getClass().getComponentType());
        Object[] pojoArray = array;
        LazyDynaListTestCase.assertEquals((String)"7. Array Size Wrong", (int)1, (int)pojoArray.length);
        dynaBean = list.get(1);
        LazyDynaListTestCase.assertNotNull((String)"8. DynaBean Not Created", (Object)dynaBean);
        LazyDynaListTestCase.assertEquals((String)"9. Not WrapDynaBean", WrapDynaBean.class, dynaBean.getClass());
        pojoBean = ((WrapDynaBean)dynaBean).getInstance();
        LazyDynaListTestCase.assertNotNull((String)"10. POJO Not Created", (Object)pojoBean);
        LazyDynaListTestCase.assertEquals((String)"11. Not WrapDynaBean", testClass, pojoBean.getClass());
        array = list.toArray();
        LazyDynaListTestCase.assertNotNull((String)"12. Array Not Created", (Object)array);
        LazyDynaListTestCase.assertEquals((String)"13. Wrong array", testClass, array.getClass().getComponentType());
        pojoArray = array;
        LazyDynaListTestCase.assertEquals((String)"14. Array Size Wrong", (int)2, (int)pojoArray.length);
        try {
            list.add(2, wrongBean);
            LazyDynaListTestCase.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private Object serializeDeserialize(Object target, String text) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(target);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            LazyDynaListTestCase.fail((String)(text + ": Exception during serialization: " + e));
        }
        Object result = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            result = ois.readObject();
            bais.close();
        }
        catch (Exception e) {
            LazyDynaListTestCase.fail((String)(text + ": Exception during deserialization: " + e));
        }
        return result;
    }

    public void setUp() throws Exception {
    }

    public void tearDown() {
    }

    public void testCollection(LazyDynaList list, Class<?> testClass, DynaClass testDynaClass, Object wrongBean) {
        int i;
        int size = 5;
        ArrayList<TreeMap> testList = new ArrayList<TreeMap>(5);
        Object[] testArray = new TreeMap[5];
        for (int i2 = 0; i2 < 5; ++i2) {
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("prop" + i2, "val" + i2);
            testArray[i2] = map;
            testList.add(testArray[i2]);
        }
        LazyDynaList lazyList = new LazyDynaList(testList);
        LazyDynaListTestCase.assertEquals((String)"1. check size", (int)5, (int)lazyList.size());
        DynaBean[] dynaArray = lazyList.toDynaBeanArray();
        TreeMap[] mapArray = (TreeMap[])lazyList.toArray();
        LazyDynaListTestCase.assertEquals((String)"2. check size", (int)5, (int)dynaArray.length);
        LazyDynaListTestCase.assertEquals((String)"3. check size", (int)5, (int)mapArray.length);
        for (i = 0; i < 5; ++i) {
            LazyDynaListTestCase.assertEquals((String)("4." + i + " DynaBean error "), (Object)("val" + i), (Object)dynaArray[i].get("prop" + i));
            LazyDynaListTestCase.assertEquals((String)("5." + i + " Map error "), (Object)("val" + i), mapArray[i].get("prop" + i));
        }
        lazyList = new LazyDynaList(testArray);
        LazyDynaListTestCase.assertEquals((String)"6. check size", (int)5, (int)lazyList.size());
        dynaArray = lazyList.toDynaBeanArray();
        mapArray = (TreeMap[])lazyList.toArray();
        LazyDynaListTestCase.assertEquals((String)"7. check size", (int)5, (int)dynaArray.length);
        LazyDynaListTestCase.assertEquals((String)"8. check size", (int)5, (int)mapArray.length);
        for (i = 0; i < 5; ++i) {
            LazyDynaListTestCase.assertEquals((String)("9." + i + " DynaBean error "), (Object)("val" + i), (Object)dynaArray[i].get("prop" + i));
            LazyDynaListTestCase.assertEquals((String)("10." + i + " Map error "), (Object)("val" + i), mapArray[i].get("prop" + i));
        }
    }

    public void testDynaBeanDynaClass() {
        LazyDynaList list = new LazyDynaList(this.basicDynaClass);
        this.dynaBeanTest(list, BasicDynaBean.class, this.basicDynaClass, new BenchBean());
    }

    public void testDynaBeanType() {
        LazyDynaList list = new LazyDynaList(LazyDynaBean.class);
        LazyDynaBean bean = new LazyDynaBean();
        bean.set("prop1", (Object)"val");
        this.dynaBeanTest(list, LazyDynaBean.class, bean.getDynaClass(), new BenchBean());
    }

    public void testMapDynaClass() {
        LazyDynaList list = new LazyDynaList(this.treeMapDynaClass);
        this.mapTest(list, TreeMap.class, new BenchBean());
    }

    public void testMapType() {
        LazyDynaList list = new LazyDynaList(HashMap.class);
        this.mapTest(list, HashMap.class, new BenchBean());
    }

    public void testNullType() {
        LazyDynaList lazyList = new LazyDynaList();
        lazyList.add(new HashMap());
    }

    public void testPojoDynaClass() {
        LazyDynaList list = new LazyDynaList(this.pojoDynaClass);
        this.pojoTest(list, TestBean.class, new BenchBean());
    }

    public void testPojoType() {
        LazyDynaList list = new LazyDynaList(TestBean.class);
        this.pojoTest(list, TestBean.class, new BenchBean());
    }

    public void testSerializationDynaBean() {
        LazyDynaList target = new LazyDynaList(this.basicDynaClass);
        BasicDynaBean bean = (BasicDynaBean)target.get(0);
        LazyDynaListTestCase.assertNull((String)"pre-set check", (Object)bean.get(BASIC_PROP1));
        bean.set(BASIC_PROP1, (Object)"value1");
        LazyDynaListTestCase.assertEquals((String)"post-set check", (Object)"value1", (Object)bean.get(BASIC_PROP1));
        LazyDynaList result = (LazyDynaList)this.serializeDeserialize(target, "DynaBean");
        target = null;
        bean = null;
        bean = (BasicDynaBean)result.get(0);
        LazyDynaListTestCase.assertEquals((String)"post-serialize check", (Object)"value1", (Object)bean.get(BASIC_PROP1));
    }

    public void testSerializationLazyDynaBean() {
        LazyDynaList target = new LazyDynaList();
        LazyDynaBean bean = (LazyDynaBean)target.get(0);
        LazyDynaListTestCase.assertNull((String)"pre-set check", (Object)bean.get(BASIC_PROP1));
        bean.set(BASIC_PROP1, (Object)"value1");
        LazyDynaListTestCase.assertEquals((String)"post-set check", (Object)"value1", (Object)bean.get(BASIC_PROP1));
        LazyDynaList result = (LazyDynaList)this.serializeDeserialize(target, "DynaBean");
        target = null;
        bean = null;
        bean = (LazyDynaBean)result.get(0);
        LazyDynaListTestCase.assertEquals((String)"post-serialize check", (Object)"value1", (Object)bean.get(BASIC_PROP1));
    }

    public void testSerializationMap() {
        LazyDynaList target = new LazyDynaList(this.treeMapDynaClass);
        LazyDynaMap bean = (LazyDynaMap)target.get(0);
        LazyDynaListTestCase.assertNull((String)"pre-set check", (Object)bean.get(BASIC_PROP1));
        bean.set(BASIC_PROP1, (Object)"value1");
        LazyDynaListTestCase.assertEquals((String)"post-set check", (Object)"value1", (Object)bean.get(BASIC_PROP1));
        LazyDynaList result = (LazyDynaList)this.serializeDeserialize(target, "Map");
        target = null;
        bean = null;
        bean = (LazyDynaMap)result.get(0);
        LazyDynaListTestCase.assertEquals((String)"post-serialize check", (Object)"value1", (Object)bean.get(BASIC_PROP1));
    }

    public void testSerializationPojo() {
        LazyDynaList target = new LazyDynaList(this.pojoDynaClass);
        WrapDynaBean bean = (WrapDynaBean)target.get(0);
        LazyDynaListTestCase.assertEquals((String)"pre-set check", (Object)"This is a string", (Object)bean.get("stringProperty"));
        bean.set("stringProperty", (Object)"value1");
        LazyDynaListTestCase.assertEquals((String)"post-set check", (Object)"value1", (Object)bean.get("stringProperty"));
        LazyDynaList result = (LazyDynaList)this.serializeDeserialize(target, "POJO");
        target = null;
        bean = null;
        result.add(null);
        bean = (WrapDynaBean)result.get(0);
        LazyDynaListTestCase.assertEquals((String)"post-serialize check", (Object)"value1", (Object)bean.get("stringProperty"));
    }

    public void testToArrayDynaBeans() {
        LazyDynaList list = new LazyDynaList(LazyDynaBean.class);
        LazyDynaBean elem = new LazyDynaBean();
        list.add((Object)elem);
        Object[] beans = new LazyDynaBean[1];
        LazyDynaListTestCase.assertSame((String)"Wrong array", (Object)beans, (Object)list.toArray(beans));
        LazyDynaListTestCase.assertSame((String)"Wrong element", (Object)elem, (Object)beans[0]);
    }

    public void testToArrayMapType() {
        LazyDynaList list = new LazyDynaList(HashMap.class);
        HashMap elem = new HashMap();
        list.add(elem);
        Object[] array = new Map[1];
        LazyDynaListTestCase.assertSame((String)"Wrong array", (Object)array, (Object)list.toArray(array));
        LazyDynaListTestCase.assertEquals((String)"Wrong element", elem, (Object)array[0]);
    }

    public void testToArrayOtherType() {
        LazyDynaList list = new LazyDynaList(TestBean.class);
        TestBean elem = new TestBean();
        list.add((Object)elem);
        Object[] array = new TestBean[1];
        LazyDynaListTestCase.assertSame((String)"Wrong array", (Object)array, (Object)list.toArray(array));
        LazyDynaListTestCase.assertEquals((String)"Wrong element", (Object)elem, (Object)array[0]);
    }

    public void testToArrayUnsufficientSize() {
        LazyDynaList list = new LazyDynaList(LazyDynaBean.class);
        LazyDynaBean elem = new LazyDynaBean();
        list.add((Object)elem);
        LazyDynaBean[] array = (LazyDynaBean[])list.toArray((Object[])new LazyDynaBean[0]);
        LazyDynaListTestCase.assertEquals((String)"Wrong array size", (int)1, (int)array.length);
        LazyDynaListTestCase.assertEquals((String)"Wrong element", (Object)elem, (Object)array[0]);
    }
}

