/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.NonStringTestHolder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class BaseNonStringProperties {
    protected NonStringTestHolder nonStringTestHolder = new NonStringTestHolder();
    protected Configuration conf;

    @Test
    void testBoolean() throws Exception {
        this.nonStringTestHolder.testBoolean();
    }

    @Test
    void testBooleanArrayValue() throws Exception {
        boolean booleanValue = this.conf.getBoolean("test.boolean");
        Assertions.assertTrue((boolean)booleanValue);
        Assertions.assertEquals((int)2, (int)this.conf.getList("test.boolean.array").size());
    }

    @Test
    void testBooleanDefaultValue() throws Exception {
        this.nonStringTestHolder.testBooleanDefaultValue();
    }

    @Test
    void testByte() throws Exception {
        this.nonStringTestHolder.testByte();
    }

    @Test
    void testByteArrayValue() throws Exception {
        int testValue = 10;
        byte byteValue = this.conf.getByte("test.byte");
        Assertions.assertEquals((byte)10, (byte)byteValue);
        Assertions.assertEquals((int)2, (int)this.conf.getList("test.byte.array").size());
    }

    @Test
    void testDouble() throws Exception {
        this.nonStringTestHolder.testDouble();
    }

    @Test
    void testDoubleArrayValue() throws Exception {
        double testValue = 10.25;
        double doubleValue = this.conf.getDouble("test.double");
        Assertions.assertEquals((double)10.25, (double)doubleValue, (double)0.01);
        Assertions.assertEquals((int)2, (int)this.conf.getList("test.double.array").size());
    }

    @Test
    void testDoubleDefaultValue() throws Exception {
        this.nonStringTestHolder.testDoubleDefaultValue();
    }

    @Test
    void testFloat() throws Exception {
        this.nonStringTestHolder.testFloat();
    }

    @Test
    void testFloatArrayValue() throws Exception {
        float testValue = 20.25f;
        float floatValue = this.conf.getFloat("test.float");
        Assertions.assertEquals((double)20.25, (double)floatValue, (double)0.01);
        Assertions.assertEquals((int)2, (int)this.conf.getList("test.float.array").size());
    }

    @Test
    void testFloatDefaultValue() throws Exception {
        this.nonStringTestHolder.testFloatDefaultValue();
    }

    @Test
    void testInteger() throws Exception {
        this.nonStringTestHolder.testInteger();
    }

    @Test
    void testIntegerArrayValue() throws Exception {
        int intValue = this.conf.getInt("test.integer");
        Assertions.assertEquals((int)10, (int)intValue);
        Assertions.assertEquals((int)2, (int)this.conf.getList("test.integer.array").size());
    }

    @Test
    void testIntegerDefaultValue() throws Exception {
        this.nonStringTestHolder.testIntegerDefaultValue();
    }

    @Test
    void testIsEmpty() throws Exception {
        this.nonStringTestHolder.testIsEmpty();
    }

    @Test
    void testListMissing() throws Exception {
        this.nonStringTestHolder.testListMissing();
    }

    @Test
    void testLong() throws Exception {
        this.nonStringTestHolder.testLong();
    }

    @Test
    void testLongArrayValue() throws Exception {
        long longValue = this.conf.getLong("test.long");
        Assertions.assertEquals((long)1000000L, (long)longValue);
        Assertions.assertEquals((int)2, (int)this.conf.getList("test.long.array").size());
    }

    @Test
    void testLongDefaultValue() throws Exception {
        this.nonStringTestHolder.testLongDefaultValue();
    }

    @Test
    void testShort() throws Exception {
        this.nonStringTestHolder.testShort();
    }

    @Test
    void testShortArrayValue() throws Exception {
        short shortValue = this.conf.getShort("test.short");
        Assertions.assertEquals((int)1, (int)shortValue);
        Assertions.assertEquals((int)2, (int)this.conf.getList("test.short.array").size());
    }

    @Test
    void testShortDefaultValue() throws Exception {
        this.nonStringTestHolder.testShortDefaultValue();
    }

    @Test
    void testSubset() throws Exception {
        this.nonStringTestHolder.testSubset();
    }
}

