/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.text.lookup.UrlEncoderStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class UrlEncoderStringLookupTest {
    private static final String DATA = "Hello+World%21";

    UrlEncoderStringLookupTest() {
    }

    @Test
    void test() {
        Assertions.assertEquals((Object)DATA, (Object)UrlEncoderStringLookup.INSTANCE.apply("Hello World!"));
    }

    @Test
    void testExceptionGettingString() throws UnsupportedEncodingException {
        UrlEncoderStringLookup mockLookup = (UrlEncoderStringLookup)Mockito.spy(UrlEncoderStringLookup.class);
        Mockito.when((Object)mockLookup.encode(DATA, StandardCharsets.UTF_8.displayName())).thenThrow(UnsupportedEncodingException.class);
        Assertions.assertThrows(IllegalArgumentException.class, () -> mockLookup.apply(DATA));
    }

    @Test
    void testNull() {
        Assertions.assertNull((Object)UrlEncoderStringLookup.INSTANCE.apply(null));
    }

    @Test
    void testToString() {
        Assertions.assertFalse((boolean)UrlEncoderStringLookup.INSTANCE.toString().isEmpty());
    }
}

