/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.cors;

import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.cxf.rs.security.cors.LocalPreflight;

@Provider
@PreMatching
@Priority(value=999)
public class CrossOriginResourceSharingFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String SPACE_PATTERN = " ";
    private static final String FIELD_COMMA_PATTERN = ",";
    private static final String LOCAL_PREFLIGHT = "local_preflight";
    private static final String LOCAL_PREFLIGHT_ORIGIN = "local_preflight.origin";
    private static final String LOCAL_PREFLIGHT_METHOD = "local_preflight.method";
    private static final String PREFLIGHT_PASSED = "preflight_passed";
    private static final String PREFLIGHT_FAILED = "preflight_failed";
    private static final String SIMPLE_REQUEST = "simple_request";
    @Context
    private HttpHeaders headers;
    private List<String> allowOrigins = Collections.emptyList();
    private List<String> allowHeaders = Collections.emptyList();
    private boolean allowCredentials;
    private List<String> exposeHeaders = Collections.emptyList();
    private Integer maxAge;
    private Integer preflightFailStatus = 200;
    private boolean defaultOptionsMethodsHandlePreflight;
    private boolean findResourceMethod = true;
    private boolean blockCorsIfUnauthorized;

    private <T extends Annotation> T getAnnotation(Method m, Class<T> annClass) {
        if (m == null) {
            return null;
        }
        return (T)ReflectionUtil.getAnnotationForMethodOrContainingClass((Method)m, annClass);
    }

    public void filter(ContainerRequestContext context) {
        Message m = JAXRSUtils.getCurrentMessage();
        String httpMethod = (String)m.get((Object)"org.apache.cxf.request.method");
        if ("OPTIONS".equals(httpMethod)) {
            Response r = this.preflightRequest(m);
            if (r != null) {
                context.abortWith(r);
            }
        } else if (this.findResourceMethod) {
            Method method = this.getResourceMethod(m, httpMethod);
            this.simpleRequest(m, method);
        } else {
            m.getInterceptorChain().add((Interceptor)new CorsInInterceptor());
        }
    }

    private Response simpleRequest(Message m, Method resourceMethod) {
        CrossOriginResourceSharing ann = this.getAnnotation(resourceMethod, CrossOriginResourceSharing.class);
        List<String> headerOriginValues = this.getHeaderValues("Origin", true);
        if (headerOriginValues == null || headerOriginValues.isEmpty()) {
            return null;
        }
        if (!this.effectiveAllowOrigins(ann, headerOriginValues)) {
            return null;
        }
        this.setAllowOriginAndCredentials(m, ann, headerOriginValues);
        List<String> effectiveExposeHeaders = this.effectiveExposeHeaders(ann);
        if (effectiveExposeHeaders != null && !effectiveExposeHeaders.isEmpty()) {
            m.getExchange().put((Object)"Access-Control-Expose-Headers", effectiveExposeHeaders);
        }
        m.getExchange().put((Object)CrossOriginResourceSharingFilter.class.getName(), (Object)SIMPLE_REQUEST);
        return null;
    }

    private Response preflightRequest(Message m) {
        Method optionsMethod;
        List<String> headerOriginValues = this.getHeaderValues("Origin", true);
        if (headerOriginValues == null || headerOriginValues.size() != 1) {
            return null;
        }
        String origin = headerOriginValues.get(0);
        List<String> requestMethodValues = this.getHeaderValues("Access-Control-Request-Method", false);
        if (requestMethodValues == null || requestMethodValues.size() != 1) {
            return this.createPreflightResponse(m, false);
        }
        String requestMethod = requestMethodValues.get(0);
        Method method = null;
        if (this.findResourceMethod && (method = this.getResourceMethod(m, requestMethod)) == null) {
            return null;
        }
        LocalPreflight preflightAnnotation = null;
        if (!this.defaultOptionsMethodsHandlePreflight && (optionsMethod = this.getResourceMethod(m, "OPTIONS")) != null) {
            preflightAnnotation = this.getAnnotation(optionsMethod, LocalPreflight.class);
        }
        if (preflightAnnotation != null || this.defaultOptionsMethodsHandlePreflight) {
            m.put((Object)LOCAL_PREFLIGHT, (Object)"true");
            m.put((Object)LOCAL_PREFLIGHT_ORIGIN, (Object)origin);
            m.put((Object)LOCAL_PREFLIGHT_METHOD, (Object)method);
            return null;
        }
        CrossOriginResourceSharing ann = this.getAnnotation(method, CrossOriginResourceSharing.class);
        if (!this.effectiveAllowOrigins(ann, Collections.singletonList(origin))) {
            return this.createPreflightResponse(m, false);
        }
        List<String> requestHeaders = this.getHeaderValues("Access-Control-Request-Headers", false);
        if (!this.effectiveAllowHeaders(ann, requestHeaders)) {
            return this.createPreflightResponse(m, false);
        }
        m.getExchange().put((Object)"Access-Control-Allow-Methods", Arrays.asList(requestMethod));
        m.getExchange().put((Object)"Access-Control-Allow-Headers", requestHeaders);
        if (this.effectiveMaxAge(ann) != null) {
            m.getExchange().put((Object)"Access-Control-Max-Age", (Object)this.effectiveMaxAge(ann).toString());
        }
        this.setAllowOriginAndCredentials(m, ann, headerOriginValues);
        return this.createPreflightResponse(m, true);
    }

    private Response createPreflightResponse(Message m, boolean passed) {
        m.getExchange().put((Object)CrossOriginResourceSharingFilter.class.getName(), (Object)(passed ? PREFLIGHT_PASSED : PREFLIGHT_FAILED));
        int status = passed ? 200 : this.preflightFailStatus;
        return Response.status((int)status).build();
    }

    private Method getResourceMethod(Message m, String httpMethod) {
        String requestUri = HttpUtils.getPathToMatch((Message)m, (boolean)true);
        List resources = JAXRSUtils.getRootResources((Message)m);
        Map matchedResources = JAXRSUtils.selectResourceClass((List)resources, (String)requestUri, (Message)m);
        if (matchedResources == null) {
            return null;
        }
        MetadataMap values = new MetadataMap();
        OperationResourceInfo ori = this.findPreflightMethod(matchedResources, requestUri, httpMethod, (MultivaluedMap<String, String>)values, m);
        return ori == null ? null : ori.getAnnotatedMethod();
    }

    private OperationResourceInfo findPreflightMethod(Map<ClassResourceInfo, MultivaluedMap<String, String>> matchedResources, String requestUri, String httpMethod, MultivaluedMap<String, String> values, Message m) {
        String contentType = "*/*";
        MediaType acceptType = MediaType.WILDCARD_TYPE;
        OperationResourceInfo ori = JAXRSUtils.findTargetMethod(matchedResources, (Message)m, (String)httpMethod, values, (String)"*/*", Collections.singletonList(acceptType), (boolean)false, (boolean)false);
        if (ori == null) {
            return null;
        }
        if (ori.isSubResourceLocator()) {
            Class<?> cls = ori.getMethodToInvoke().getReturnType();
            ClassResourceInfo subcri = ori.getClassResourceInfo().getSubResource(cls, cls);
            if (subcri == null) {
                return null;
            }
            MetadataMap newValues = new MetadataMap();
            newValues.putAll(values);
            return this.findPreflightMethod(Collections.singletonMap(subcri, newValues), (String)values.getFirst((Object)"FINAL_MATCH_GROUP"), httpMethod, (MultivaluedMap<String, String>)newValues, m);
        }
        return ori;
    }

    private void setAllowOriginAndCredentials(Message m, CrossOriginResourceSharing ann, List<String> headerOriginValues) {
        boolean allowCreds = this.effectiveAllowCredentials(ann);
        m.getExchange().put((Object)"Access-Control-Allow-Credentials", (Object)allowCreds);
        String originResponse = !allowCreds && this.effectiveAllowAllOrigins(ann) ? "*" : this.concatValues(headerOriginValues, true);
        m.getExchange().put((Object)"Origin", (Object)originResponse);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        Message m = JAXRSUtils.getCurrentMessage();
        String op = (String)m.getExchange().get((Object)CrossOriginResourceSharingFilter.class.getName());
        if (op == null || PREFLIGHT_FAILED.equals(op)) {
            return;
        }
        if (responseContext.getStatus() == Response.Status.UNAUTHORIZED.getStatusCode() && this.blockCorsIfUnauthorized) {
            return;
        }
        responseContext.getHeaders().putSingle((Object)"Access-Control-Allow-Origin", m.getExchange().get((Object)"Origin"));
        responseContext.getHeaders().putSingle((Object)"Access-Control-Allow-Credentials", m.getExchange().get((Object)"Access-Control-Allow-Credentials"));
        if (SIMPLE_REQUEST.equals(op)) {
            List<String> effectiveExposeHeaders = this.getHeadersFromInput(m, "Access-Control-Expose-Headers");
            if (effectiveExposeHeaders != null) {
                this.addHeaders(responseContext, "Access-Control-Expose-Headers", effectiveExposeHeaders, false);
            }
        } else {
            String maValue = (String)m.getExchange().get((Object)"Access-Control-Max-Age");
            if (maValue != null) {
                responseContext.getHeaders().putSingle((Object)"Access-Control-Max-Age", (Object)maValue);
            }
            this.addHeaders(responseContext, "Access-Control-Allow-Methods", this.getHeadersFromInput(m, "Access-Control-Allow-Methods"), false);
            List<String> rqAllowedHeaders = this.getHeadersFromInput(m, "Access-Control-Allow-Headers");
            if (rqAllowedHeaders != null) {
                this.addHeaders(responseContext, "Access-Control-Allow-Headers", rqAllowedHeaders, false);
            }
        }
    }

    private boolean effectiveAllowAllOrigins(CrossOriginResourceSharing ann) {
        if (ann != null) {
            return ann.allowAllOrigins();
        }
        return this.allowOrigins.isEmpty();
    }

    private boolean effectiveAllowCredentials(CrossOriginResourceSharing ann) {
        if (ann != null) {
            return ann.allowCredentials();
        }
        return this.allowCredentials;
    }

    private boolean effectiveAllowOrigins(CrossOriginResourceSharing ann, List<String> origins) {
        if (this.effectiveAllowAllOrigins(ann)) {
            return true;
        }
        List<Object> actualOrigins = Collections.emptyList();
        if (ann != null) {
            actualOrigins = Arrays.asList(ann.allowOrigins());
        }
        if (actualOrigins.isEmpty()) {
            actualOrigins = this.allowOrigins;
        }
        return actualOrigins.containsAll(origins);
    }

    private boolean effectiveAllowAnyHeaders(CrossOriginResourceSharing ann) {
        if (ann != null) {
            return ann.allowHeaders().length == 0;
        }
        return this.allowHeaders.isEmpty();
    }

    private boolean effectiveAllowHeaders(CrossOriginResourceSharing ann, List<String> aHeaders) {
        if (this.effectiveAllowAnyHeaders(ann)) {
            return true;
        }
        TreeSet<String> actualHeadersSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        actualHeadersSet.addAll(ann != null ? Arrays.asList(ann.allowHeaders()) : this.allowHeaders);
        return actualHeadersSet.containsAll(aHeaders);
    }

    private List<String> effectiveExposeHeaders(CrossOriginResourceSharing ann) {
        return ann != null ? Arrays.asList(ann.exposeHeaders()) : this.exposeHeaders;
    }

    private Integer effectiveMaxAge(CrossOriginResourceSharing ann) {
        if (ann != null) {
            int ma = ann.maxAge();
            if (ma < 0) {
                return null;
            }
            return ma;
        }
        return this.maxAge;
    }

    private List<String> getHeadersFromInput(Message m, String key) {
        Object obj = m.getExchange().get((Object)key);
        if (obj instanceof List) {
            return (List)obj;
        }
        return null;
    }

    private List<String> getHeaderValues(String key, boolean spaceSeparated) {
        List<String> results;
        List values = this.headers.getRequestHeader(key);
        String splitPattern = spaceSeparated ? SPACE_PATTERN : FIELD_COMMA_PATTERN;
        if (values != null) {
            results = new ArrayList();
            for (String value : values) {
                for (String item : value.split(splitPattern)) {
                    results.add(item.trim());
                }
            }
        } else {
            results = Collections.emptyList();
        }
        return results;
    }

    private void addHeaders(ContainerResponseContext responseContext, String key, List<String> values, boolean spaceSeparated) {
        String sb = this.concatValues(values, spaceSeparated);
        responseContext.getHeaders().putSingle((Object)key, (Object)sb);
    }

    private String concatValues(List<String> values, boolean spaceSeparated) {
        StringBuilder sb = new StringBuilder();
        for (int x = 0; x < values.size(); ++x) {
            sb.append(values.get(x));
            if (x == values.size() - 1) continue;
            if (spaceSeparated) {
                sb.append(' ');
                continue;
            }
            sb.append(", ");
        }
        return sb.toString();
    }

    public void setAllowOrigins(List<String> allowedOrigins) {
        this.allowOrigins = allowedOrigins;
    }

    public List<String> getAllowOrigins() {
        return this.allowOrigins;
    }

    public List<String> getAllowHeaders() {
        return this.allowHeaders;
    }

    public void setAllowHeaders(List<String> allowedHeaders) {
        this.allowHeaders = allowedHeaders;
    }

    public List<String> getExposeHeaders() {
        return this.exposeHeaders;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public boolean isAllowCredentials() {
        return this.allowCredentials;
    }

    public void setAllowCredentials(boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public void setExposeHeaders(List<String> exposeHeaders) {
        this.exposeHeaders = exposeHeaders;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public void setPreflightErrorStatus(Integer status) {
        this.preflightFailStatus = status;
    }

    public void setDefaultOptionsMethodsHandlePreflight(boolean defaultOptionsMethodsHandlePreflight) {
        this.defaultOptionsMethodsHandlePreflight = defaultOptionsMethodsHandlePreflight;
    }

    public void setFindResourceMethod(boolean findResourceMethod) {
        this.findResourceMethod = findResourceMethod;
    }

    public void setBlockCorsIfUnauthorized(boolean blockCorsIfUnauthorized) {
        this.blockCorsIfUnauthorized = blockCorsIfUnauthorized;
    }

    private class CorsInInterceptor
    extends AbstractPhaseInterceptor<Message> {
        CorsInInterceptor() {
            super("pre-invoke");
        }

        public void handleMessage(Message message) {
            OperationResourceInfo ori = (OperationResourceInfo)message.getExchange().get(OperationResourceInfo.class);
            CrossOriginResourceSharingFilter.this.simpleRequest(message, ori.getAnnotatedMethod());
        }
    }
}

