/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.future;

import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.config.base.CoreBaseConfig;

@ApplicationScoped
public class ThreadPoolManager {
    private final ConcurrentMap<String, ExecutorService> pools = new ConcurrentHashMap<String, ExecutorService>();
    private final Collection<CreationalContext<?>> contexts = new ArrayList(8);
    private volatile boolean closed = false;
    @Inject
    private BeanManager beanManager;

    @PreDestroy
    private void shutdown() {
        this.closed = true;
        long timeout = CoreBaseConfig.TimeoutCustomization.FUTUREABLE_TERMINATION_TIMEOUT_IN_MILLISECONDS.intValue();
        for (ExecutorService executorService : this.pools.values()) {
            executorService.shutdown();
        }
        for (ExecutorService executorService : this.pools.values()) {
            try {
                executorService.awaitTermination(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        this.pools.clear();
        for (CreationalContext creationalContext : this.contexts) {
            creationalContext.release();
        }
        this.contexts.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService find(String name) {
        if (this.closed) {
            throw new IllegalStateException("Container is shutting down");
        }
        ExecutorService pool = (ExecutorService)this.pools.get(name);
        if (pool == null) {
            ThreadPoolManager threadPoolManager = this;
            synchronized (threadPoolManager) {
                pool = (ExecutorService)this.pools.get(name);
                if (pool == null) {
                    Object bean;
                    Set beans = this.beanManager.getBeans(name);
                    if (beans != null && !beans.isEmpty() && (bean = this.beanManager.resolve(beans)).getTypes().contains(ExecutorService.class)) {
                        CreationalContext creationalContext = this.beanManager.createCreationalContext(null);
                        if (!this.beanManager.isNormalScope(bean.getScope())) {
                            this.contexts.add(creationalContext);
                        }
                        pool = (ExecutorService)ExecutorService.class.cast(this.beanManager.getReference((Bean)bean, ExecutorService.class, creationalContext));
                    }
                    if (pool == null) {
                        for (String prefix : Arrays.asList("", "java:app/", "java:global/", "java:global/threads/", "java:global/deltaspike/", "java:")) {
                            try {
                                Object instance = new InitialContext().lookup(prefix + name);
                                if (!ExecutorService.class.isInstance(instance)) continue;
                                pool = (ExecutorService)ExecutorService.class.cast(instance);
                                break;
                            }
                            catch (NamingException instance) {
                            }
                        }
                    }
                    if (pool == null) {
                        SynchronousQueue<Runnable> queue;
                        String configPrefix = "futureable.pool." + name + ".";
                        int coreSize = (Integer)ConfigResolver.resolve((String)(configPrefix + "coreSize")).as(Integer.class).withDefault((Object)Math.max(2, Runtime.getRuntime().availableProcessors())).getValue();
                        int maxSize = (Integer)ConfigResolver.resolve((String)(configPrefix + "maxSize")).as(Integer.class).withDefault((Object)coreSize).getValue();
                        long keepAlive = (Long)ConfigResolver.resolve((String)(configPrefix + "keepAlive.value")).as(Long.class).withDefault((Object)0L).getValue();
                        String keepAliveUnit = (String)ConfigResolver.resolve((String)(configPrefix + "keepAlive.unit")).as(String.class).withDefault((Object)"MILLISECONDS").getValue();
                        String queueType = (String)ConfigResolver.resolve((String)(configPrefix + "queue.type")).as(String.class).withDefault((Object)"LINKED").getValue();
                        if ("ARRAY".equalsIgnoreCase(queueType)) {
                            int size = (Integer)ConfigResolver.resolve((String)(configPrefix + "queue.size")).as(Integer.class).withDefault((Object)1024).getValue();
                            boolean fair = (Boolean)ConfigResolver.resolve((String)(configPrefix + "queue.fair")).as(Boolean.class).withDefault((Object)false).getValue();
                            queue = new ArrayBlockingQueue(size, fair);
                        } else if ("SYNCHRONOUS".equalsIgnoreCase(queueType)) {
                            boolean fair = (Boolean)ConfigResolver.resolve((String)(configPrefix + "queue.fair")).as(Boolean.class).withDefault((Object)false).getValue();
                            queue = new SynchronousQueue(fair);
                        } else {
                            int capacity = (Integer)ConfigResolver.resolve((String)(configPrefix + "queue.capacity")).as(Integer.class).withDefault((Object)Integer.MAX_VALUE).getValue();
                            queue = new LinkedBlockingQueue(capacity);
                        }
                        String threadFactoryName = ConfigResolver.getPropertyValue((String)(configPrefix + "threadFactory.name"));
                        ThreadFactory threadFactory = threadFactoryName != null ? this.lookupByName(threadFactoryName, ThreadFactory.class) : Executors.defaultThreadFactory();
                        String rejectedHandlerName = ConfigResolver.getPropertyValue((String)(configPrefix + "rejectedExecutionHandler.name"));
                        RejectedExecutionHandler rejectedHandler = rejectedHandlerName != null ? this.lookupByName(rejectedHandlerName, RejectedExecutionHandler.class) : new ThreadPoolExecutor.AbortPolicy();
                        pool = new ThreadPoolExecutor(coreSize, maxSize, keepAlive, TimeUnit.valueOf(keepAliveUnit), queue, threadFactory, rejectedHandler);
                    }
                    this.pools.put(name, pool);
                }
            }
        }
        return pool;
    }

    private <T> T lookupByName(String name, Class<T> type) {
        Set tfb = this.beanManager.getBeans(name);
        Bean bean = this.beanManager.resolve(tfb);
        CreationalContext ctx = this.beanManager.createCreationalContext(null);
        if (!this.beanManager.isNormalScope(bean.getScope())) {
            this.contexts.add(ctx);
        }
        return type.cast(this.beanManager.getReference(bean, type, ctx));
    }
}

