/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.rest;

import org.apache.directory.fortress.core.AdminMgr;
import org.apache.directory.fortress.core.AdminMgrFactory;
import org.apache.directory.fortress.core.DelAdminMgr;
import org.apache.directory.fortress.core.DelAdminMgrFactory;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.PermGrant;
import org.apache.directory.fortress.core.model.PermObj;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.PermissionAttribute;
import org.apache.directory.fortress.core.model.PermissionAttributeSet;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.RoleConstraint;
import org.apache.directory.fortress.core.model.RoleRelationship;
import org.apache.directory.fortress.core.model.SDSet;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.rest.AbstractMgrImpl;
import org.apache.directory.fortress.rest.FortressServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AdminMgrImpl
extends AbstractMgrImpl {
    private static final Logger LOG = LoggerFactory.getLogger((String)AdminMgrImpl.class.getName());

    AdminMgrImpl() {
    }

    FortResponse addUser(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            User inUser = (User)request.getEntity();
            User outUser = adminMgr.addUser(inUser);
            response.setEntity((FortEntity)outUser);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse deleteUser(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            User inUser = (User)request.getEntity();
            adminMgr.deleteUser(inUser);
            response.setEntity((FortEntity)inUser);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse disableUser(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            User inUser = (User)request.getEntity();
            adminMgr.disableUser(inUser);
            response.setEntity((FortEntity)inUser);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse updateUser(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            User inUser = (User)request.getEntity();
            User outUser = adminMgr.updateUser(inUser);
            response.setEntity((FortEntity)outUser);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse changePassword(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            User inUser = (User)request.getEntity();
            adminMgr.changePassword(inUser, inUser.getNewPassword());
            response.setEntity((FortEntity)inUser);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse lockUserAccount(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            User inUser = (User)request.getEntity();
            adminMgr.lockUserAccount(inUser);
            response.setEntity((FortEntity)inUser);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse unlockUserAccount(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            User inUser = (User)request.getEntity();
            adminMgr.unlockUserAccount(inUser);
            response.setEntity((FortEntity)inUser);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse resetPassword(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            User inUser = (User)request.getEntity();
            adminMgr.resetPassword(inUser, inUser.getNewPassword());
            response.setEntity((FortEntity)inUser);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse addRole(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            Role inRole = (Role)request.getEntity();
            Role outRole = adminMgr.addRole(inRole);
            response.setEntity((FortEntity)outRole);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse deleteRole(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            Role inRole = (Role)request.getEntity();
            adminMgr.deleteRole(inRole);
            response.setEntity((FortEntity)inRole);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse updateRole(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            Role inRole = (Role)request.getEntity();
            Role outRole = adminMgr.updateRole(inRole);
            response.setEntity((FortEntity)outRole);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse assignUser(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            UserRole inRole = (UserRole)request.getEntity();
            adminMgr.assignUser(inRole);
            response.setEntity((FortEntity)inRole);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse deassignUser(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            UserRole inRole = (UserRole)request.getEntity();
            adminMgr.deassignUser(inRole);
            response.setEntity((FortEntity)inRole);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse addPermission(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            Permission inPerm = (Permission)request.getEntity();
            Permission outPerm = adminMgr.addPermission(inPerm);
            response.setEntity((FortEntity)outPerm);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse updatePermission(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            Permission inPerm = (Permission)request.getEntity();
            Permission outPerm = adminMgr.updatePermission(inPerm);
            response.setEntity((FortEntity)outPerm);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse deletePermission(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            Permission inPerm = (Permission)request.getEntity();
            adminMgr.deletePermission(inPerm);
            response.setEntity((FortEntity)inPerm);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse addPermObj(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            PermObj inObj = (PermObj)request.getEntity();
            PermObj outObj = adminMgr.addPermObj(inObj);
            response.setEntity((FortEntity)outObj);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse updatePermObj(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            PermObj inObj = (PermObj)request.getEntity();
            PermObj outObj = adminMgr.updatePermObj(inObj);
            response.setEntity((FortEntity)outObj);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse deletePermObj(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            PermObj inObj = (PermObj)request.getEntity();
            adminMgr.deletePermObj(inObj);
            response.setEntity((FortEntity)inObj);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    private void grantPerm(FortRequest request) throws SecurityException {
        PermGrant permGrant = (PermGrant)request.getEntity();
        AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
        adminMgr.setAdmin(request.getSession());
        Role role = new Role(permGrant.getRoleNm());
        Permission perm = new Permission(permGrant.getObjName(), permGrant.getOpName(), permGrant.getObjId());
        perm.setAdmin(false);
        adminMgr.grantPermission(perm, role);
    }

    private void grantAdminPerm(FortRequest request) throws SecurityException {
        PermGrant permGrant = (PermGrant)request.getEntity();
        DelAdminMgr delegatedAdminMgr = DelAdminMgrFactory.createInstance((String)request.getContextId());
        delegatedAdminMgr.setAdmin(request.getSession());
        AdminRole role = new AdminRole(permGrant.getRoleNm());
        Permission perm = new Permission(permGrant.getObjName(), permGrant.getOpName(), permGrant.getObjId());
        perm.setAdmin(true);
        delegatedAdminMgr.grantPermission(perm, role);
    }

    private void revokePerm(FortRequest request) throws SecurityException {
        PermGrant permGrant = (PermGrant)request.getEntity();
        AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
        adminMgr.setAdmin(request.getSession());
        Role role = new Role(permGrant.getRoleNm());
        Permission perm = new Permission(permGrant.getObjName(), permGrant.getOpName(), permGrant.getObjId());
        perm.setAdmin(false);
        adminMgr.revokePermission(perm, role);
    }

    private void revokeAdminPerm(FortRequest request) throws SecurityException {
        PermGrant permGrant = (PermGrant)request.getEntity();
        DelAdminMgr delegatedAdminMgr = DelAdminMgrFactory.createInstance((String)request.getContextId());
        delegatedAdminMgr.setAdmin(request.getSession());
        AdminRole role = new AdminRole(permGrant.getRoleNm());
        Permission perm = new Permission(permGrant.getObjName(), permGrant.getOpName(), permGrant.getObjId());
        perm.setAdmin(true);
        delegatedAdminMgr.revokePermission(perm, role);
    }

    private void grantUserPerm(FortRequest request) throws SecurityException {
        PermGrant permGrant = (PermGrant)request.getEntity();
        AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
        adminMgr.setAdmin(request.getSession());
        User user = new User(permGrant.getUserId());
        Permission perm = new Permission(permGrant.getObjName(), permGrant.getOpName(), permGrant.getObjId());
        perm.setAdmin(false);
        adminMgr.grantPermission(perm, user);
    }

    private void grantAdminUserPerm(FortRequest request) throws SecurityException {
        PermGrant permGrant = (PermGrant)request.getEntity();
        DelAdminMgr delegatedAdminMgr = DelAdminMgrFactory.createInstance((String)request.getContextId());
        delegatedAdminMgr.setAdmin(request.getSession());
        User user = new User(permGrant.getUserId());
        Permission perm = new Permission(permGrant.getObjName(), permGrant.getOpName(), permGrant.getObjId());
        perm.setAdmin(true);
        delegatedAdminMgr.grantPermission(perm, user);
    }

    private void revokeUserPerm(FortRequest request) throws SecurityException {
        PermGrant permGrant = (PermGrant)request.getEntity();
        AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
        adminMgr.setAdmin(request.getSession());
        User user = new User(permGrant.getUserId());
        Permission perm = new Permission(permGrant.getObjName(), permGrant.getOpName(), permGrant.getObjId());
        perm.setAdmin(false);
        adminMgr.revokePermission(perm, user);
    }

    private void revokeAdminUserPerm(FortRequest request) throws SecurityException {
        PermGrant permGrant = (PermGrant)request.getEntity();
        DelAdminMgr delegatedAdminMgr = DelAdminMgrFactory.createInstance((String)request.getContextId());
        delegatedAdminMgr.setAdmin(request.getSession());
        User user = new User(permGrant.getUserId());
        Permission perm = new Permission(permGrant.getObjName(), permGrant.getOpName(), permGrant.getObjId());
        perm.setAdmin(true);
        delegatedAdminMgr.revokePermission(perm, user);
    }

    FortResponse grant(FortRequest request, FortressServiceImpl fortressService) {
        FortResponse response = this.createResponse();
        try {
            PermGrant permGrant = (PermGrant)request.getEntity();
            if (permGrant.isAdmin()) {
                this.grantAdminPerm(request);
            } else {
                this.grantPerm(request);
            }
            response.setEntity((FortEntity)permGrant);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse revoke(FortRequest request, FortressServiceImpl fortressService) {
        FortResponse response = this.createResponse();
        try {
            PermGrant permGrant = (PermGrant)request.getEntity();
            if (permGrant.isAdmin()) {
                this.revokeAdminPerm(request);
            } else {
                this.revokePerm(request);
            }
            response.setEntity((FortEntity)permGrant);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse grantUser(FortRequest request, FortressServiceImpl fortressService) {
        FortResponse response = this.createResponse();
        try {
            PermGrant permGrant = (PermGrant)request.getEntity();
            if (permGrant.isAdmin()) {
                this.grantAdminUserPerm(request);
            } else {
                this.grantUserPerm(request);
            }
            response.setEntity((FortEntity)permGrant);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse revokeUser(FortRequest request, FortressServiceImpl fortressService) {
        FortResponse response = this.createResponse();
        try {
            PermGrant permGrant = (PermGrant)request.getEntity();
            if (permGrant.isAdmin()) {
                this.revokeAdminUserPerm(request);
            } else {
                this.revokeUserPerm(request);
            }
            response.setEntity((FortEntity)permGrant);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse addDescendant(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            RoleRelationship relationship = (RoleRelationship)request.getEntity();
            adminMgr.addDescendant(relationship.getParent(), relationship.getChild());
            response.setEntity((FortEntity)relationship);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse addAscendant(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            RoleRelationship relationship = (RoleRelationship)request.getEntity();
            adminMgr.addAscendant(relationship.getChild(), relationship.getParent());
            response.setEntity((FortEntity)relationship);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse addInheritance(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            RoleRelationship relationship = (RoleRelationship)request.getEntity();
            adminMgr.addInheritance(relationship.getParent(), relationship.getChild());
            response.setEntity((FortEntity)relationship);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse deleteInheritance(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            RoleRelationship relationship = (RoleRelationship)request.getEntity();
            adminMgr.deleteInheritance(relationship.getParent(), relationship.getChild());
            response.setEntity((FortEntity)relationship);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse createSsdSet(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            SDSet inSet = (SDSet)request.getEntity();
            SDSet outSet = adminMgr.createSsdSet(inSet);
            response.setEntity((FortEntity)outSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse updateSsdSet(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            SDSet inSet = (SDSet)request.getEntity();
            SDSet outSet = adminMgr.updateSsdSet(inSet);
            response.setEntity((FortEntity)outSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse addSsdRoleMember(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            SDSet inSet = (SDSet)request.getEntity();
            Role role = new Role(request.getValue());
            SDSet outSet = adminMgr.addSsdRoleMember(inSet, role);
            response.setEntity((FortEntity)outSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse deleteSsdRoleMember(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            SDSet inSet = (SDSet)request.getEntity();
            Role role = new Role(request.getValue());
            SDSet outSet = adminMgr.deleteSsdRoleMember(inSet, role);
            response.setEntity((FortEntity)outSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse deleteSsdSet(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            SDSet inSet = (SDSet)request.getEntity();
            SDSet outSet = adminMgr.deleteSsdSet(inSet);
            response.setEntity((FortEntity)outSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse setSsdSetCardinality(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            SDSet inSet = (SDSet)request.getEntity();
            SDSet outSet = adminMgr.setSsdSetCardinality(inSet, inSet.getCardinality().intValue());
            response.setEntity((FortEntity)outSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse createDsdSet(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            SDSet inSet = (SDSet)request.getEntity();
            SDSet outSet = adminMgr.createDsdSet(inSet);
            response.setEntity((FortEntity)outSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse updateDsdSet(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            SDSet inSet = (SDSet)request.getEntity();
            SDSet outSet = adminMgr.updateDsdSet(inSet);
            response.setEntity((FortEntity)outSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse addDsdRoleMember(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            SDSet inSet = (SDSet)request.getEntity();
            Role role = new Role(request.getValue());
            SDSet outSet = adminMgr.addDsdRoleMember(inSet, role);
            response.setEntity((FortEntity)outSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse deleteDsdRoleMember(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            SDSet inSet = (SDSet)request.getEntity();
            Role role = new Role(request.getValue());
            SDSet outSet = adminMgr.deleteDsdRoleMember(inSet, role);
            response.setEntity((FortEntity)outSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse deleteDsdSet(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            SDSet inSet = (SDSet)request.getEntity();
            SDSet outSet = adminMgr.deleteDsdSet(inSet);
            response.setEntity((FortEntity)outSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse setDsdSetCardinality(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            SDSet inSet = (SDSet)request.getEntity();
            SDSet outSet = adminMgr.setDsdSetCardinality(inSet, inSet.getCardinality().intValue());
            response.setEntity((FortEntity)outSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse addRoleConstraint(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            UserRole inRole = (UserRole)request.getEntity();
            RoleConstraint inConstraint = (RoleConstraint)request.getEntity2();
            RoleConstraint outRole = adminMgr.addRoleConstraint(inRole, inConstraint);
            response.setEntity((FortEntity)outRole);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse removeRoleConstraint(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            UserRole inRole = (UserRole)request.getEntity();
            RoleConstraint inConstraint = (RoleConstraint)request.getEntity2();
            adminMgr.removeRoleConstraint(inRole, inConstraint);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse removeRoleConstraintWid(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            UserRole inRole = (UserRole)request.getEntity();
            String szConstraintId = request.getValue();
            adminMgr.removeRoleConstraint(inRole, szConstraintId);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse enableRoleConstraint(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            Role inRole = (Role)request.getEntity();
            RoleConstraint inConstraint = (RoleConstraint)request.getEntity2();
            adminMgr.enableRoleConstraint(inRole, inConstraint);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse disableRoleConstraint(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            Role inRole = (Role)request.getEntity();
            RoleConstraint inConstraint = (RoleConstraint)request.getEntity2();
            adminMgr.disableRoleConstraint(inRole, inConstraint);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse addPermissionAttributeToSet(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            PermissionAttribute inAttr = (PermissionAttribute)request.getEntity();
            String attrName = request.getValue();
            PermissionAttribute outAttr = adminMgr.addPermissionAttributeToSet(inAttr, attrName);
            response.setEntity((FortEntity)outAttr);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse updatePermissionAttributeInSet(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            PermissionAttribute inAttr = (PermissionAttribute)request.getEntity();
            String attrName = request.getValue();
            boolean isReplace = request.getIsFlag();
            adminMgr.updatePermissionAttributeInSet(inAttr, attrName, isReplace);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse removePermissionAttributeFromSet(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            PermissionAttribute inAttr = (PermissionAttribute)request.getEntity();
            String attrName = request.getValue();
            adminMgr.removePermissionAttributeFromSet(inAttr, attrName);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse addPermissionAttributeSet(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            PermissionAttributeSet inSet = (PermissionAttributeSet)request.getEntity();
            PermissionAttributeSet outSet = adminMgr.addPermissionAttributeSet(inSet);
            response.setEntity((FortEntity)outSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse deletePermissionAttributeSet(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminMgr adminMgr = AdminMgrFactory.createInstance((String)request.getContextId());
            adminMgr.setAdmin(request.getSession());
            PermissionAttributeSet inSet = (PermissionAttributeSet)request.getEntity();
            adminMgr.deletePermissionAttributeSet(inSet);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }
}

