/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.rest;

import java.util.List;
import org.apache.directory.fortress.core.DelReviewMgr;
import org.apache.directory.fortress.core.DelReviewMgrFactory;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.rest.AbstractMgrImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DelegatedReviewMgrImpl
extends AbstractMgrImpl {
    private static final Logger LOG = LoggerFactory.getLogger((String)DelegatedReviewMgrImpl.class.getName());

    DelegatedReviewMgrImpl() {
    }

    FortResponse readAdminRole(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminRole inRole = (AdminRole)request.getEntity();
            DelReviewMgr delegatedReviewMgr = DelReviewMgrFactory.createInstance((String)request.getContextId());
            AdminRole outRole = delegatedReviewMgr.readRole(inRole);
            response.setEntity((FortEntity)outRole);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse findAdminRoles(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            String searchVal = request.getValue();
            DelReviewMgr delegatedReviewMgr = DelReviewMgrFactory.createInstance((String)request.getContextId());
            delegatedReviewMgr.setAdmin(request.getSession());
            List outRoles = delegatedReviewMgr.findRoles(searchVal);
            response.setEntities(outRoles);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse assignedAdminRoles(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            User inUser = (User)request.getEntity();
            DelReviewMgr delegatedReviewMgr = DelReviewMgrFactory.createInstance((String)request.getContextId());
            delegatedReviewMgr.setAdmin(request.getSession());
            List uRoles = delegatedReviewMgr.assignedRoles(inUser);
            response.setEntities(uRoles);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse assignedAdminUsers(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            AdminRole inRole = (AdminRole)request.getEntity();
            DelReviewMgr delegatedReviewMgr = DelReviewMgrFactory.createInstance((String)request.getContextId());
            delegatedReviewMgr.setAdmin(request.getSession());
            List users = delegatedReviewMgr.assignedUsers(inRole);
            response.setEntities(users);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse readOrg(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            OrgUnit inOrg = (OrgUnit)request.getEntity();
            DelReviewMgr delegatedReviewMgr = DelReviewMgrFactory.createInstance((String)request.getContextId());
            delegatedReviewMgr.setAdmin(request.getSession());
            OrgUnit returnOrg = delegatedReviewMgr.read(inOrg);
            response.setEntity((FortEntity)returnOrg);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse searchOrg(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            OrgUnit inOrg = (OrgUnit)request.getEntity();
            DelReviewMgr delegatedReviewMgr = DelReviewMgrFactory.createInstance((String)request.getContextId());
            delegatedReviewMgr.setAdmin(request.getSession());
            List orgs = delegatedReviewMgr.search(inOrg.getType(), inOrg.getName());
            response.setEntities(orgs);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }
}

