/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.executor;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.execution.HealthCheckExecutionResult;
import org.apache.felix.hc.api.execution.HealthCheckMetadata;

public class CombinedExecutionResult
implements HealthCheckExecutionResult {
    final List<HealthCheckExecutionResult> executionResults;
    final Result overallResult;

    public CombinedExecutionResult(List<HealthCheckExecutionResult> executionResults) {
        this(executionResults, Result.Status.OK);
    }

    public CombinedExecutionResult(List<HealthCheckExecutionResult> executionResults, Result.Status statusForZeroResult) {
        this.executionResults = Collections.unmodifiableList(executionResults);
        Result.Status mostSevereStatus = executionResults.isEmpty() ? statusForZeroResult : Result.Status.OK;
        for (HealthCheckExecutionResult executionResult : executionResults) {
            Result.Status status = executionResult.getHealthCheckResult().getStatus();
            if (status.ordinal() <= mostSevereStatus.ordinal()) continue;
            mostSevereStatus = status;
        }
        this.overallResult = new Result(mostSevereStatus, "Overall status " + mostSevereStatus);
    }

    public Result getHealthCheckResult() {
        return this.overallResult;
    }

    public List<HealthCheckExecutionResult> getExecutionResults() {
        return this.executionResults;
    }

    public long getElapsedTimeInMs() {
        long maxElapsed = 0L;
        for (HealthCheckExecutionResult result : this.executionResults) {
            maxElapsed = Math.max(maxElapsed, result.getElapsedTimeInMs());
        }
        return maxElapsed;
    }

    public Date getFinishedAt() {
        Date latestFinishedAt = null;
        for (HealthCheckExecutionResult result : this.executionResults) {
            if (latestFinishedAt != null && !latestFinishedAt.before(result.getFinishedAt())) continue;
            latestFinishedAt = result.getFinishedAt();
        }
        return latestFinishedAt;
    }

    public boolean hasTimedOut() {
        for (HealthCheckExecutionResult result : this.executionResults) {
            if (!result.hasTimedOut()) continue;
            return true;
        }
        return false;
    }

    public HealthCheckMetadata getHealthCheckMetadata() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "CombinedExecutionResult [size=" + this.executionResults.size() + " overall status=" + this.getHealthCheckResult().getStatus() + ", finishedAt=" + this.getFinishedAt() + ", elapsedTimeInMs=" + this.getElapsedTimeInMs() + ", timedOut=" + this.hasTimedOut() + "]";
    }
}

