/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.felix.webconsole.internal.servlet.Base64;
import org.apache.felix.webconsole.internal.servlet.Password;
import org.apache.felix.webconsole.spi.SecurityProvider;
import org.osgi.framework.BundleContext;

public class BasicWebConsoleSecurityProvider
implements SecurityProvider {
    static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    static final String HEADER_AUTHORIZATION = "Authorization";
    static final String AUTHENTICATION_SCHEME_BASIC = "Basic";
    public static volatile String REALM;
    private final String username;
    private final Password password;
    private final BundleContext bundleContext;

    public BasicWebConsoleSecurityProvider(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.username = null;
        this.password = null;
    }

    public BasicWebConsoleSecurityProvider(BundleContext bundleContext, String username, String password) {
        this.bundleContext = bundleContext;
        this.username = username;
        this.password = new Password(password);
    }

    public Object authenticate(String username, String password) {
        if (this.username.equals(username) && this.password.matches(password.getBytes()) && this.bundleContext.getProperty("felix.webconsole.security.providers") == null) {
            return true;
        }
        return null;
    }

    @Override
    public boolean authorize(Object user, String role) {
        return true;
    }

    @Override
    public Object authenticate(HttpServletRequest request, HttpServletResponse response) {
        int blank;
        String authHeader = request.getHeader(HEADER_AUTHORIZATION);
        if (authHeader != null && authHeader.length() > 0 && (blank = (authHeader = authHeader.trim()).indexOf(32)) > 0) {
            String authType = authHeader.substring(0, blank);
            String authInfo = authHeader.substring(blank).trim();
            if (authType.equalsIgnoreCase(AUTHENTICATION_SCHEME_BASIC)) {
                try {
                    byte[][] userPass = BasicWebConsoleSecurityProvider.base64Decode(authInfo);
                    String username = BasicWebConsoleSecurityProvider.toString(userPass[0]);
                    if (this.authenticate(username, BasicWebConsoleSecurityProvider.toString(userPass[1])) != null) {
                        request.setAttribute("org.osgi.service.http.authentication.type", (Object)"BASIC");
                        request.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)username);
                        return username;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            response.setHeader(HEADER_WWW_AUTHENTICATE, "Basic realm=\"" + REALM + "\"");
            response.setStatus(401);
            response.setContentLength(0);
            response.flushBuffer();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void logout(HttpServletRequest request, HttpServletResponse response) {
    }

    static byte[][] base64Decode(String srcString) {
        byte[] transformed = Base64.decodeBase64(srcString);
        for (int i = 0; i < transformed.length; ++i) {
            if (transformed[i] != 58) continue;
            byte[] user = new byte[i];
            byte[] pass = new byte[transformed.length - i - 1];
            System.arraycopy(transformed, 0, user, 0, user.length);
            System.arraycopy(transformed, i + 1, pass, 0, pass.length);
            return new byte[][]{user, pass};
        }
        return new byte[][]{transformed, new byte[0]};
    }

    static String toString(byte[] src) {
        return new String(src, StandardCharsets.ISO_8859_1);
    }
}

