/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.deployunit.metastore.status;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.lang.ByteArray;

public final class UnitKey {
    public static final String DEPLOY_UNIT_PREFIX = "deploy-unit.";
    private static final String DELIMITER = ":";

    private UnitKey() {
    }

    static String[] fromBytes(String prefix, byte[] key) {
        String s = new String(key, StandardCharsets.UTF_8);
        if (!s.startsWith(prefix)) {
            return new String[0];
        }
        String content = s.substring(prefix.length());
        if (content.isEmpty()) {
            return new String[0];
        }
        return (String[])Arrays.stream(content.split(DELIMITER)).map(e -> new String(Base64.getDecoder().decode((String)e), StandardCharsets.UTF_8)).toArray(String[]::new);
    }

    static ByteArray toByteArray(String prefix, String id, String ... args) {
        Base64.Encoder encoder = Base64.getEncoder();
        String idStr = id != null ? encoder.encodeToString(id.getBytes(StandardCharsets.UTF_8)) + DELIMITER : "";
        String argsStr = Arrays.stream(args).filter(Objects::nonNull).map(arg -> encoder.encodeToString(arg.getBytes(StandardCharsets.UTF_8))).collect(Collectors.joining(DELIMITER));
        return new ByteArray(prefix + idStr + argsStr);
    }
}

