/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.disk;

import java.util.Set;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.metricsets.disk.IDiskMetricsManager;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.metrics.utils.SystemMetric;
import org.apache.iotdb.metrics.utils.SystemTag;

public class DiskMetrics
implements IMetricSet {
    private final IDiskMetricsManager diskMetricsManager = IDiskMetricsManager.getDiskMetricsManager();
    private final String processName;
    private static final String WRITE = "write";
    private static final String READ = "read";
    private static final String AVG_READ = "avg_read";
    private static final String AVG_WRITE = "avg_write";
    private static final String MERGED_READ = "merged_read";
    private static final String MERGED_WRITE = "merged_write";
    private static final String ATTEMPT_READ = "attempt_read";
    private static final String ATTEMPT_WRITE = "attempt_write";
    private static final String ACTUAL_WRITE = "actual_write";
    private static final String ACTUAL_READ = "actual_read";

    public DiskMetrics(String processName) {
        this.processName = processName;
    }

    @Override
    public void bindTo(AbstractMetricService metricService) {
        Set<String> diskIDs = this.diskMetricsManager.getDiskIds();
        for (String diskID : diskIDs) {
            metricService.createAutoGauge(SystemMetric.DISK_IO_SIZE.toString(), MetricLevel.IMPORTANT, this.diskMetricsManager, x -> x.getReadDataSizeForDisk().getOrDefault(diskID, 0.0), SystemTag.TYPE.toString(), READ, SystemTag.DISK.toString(), diskID);
            metricService.createAutoGauge(SystemMetric.DISK_IO_SIZE.toString(), MetricLevel.IMPORTANT, this.diskMetricsManager, x -> x.getWriteDataSizeForDisk().getOrDefault(diskID, 0.0), SystemTag.TYPE.toString(), WRITE, SystemTag.DISK.toString(), diskID);
            metricService.createAutoGauge(SystemMetric.DISK_IO_OPS.toString(), MetricLevel.IMPORTANT, this.diskMetricsManager, x -> x.getReadOperationCountForDisk().getOrDefault(diskID, 0L).longValue(), SystemTag.TYPE.toString(), READ, SystemTag.DISK.toString(), diskID);
            metricService.createAutoGauge(SystemMetric.DISK_IO_OPS.toString(), MetricLevel.IMPORTANT, this.diskMetricsManager, x -> x.getWriteOperationCountForDisk().getOrDefault(diskID, 0L).longValue(), SystemTag.TYPE.toString(), WRITE, SystemTag.DISK.toString(), diskID);
            metricService.createAutoGauge(SystemMetric.DISK_IO_OPS.toString(), MetricLevel.IMPORTANT, this.diskMetricsManager, x -> x.getMergedReadOperationForDisk().getOrDefault(diskID, 0L).longValue(), SystemTag.TYPE.toString(), MERGED_READ, SystemTag.DISK.toString(), diskID);
            metricService.createAutoGauge(SystemMetric.DISK_IO_OPS.toString(), MetricLevel.IMPORTANT, this.diskMetricsManager, x -> x.getMergedWriteOperationForDisk().getOrDefault(diskID, 0L).longValue(), SystemTag.TYPE.toString(), MERGED_WRITE, SystemTag.DISK.toString(), diskID);
            metricService.createAutoGauge(SystemMetric.DISK_IO_TIME.toString(), MetricLevel.IMPORTANT, this.diskMetricsManager, x -> x.getReadCostTimeForDisk().getOrDefault(diskID, 0L).longValue(), SystemTag.TYPE.toString(), READ, SystemTag.DISK.toString(), diskID);
            metricService.createAutoGauge(SystemMetric.DISK_IO_TIME.toString(), MetricLevel.IMPORTANT, this.diskMetricsManager, x -> x.getWriteCostTimeForDisk().getOrDefault(diskID, 0L).longValue(), SystemTag.TYPE.toString(), WRITE, SystemTag.DISK.toString(), diskID);
            metricService.createAutoGauge(SystemMetric.DISK_IO_AVG_TIME.toString(), MetricLevel.IMPORTANT, this.diskMetricsManager, x -> x.getAvgReadCostTimeOfEachOpsForDisk().getOrDefault(diskID, 0.0), SystemTag.TYPE.toString(), READ, SystemTag.DISK.toString(), diskID);
            metricService.createAutoGauge(SystemMetric.DISK_IO_AVG_TIME.toString(), MetricLevel.IMPORTANT, this.diskMetricsManager, x -> x.getAvgWriteCostTimeOfEachOpsForDisk().getOrDefault(diskID, 0.0), SystemTag.TYPE.toString(), WRITE, SystemTag.DISK.toString(), diskID);
            metricService.createAutoGauge(SystemMetric.DISK_IO_AVG_SIZE.toString(), MetricLevel.IMPORTANT, this.diskMetricsManager, x -> x.getAvgSizeOfEachReadForDisk().getOrDefault(diskID, 0.0), SystemTag.TYPE.toString(), READ, SystemTag.DISK.toString(), diskID);
            metricService.createAutoGauge(SystemMetric.DISK_IO_AVG_SIZE.toString(), MetricLevel.IMPORTANT, this.diskMetricsManager, x -> x.getAvgSizeOfEachWriteForDisk().getOrDefault(diskID, 0.0), SystemTag.TYPE.toString(), WRITE, SystemTag.DISK.toString(), diskID);
            metricService.createAutoGauge(SystemMetric.DISK_IO_BUSY_PERCENTAGE.toString(), MetricLevel.IMPORTANT, this.diskMetricsManager, x -> x.getIoUtilsPercentage().getOrDefault(diskID, 0.0), SystemTag.DISK.toString(), diskID);
            metricService.createAutoGauge(SystemMetric.DISK_IO_AVG_QUEUE_SIZE.toString(), MetricLevel.IMPORTANT, this.diskMetricsManager, x -> x.getQueueSizeForDisk().getOrDefault(diskID, 0.0), SystemTag.DISK.toString(), diskID);
        }
        metricService.createAutoGauge(SystemMetric.PROCESS_IO_OPS.toString(), MetricLevel.IMPORTANT, this.diskMetricsManager, IDiskMetricsManager::getReadOpsCountForProcess, SystemTag.FROM.toString(), this.processName, SystemTag.NAME.toString(), READ);
        metricService.createAutoGauge(SystemMetric.PROCESS_IO_OPS.toString(), MetricLevel.IMPORTANT, this.diskMetricsManager, IDiskMetricsManager::getWriteOpsCountForProcess, SystemTag.FROM.toString(), this.processName, SystemTag.NAME.toString(), WRITE);
        metricService.createAutoGauge(SystemMetric.PROCESS_IO_SIZE.toString(), MetricLevel.IMPORTANT, this.diskMetricsManager, IDiskMetricsManager::getActualReadDataSizeForProcess, SystemTag.FROM.toString(), this.processName, SystemTag.NAME.toString(), ACTUAL_READ);
        metricService.createAutoGauge(SystemMetric.PROCESS_IO_SIZE.toString(), MetricLevel.IMPORTANT, this.diskMetricsManager, IDiskMetricsManager::getActualWriteDataSizeForProcess, SystemTag.FROM.toString(), this.processName, SystemTag.NAME.toString(), ACTUAL_WRITE);
        metricService.createAutoGauge(SystemMetric.PROCESS_IO_SIZE.toString(), MetricLevel.IMPORTANT, this.diskMetricsManager, IDiskMetricsManager::getAttemptReadSizeForProcess, SystemTag.FROM.toString(), this.processName, SystemTag.NAME.toString(), ATTEMPT_READ);
        metricService.createAutoGauge(SystemMetric.PROCESS_IO_SIZE.toString(), MetricLevel.IMPORTANT, this.diskMetricsManager, IDiskMetricsManager::getAttemptWriteSizeForProcess, SystemTag.FROM.toString(), this.processName, SystemTag.NAME.toString(), ATTEMPT_WRITE);
    }

    @Override
    public void unbindFrom(AbstractMetricService metricService) {
        Set<String> diskIDs = this.diskMetricsManager.getDiskIds();
        for (String diskID : diskIDs) {
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.DISK_IO_SIZE.toString(), SystemTag.TYPE.toString(), READ, SystemTag.DISK.toString(), diskID);
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.DISK_IO_SIZE.toString(), SystemTag.TYPE.toString(), WRITE, SystemTag.DISK.toString(), diskID);
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.DISK_IO_OPS.toString(), SystemTag.TYPE.toString(), READ, SystemTag.DISK.toString(), diskID);
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.DISK_IO_OPS.toString(), SystemTag.TYPE.toString(), WRITE, SystemTag.DISK.toString(), diskID);
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.DISK_IO_OPS.toString(), SystemTag.TYPE.toString(), AVG_READ, SystemTag.DISK.toString(), diskID);
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.DISK_IO_OPS.toString(), SystemTag.TYPE.toString(), AVG_WRITE, SystemTag.DISK.toString(), diskID);
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.DISK_IO_TIME.toString(), SystemTag.TYPE.toString(), READ, SystemTag.DISK.toString(), diskID);
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.DISK_IO_TIME.toString(), SystemTag.TYPE.toString(), WRITE, SystemTag.DISK.toString(), diskID);
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.DISK_IO_AVG_SIZE.toString(), SystemTag.TYPE.toString(), READ, SystemTag.DISK.toString(), diskID);
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.DISK_IO_AVG_SIZE.toString(), SystemTag.TYPE.toString(), WRITE, SystemTag.DISK.toString(), diskID);
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.DISK_IO_BUSY_PERCENTAGE.toString(), SystemTag.DISK.toString(), diskID);
            metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.DISK_IO_AVG_QUEUE_SIZE.toString(), SystemTag.DISK.toString(), diskID);
        }
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.PROCESS_IO_SIZE.toString(), SystemTag.FROM.toString(), this.processName, SystemTag.NAME.toString(), ACTUAL_READ);
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.PROCESS_IO_SIZE.toString(), SystemTag.FROM.toString(), this.processName, SystemTag.NAME.toString(), ACTUAL_WRITE);
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.PROCESS_IO_SIZE.toString(), SystemTag.FROM.toString(), this.processName, SystemTag.NAME.toString(), ATTEMPT_READ);
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.PROCESS_IO_SIZE.toString(), SystemTag.FROM.toString(), this.processName, SystemTag.NAME.toString(), ATTEMPT_WRITE);
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.PROCESS_IO_OPS.toString(), SystemTag.FROM.toString(), this.processName, SystemTag.NAME.toString(), READ);
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.PROCESS_IO_OPS.toString(), SystemTag.FROM.toString(), this.processName, SystemTag.NAME.toString(), WRITE);
    }
}

