/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.dprofile;

import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDAFIntegral
implements UDTF {
    private static final String TIME_UNIT_KEY = "unit";
    private static final String TIME_UNIT_S = "1s";
    long unitTime;
    long lastTime = -1L;
    double lastValue;
    double integralValue = 0.0;

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(1).validate(x -> (Long)x > 0L, "Unknown time unit input. Supported units are ns, us, ms, s, m, h, d.", (Object)Util.parseTime(validator.getParameters().getStringOrDefault(TIME_UNIT_KEY, TIME_UNIT_S), validator.getParameters()));
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        this.unitTime = Util.parseTime(parameters.getStringOrDefault(TIME_UNIT_KEY, TIME_UNIT_S), parameters);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        long nowTime = row.getTime();
        double nowValue = Util.getValueAsDouble(row);
        if (Double.isFinite(nowValue)) {
            if (this.lastTime >= 0L) {
                this.integralValue += (this.lastValue + nowValue) * (double)(nowTime - this.lastTime) / 2.0 / (double)this.unitTime;
            }
            this.lastTime = nowTime;
            this.lastValue = nowValue;
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
        collector.putDouble(0L, this.integralValue);
    }
}

