/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.retry.naming;

import javax.naming.NamingException;
import org.apache.james.util.retry.api.ExceptionRetryingProxy;
import org.apache.james.util.retry.api.RetrySchedule;
import org.apache.james.util.retry.naming.NamingExceptionRetryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoggingRetryHandler
extends NamingExceptionRetryHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingRetryHandler.class);

    public LoggingRetryHandler(Class<?>[] exceptionClasses, ExceptionRetryingProxy proxy, RetrySchedule schedule, int maxRetries) {
        super(exceptionClasses, proxy, schedule, maxRetries);
    }

    @Override
    public void postFailure(NamingException ex, int retryCount) {
        super.postFailure(ex, retryCount);
        LOGGER.info("Retry failure. Retrying in {} seconds", (Object)(this.getRetryInterval(retryCount) / 1000L), (Object)ex);
    }
}

