/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ccr;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.elasticsearch.client.ccr.FollowConfig;
import org.elasticsearch.client.ccr.PutAutoFollowPatternRequest;
import org.elasticsearch.client.ccr.PutFollowRequest;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public final class GetAutoFollowPatternResponse {
    static final ParseField PATTERNS_FIELD = new ParseField("patterns", new String[0]);
    static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    static final ParseField PATTERN_FIELD = new ParseField("pattern", new String[0]);
    private static final ConstructingObjectParser<Map.Entry<String, Pattern>, Void> ENTRY_PARSER = new ConstructingObjectParser("get_auto_follow_pattern_response", true, args -> new AbstractMap.SimpleEntry<String, Pattern>((String)args[0], (Pattern)args[1]));
    private static final ConstructingObjectParser<GetAutoFollowPatternResponse, Void> PARSER;
    private final NavigableMap<String, Pattern> patterns;

    public static GetAutoFollowPatternResponse fromXContent(XContentParser parser) {
        return (GetAutoFollowPatternResponse)PARSER.apply(parser, null);
    }

    GetAutoFollowPatternResponse(NavigableMap<String, Pattern> patterns) {
        this.patterns = Collections.unmodifiableNavigableMap(patterns);
    }

    public NavigableMap<String, Pattern> getPatterns() {
        return this.patterns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetAutoFollowPatternResponse that = (GetAutoFollowPatternResponse)o;
        return Objects.equals(this.patterns, that.patterns);
    }

    public int hashCode() {
        return Objects.hash(this.patterns);
    }

    static {
        ENTRY_PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME_FIELD);
        ENTRY_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (ContextParser)Pattern.PARSER, PATTERN_FIELD);
        PARSER = new ConstructingObjectParser("get_auto_follow_pattern_response", true, args -> {
            List entries = (List)args[0];
            return new GetAutoFollowPatternResponse(new TreeMap<String, Pattern>(entries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        });
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), ENTRY_PARSER, PATTERNS_FIELD);
    }

    public static class Pattern
    extends FollowConfig {
        private static final ConstructingObjectParser<Pattern, Void> PARSER = new ConstructingObjectParser("pattern", true, args -> new Pattern((String)args[0], (List)args[1], (String)args[2]));
        private final String remoteCluster;
        private final List<String> leaderIndexPatterns;
        private final String followIndexNamePattern;

        Pattern(String remoteCluster, List<String> leaderIndexPatterns, String followIndexNamePattern) {
            this.remoteCluster = remoteCluster;
            this.leaderIndexPatterns = leaderIndexPatterns;
            this.followIndexNamePattern = followIndexNamePattern;
        }

        public String getRemoteCluster() {
            return this.remoteCluster;
        }

        public List<String> getLeaderIndexPatterns() {
            return this.leaderIndexPatterns;
        }

        public String getFollowIndexNamePattern() {
            return this.followIndexNamePattern;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Pattern pattern = (Pattern)o;
            return Objects.equals(this.remoteCluster, pattern.remoteCluster) && Objects.equals(this.leaderIndexPatterns, pattern.leaderIndexPatterns) && Objects.equals(this.followIndexNamePattern, pattern.followIndexNamePattern);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.remoteCluster, this.leaderIndexPatterns, this.followIndexNamePattern);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), PutFollowRequest.REMOTE_CLUSTER_FIELD);
            PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), PutAutoFollowPatternRequest.LEADER_PATTERNS_FIELD);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), PutAutoFollowPatternRequest.FOLLOW_PATTERN_FIELD);
            PARSER.declareObject(FollowConfig::setSettings, (p, c) -> Settings.fromXContent((XContentParser)p), PutAutoFollowPatternRequest.SETTINGS);
            PARSER.declareInt(FollowConfig::setMaxReadRequestOperationCount, FollowConfig.MAX_READ_REQUEST_OPERATION_COUNT);
            PARSER.declareField(FollowConfig::setMaxReadRequestSize, (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)FollowConfig.MAX_READ_REQUEST_SIZE.getPreferredName()), PutFollowRequest.MAX_READ_REQUEST_SIZE, ObjectParser.ValueType.STRING);
            PARSER.declareInt(FollowConfig::setMaxOutstandingReadRequests, FollowConfig.MAX_OUTSTANDING_READ_REQUESTS);
            PARSER.declareInt(FollowConfig::setMaxWriteRequestOperationCount, FollowConfig.MAX_WRITE_REQUEST_OPERATION_COUNT);
            PARSER.declareField(FollowConfig::setMaxWriteRequestSize, (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)FollowConfig.MAX_WRITE_REQUEST_SIZE.getPreferredName()), PutFollowRequest.MAX_WRITE_REQUEST_SIZE, ObjectParser.ValueType.STRING);
            PARSER.declareInt(FollowConfig::setMaxOutstandingWriteRequests, FollowConfig.MAX_OUTSTANDING_WRITE_REQUESTS);
            PARSER.declareInt(FollowConfig::setMaxWriteBufferCount, FollowConfig.MAX_WRITE_BUFFER_COUNT);
            PARSER.declareField(FollowConfig::setMaxWriteBufferSize, (p, c) -> ByteSizeValue.parseBytesSizeValue((String)p.text(), (String)FollowConfig.MAX_WRITE_BUFFER_SIZE.getPreferredName()), PutFollowRequest.MAX_WRITE_BUFFER_SIZE, ObjectParser.ValueType.STRING);
            PARSER.declareField(FollowConfig::setMaxRetryDelay, (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)FollowConfig.MAX_RETRY_DELAY_FIELD.getPreferredName()), PutFollowRequest.MAX_RETRY_DELAY_FIELD, ObjectParser.ValueType.STRING);
            PARSER.declareField(FollowConfig::setReadPollTimeout, (p, c) -> TimeValue.parseTimeValue((String)p.text(), (String)FollowConfig.READ_POLL_TIMEOUT.getPreferredName()), PutFollowRequest.READ_POLL_TIMEOUT, ObjectParser.ValueType.STRING);
        }
    }
}

