/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.cassandra;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.sieve.cassandra.CassandraActiveScriptDAO;
import org.apache.james.sieve.cassandra.CassandraSieveDAO;
import org.apache.james.sieve.cassandra.CassandraSieveQuotaDAO;
import org.apache.james.sieve.cassandra.model.ActiveScriptInfo;
import org.apache.james.sieve.cassandra.model.Script;
import org.apache.james.sieve.cassandra.model.SieveQuota;
import org.apache.james.sieverepository.api.ScriptContent;
import org.apache.james.sieverepository.api.ScriptName;
import org.apache.james.sieverepository.api.ScriptSummary;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.sieverepository.api.exception.DuplicateException;
import org.apache.james.sieverepository.api.exception.IsActiveException;
import org.apache.james.sieverepository.api.exception.QuotaExceededException;
import org.apache.james.sieverepository.api.exception.QuotaNotFoundException;
import org.apache.james.sieverepository.api.exception.ScriptNotFoundException;
import org.apache.james.util.FunctionalUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraSieveRepository
implements SieveRepository {
    private final CassandraSieveDAO cassandraSieveDAO;
    private final CassandraSieveQuotaDAO cassandraSieveQuotaDAO;
    private final CassandraActiveScriptDAO cassandraActiveScriptDAO;

    @Inject
    public CassandraSieveRepository(CassandraSieveDAO cassandraSieveDAO, CassandraSieveQuotaDAO cassandraSieveQuotaDAO, CassandraActiveScriptDAO cassandraActiveScriptDAO) {
        this.cassandraSieveDAO = cassandraSieveDAO;
        this.cassandraSieveQuotaDAO = cassandraSieveQuotaDAO;
        this.cassandraActiveScriptDAO = cassandraActiveScriptDAO;
    }

    public ZonedDateTime getActivationDateForActiveScript(Username username) throws ScriptNotFoundException {
        return ((ActiveScriptInfo)this.cassandraActiveScriptDAO.getActiveSctiptInfo(username).blockOptional().orElseThrow(ScriptNotFoundException::new)).getActivationDate();
    }

    public void haveSpace(Username username, ScriptName name, long newSize) throws QuotaExceededException {
        this.reThrowQuotaExceededException(() -> this.spaceThatWillBeUsedByNewScript(username, name, newSize).flatMap(sizeDifference -> this.throwOnOverQuota(username, (Long)sizeDifference)).block());
    }

    private Mono<Void> throwOnOverQuota(Username username, Long sizeDifference) {
        Mono<Optional<QuotaSizeLimit>> userQuotaMono = this.cassandraSieveQuotaDAO.getQuota(username);
        Mono<Optional<QuotaSizeLimit>> globalQuotaMono = this.cassandraSieveQuotaDAO.getQuota();
        Mono<Long> spaceUsedMono = this.cassandraSieveQuotaDAO.spaceUsedBy(username);
        return this.limitToUse(userQuotaMono, globalQuotaMono).zipWith(spaceUsedMono).flatMap(pair -> this.checkOverQuotaUponModification(sizeDifference, (Long)pair.getT2(), (Optional)pair.getT1()));
    }

    private Mono<Void> checkOverQuotaUponModification(Long sizeDifference, Long spaceUsed, Optional<QuotaSizeLimit> limit) {
        try {
            new SieveQuota(spaceUsed, limit).checkOverQuotaUponModification(sizeDifference);
            return Mono.empty();
        }
        catch (QuotaExceededException e) {
            return Mono.error((Throwable)new RuntimeException(e));
        }
    }

    private Mono<Long> spaceThatWillBeUsedByNewScript(Username username, ScriptName name, long scriptSize) {
        return this.cassandraSieveDAO.getScript(username, name).map(Script::getSize).defaultIfEmpty((Object)0L).map(sizeOfStoredScript -> scriptSize - sizeOfStoredScript);
    }

    private Mono<Optional<QuotaSizeLimit>> limitToUse(Mono<Optional<QuotaSizeLimit>> userQuota, Mono<Optional<QuotaSizeLimit>> globalQuota) {
        return userQuota.filter(Optional::isPresent).switchIfEmpty(globalQuota);
    }

    public void putScript(Username username, ScriptName name, ScriptContent content) throws QuotaExceededException {
        Function<Long, Mono> updateAndInsert = spaceUsed -> Flux.merge((Publisher[])new Publisher[]{this.updateSpaceUsed(username, (long)spaceUsed), this.cassandraSieveDAO.insertScript(username, Script.builder().name(name).content(content).isActive(false).build())}).then();
        this.reThrowQuotaExceededException(() -> this.spaceThatWillBeUsedByNewScript(username, name, content.length()).flatMap(spaceUsed -> this.throwOnOverQuota(username, (Long)spaceUsed).thenEmpty((Publisher)updateAndInsert.apply((Long)spaceUsed))).block());
    }

    private void reThrowQuotaExceededException(Runnable runnable) throws QuotaExceededException {
        block2: {
            try {
                runnable.run();
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof QuotaExceededException)) break block2;
                throw (QuotaExceededException)e.getCause();
            }
        }
    }

    private Mono<Void> updateSpaceUsed(Username username, long spaceUsed) {
        if (spaceUsed == 0L) {
            return Mono.empty();
        }
        return this.cassandraSieveQuotaDAO.updateSpaceUsed(username, spaceUsed);
    }

    public List<ScriptSummary> listScripts(Username username) {
        return (List)this.cassandraSieveDAO.listScripts(username).collect(ImmutableList.toImmutableList()).block();
    }

    public InputStream getActive(Username username) throws ScriptNotFoundException {
        return IOUtils.toInputStream((String)((Script)this.cassandraActiveScriptDAO.getActiveSctiptInfo(username).flatMap(activeScriptInfo -> this.cassandraSieveDAO.getScript(username, activeScriptInfo.getName())).blockOptional().orElseThrow(ScriptNotFoundException::new)).getContent().getValue(), (Charset)StandardCharsets.UTF_8);
    }

    public void setActive(Username username, ScriptName name) throws ScriptNotFoundException {
        Mono activateNewScript = this.unactivateOldScript(username).then(this.updateScriptActivation(username, name, true)).filter(FunctionalUtils.identityPredicate()).flatMap(any -> this.cassandraActiveScriptDAO.activate(username, name).thenReturn(any));
        if (!activateNewScript.blockOptional().isPresent()) {
            throw new ScriptNotFoundException();
        }
    }

    private Mono<Void> unactivateOldScript(Username username) {
        return this.cassandraActiveScriptDAO.getActiveSctiptInfo(username).flatMap(activeScriptInfo -> this.updateScriptActivation(username, activeScriptInfo.getName(), false)).then();
    }

    private Mono<Boolean> updateScriptActivation(Username username, ScriptName scriptName, boolean active) {
        if (!scriptName.equals((Object)SieveRepository.NO_SCRIPT_NAME)) {
            return this.cassandraSieveDAO.updateScriptActivation(username, scriptName, active);
        }
        return this.cassandraActiveScriptDAO.unactivate(username).thenReturn((Object)true);
    }

    public InputStream getScript(Username username, ScriptName name) throws ScriptNotFoundException {
        return this.cassandraSieveDAO.getScript(username, name).blockOptional().map(script -> IOUtils.toInputStream((String)script.getContent().getValue(), (Charset)StandardCharsets.UTF_8)).orElseThrow(ScriptNotFoundException::new);
    }

    public void deleteScript(Username username, ScriptName name) throws ScriptNotFoundException, IsActiveException {
        this.ensureIsNotActive(username, name);
        if (!((Boolean)this.cassandraSieveDAO.deleteScriptInCassandra(username, name).defaultIfEmpty((Object)false).block()).booleanValue()) {
            throw new ScriptNotFoundException();
        }
    }

    private void ensureIsNotActive(Username username, ScriptName name) throws IsActiveException {
        Optional<ScriptName> activeName = this.cassandraActiveScriptDAO.getActiveSctiptInfo(username).blockOptional().map(ActiveScriptInfo::getName);
        if (activeName.isPresent() && name.equals((Object)activeName.get())) {
            throw new IsActiveException();
        }
    }

    public void renameScript(Username username, ScriptName oldName, ScriptName newName) throws ScriptNotFoundException, DuplicateException {
        Mono oldScript = this.cassandraSieveDAO.getScript(username, oldName).cache();
        Mono newScriptExists = this.cassandraSieveDAO.getScript(username, newName).hasElement();
        oldScript.block();
        if (((Boolean)newScriptExists.block()).booleanValue()) {
            throw new DuplicateException();
        }
        this.performScriptRename(username, newName, (Script)oldScript.blockOptional().orElseThrow(ScriptNotFoundException::new));
    }

    private void performScriptRename(Username username, ScriptName newName, Script oldScript) {
        Flux.merge((Publisher[])new Publisher[]{this.cassandraSieveDAO.insertScript(username, Script.builder().copyOf(oldScript).name(newName).build()), this.cassandraSieveDAO.deleteScriptInCassandra(username, oldScript.getName()), this.performActiveScriptRename(username, oldScript.getName(), newName)}).then().block();
    }

    private Mono<Void> performActiveScriptRename(Username username, ScriptName oldName, ScriptName newName) {
        return this.cassandraActiveScriptDAO.getActiveSctiptInfo(username).filter(activeScriptInfo -> activeScriptInfo.getName().equals((Object)oldName)).flatMap(name -> this.cassandraActiveScriptDAO.activate(username, newName));
    }

    public boolean hasDefaultQuota() {
        return ((Optional)this.cassandraSieveQuotaDAO.getQuota().block()).isPresent();
    }

    public QuotaSizeLimit getDefaultQuota() throws QuotaNotFoundException {
        return (QuotaSizeLimit)((Optional)this.cassandraSieveQuotaDAO.getQuota().block()).orElseThrow(QuotaNotFoundException::new);
    }

    public void setDefaultQuota(QuotaSizeLimit quota) {
        this.cassandraSieveQuotaDAO.setQuota(quota).block();
    }

    public void removeQuota() {
        this.cassandraSieveQuotaDAO.removeQuota().block();
    }

    public boolean hasQuota(Username username) {
        Mono hasUserQuota = this.cassandraSieveQuotaDAO.getQuota(username).map(Optional::isPresent);
        Mono hasGlobalQuota = this.cassandraSieveQuotaDAO.getQuota().map(Optional::isPresent);
        return (Boolean)hasUserQuota.zipWith(hasGlobalQuota, (a, b) -> a != false || b != false).block();
    }

    public QuotaSizeLimit getQuota(Username username) throws QuotaNotFoundException {
        return (QuotaSizeLimit)((Optional)this.cassandraSieveQuotaDAO.getQuota(username).block()).orElseThrow(QuotaNotFoundException::new);
    }

    public void setQuota(Username username, QuotaSizeLimit quota) {
        this.cassandraSieveQuotaDAO.setQuota(username, quota).block();
    }

    public void removeQuota(Username username) {
        this.cassandraSieveQuotaDAO.removeQuota(username).block();
    }
}

