/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.github.fge.lambdas.Throwing;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.mailrepository.api.MailRepositoryStore;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.task.Task;
import org.apache.james.util.streams.Iterators;
import org.apache.james.util.streams.Limit;
import org.apache.james.webadmin.service.MailRepositoryStoreService;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReprocessingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReprocessingService.class);
    public static final AttributeName RETRY_ATTRIBUTE_NAME = AttributeName.of((String)"mailRepository-reprocessing");
    private final MailQueueFactory<?> mailQueueFactory;
    private final MailRepositoryStoreService mailRepositoryStoreService;

    @Inject
    public ReprocessingService(MailQueueFactory<?> mailQueueFactory, MailRepositoryStoreService mailRepositoryStoreService) {
        this.mailQueueFactory = mailQueueFactory;
        this.mailRepositoryStoreService = mailRepositoryStoreService;
    }

    public Mono<Task.Result> reprocessAll(MailRepositoryPath path, Configuration configuration, Consumer<MailKey> keyListener) {
        return Mono.using(() -> new Reprocessor(this.getMailQueue(configuration.getMailQueueName()), configuration), reprocessor -> this.reprocessAll((Reprocessor)reprocessor, path, configuration, keyListener), Reprocessor::close);
    }

    private Mono<Task.Result> reprocessAll(Reprocessor reprocessor, MailRepositoryPath path, Configuration configuration, Consumer<MailKey> keyListener) {
        return configuration.limit.applyOnFlux(Flux.fromStream((Supplier)Throwing.supplier(() -> this.mailRepositoryStoreService.getRepositories(path))).flatMap((Function)Throwing.function(repository -> Iterators.toFlux((Iterator)repository.list()).doOnNext(keyListener).flatMap(mailKey -> Mono.fromCallable(() -> repository.retrieve(mailKey)).map(mail -> Triple.of((Object)mail, (Object)repository, (Object)mailKey))).filter(triple -> !reprocessor.retryExceeded((Mail)triple.getLeft()))))).flatMap(triple -> this.reprocess((MailKey)triple.getRight(), (Mail)triple.getLeft(), (MailRepository)triple.getMiddle(), reprocessor)).reduce((Object)Task.Result.COMPLETED, Task::combine);
    }

    private Mono<Task.Result> reprocess(MailKey key, Mail mail, MailRepository repository, Reprocessor reprocessor) {
        return Mono.fromRunnable(() -> reprocessor.reprocess(repository, mail, key)).thenReturn((Object)Task.Result.COMPLETED).onErrorResume(error -> {
            LOGGER.warn("Failed when reprocess mail {}", (Object)key.asString(), error);
            return Mono.just((Object)Task.Result.PARTIAL);
        });
    }

    public void reprocess(MailRepositoryPath path, MailKey key, Configuration configuration) throws MailRepositoryStore.MailRepositoryStoreException, MessagingException {
        try (Reprocessor reprocessor = new Reprocessor(this.getMailQueue(configuration.getMailQueueName()), configuration);){
            Pair mailPair = this.mailRepositoryStoreService.getRepositories(path).map(Throwing.function(repository -> Pair.of((Object)repository, Optional.ofNullable(repository.retrieve(key))))).filter(pair -> ((Optional)pair.getRight()).isPresent()).map(pair -> Pair.of((Object)((MailRepository)pair.getLeft()), (Object)((Mail)((Optional)pair.getRight()).get()))).findFirst().orElseThrow(() -> new MissingKeyException(key));
            reprocessor.reprocess((MailRepository)mailPair.getKey(), (Mail)mailPair.getValue(), key);
        }
    }

    private MailQueue getMailQueue(MailQueueName targetQueue) {
        return (MailQueue)this.mailQueueFactory.getQueue(targetQueue).orElseThrow(() -> new RuntimeException("Can not find queue " + targetQueue.asString()));
    }

    static class Reprocessor
    implements Closeable {
        private final MailQueue mailQueue;
        private final Configuration configuration;

        Reprocessor(MailQueue mailQueue, Configuration configuration) {
            this.mailQueue = mailQueue;
            this.configuration = configuration;
        }

        private void reprocess(MailRepository repository, Mail mail, MailKey key) {
            try {
                this.incrementRetries(mail);
                this.configuration.getTargetProcessor().ifPresent(arg_0 -> ((Mail)mail).setState(arg_0));
                this.mailQueue.enQueue(mail);
                if (this.configuration.isConsume()) {
                    repository.remove(key);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error encountered while reprocessing mail " + mail.getName(), e);
            }
            finally {
                LifecycleUtil.dispose((Object)mail);
            }
        }

        private boolean retryExceeded(Mail mail) {
            Integer retryCount = mail.getAttribute(RETRY_ATTRIBUTE_NAME).map(attribute -> attribute.getValue().getValue()).filter(Integer.class::isInstance).map(Integer.class::cast).orElse(0);
            return this.configuration.getMaxRetries().map(maxRetries -> retryCount >= maxRetries).orElse(false);
        }

        private void incrementRetries(Mail mail) {
            Integer retryCount = mail.getAttribute(RETRY_ATTRIBUTE_NAME).map(attribute -> attribute.getValue().getValue()).filter(Integer.class::isInstance).map(Integer.class::cast).orElse(0);
            mail.setAttribute(new Attribute(RETRY_ATTRIBUTE_NAME, AttributeValue.of((Integer)(retryCount + 1))));
        }

        @Override
        public void close() {
            try {
                this.mailQueue.close();
            }
            catch (IOException e) {
                LOGGER.debug("error closing queue", (Throwable)e);
            }
        }
    }

    public static class Configuration {
        private final MailQueueName mailQueueName;
        private final Optional<String> targetProcessor;
        private final Optional<Integer> maxRetries;
        private final boolean consume;
        private final Limit limit;

        public Configuration(MailQueueName mailQueueName, Optional<String> targetProcessor, Optional<Integer> maxRetries, boolean consume, Limit limit) {
            this.mailQueueName = mailQueueName;
            this.targetProcessor = targetProcessor;
            this.maxRetries = maxRetries;
            this.consume = consume;
            this.limit = limit;
        }

        public MailQueueName getMailQueueName() {
            return this.mailQueueName;
        }

        public Optional<String> getTargetProcessor() {
            return this.targetProcessor;
        }

        public boolean isConsume() {
            return this.consume;
        }

        public Limit getLimit() {
            return this.limit;
        }

        public Optional<Integer> getMaxRetries() {
            return this.maxRetries;
        }
    }

    public static class MissingKeyException
    extends RuntimeException {
        MissingKeyException(MailKey key) {
            super(key.asString() + " can not be found");
        }
    }
}

