/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model;

import jakarta.json.bind.JsonbException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;

public class JsonbAnnotatedElement<T extends AnnotatedElement> {
    private final Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>(4);
    private final T element;

    public JsonbAnnotatedElement(T element) {
        for (Annotation ann : element.getAnnotations()) {
            this.annotations.put(ann.annotationType(), ann);
        }
        this.element = element;
    }

    public T getElement() {
        return this.element;
    }

    public <AT extends Annotation> AT getAnnotation(Class<AT> annotationClass) {
        return (AT)((Annotation)annotationClass.cast(this.annotations.get(annotationClass)));
    }

    public Annotation[] getAnnotations() {
        return this.annotations.values().toArray(new Annotation[0]);
    }

    public void putAnnotation(Annotation annotation) {
        if (this.annotations.containsKey(annotation.annotationType())) {
            throw new JsonbException(Messages.getMessage(MessageKeys.INTERNAL_ERROR, "Annotation already present: " + annotation));
        }
        this.annotations.put(annotation.annotationType(), annotation);
    }
}

