/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.imap.api.ImapConfiguration;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.CapabilityRequest;
import org.apache.james.imap.message.response.CapabilityResponse;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import reactor.core.publisher.Mono;

public class CapabilityProcessor
extends AbstractMailboxProcessor<CapabilityRequest>
implements CapabilityImplementingProcessor {
    private static final List<Capability> CAPS = ImmutableList.of((Object)ImapConstants.BASIC_CAPABILITIES, (Object)ImapConstants.SUPPORTS_LITERAL_PLUS, (Object)ImapConstants.SUPPORTS_RFC3348, (Object)ImapConstants.SUPPORTS_I18NLEVEL_1, (Object)ImapConstants.SUPPORTS_CONDSTORE, (Object)ImapConstants.SUPPORTS_OBJECTID, (Object)ImapConstants.SUPPORTS_SAVEDATE);
    private final List<CapabilityImplementingProcessor> capabilities = new ArrayList<CapabilityImplementingProcessor>();
    private final Set<Capability> disabledCaps = new HashSet<Capability>();

    @Inject
    public CapabilityProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(CapabilityRequest.class, mailboxManager, factory, metricFactory);
        this.capabilities.add(this);
    }

    @Override
    public void configure(ImapConfiguration imapConfiguration) {
        super.configure(imapConfiguration);
        this.disabledCaps.addAll((Collection<Capability>)imapConfiguration.getDisabledCaps());
        if (imapConfiguration.isCondstoreEnable()) {
            this.disabledCaps.remove(ImapConstants.SUPPORTS_CONDSTORE);
        } else {
            this.disabledCaps.add(ImapConstants.SUPPORTS_CONDSTORE);
        }
        if (!this.getMailboxManager().getSupportedMessageCapabilities().contains(MailboxManager.MessageCapabilities.UniqueID)) {
            this.disabledCaps.add(ImapConstants.SUPPORTS_OBJECTID);
        }
    }

    @Override
    protected Mono<Void> processRequestReactive(CapabilityRequest request, ImapSession session, ImapProcessor.Responder responder) {
        CapabilityResponse result = new CapabilityResponse(this.getSupportedCapabilities(session));
        responder.respond(result);
        return this.unsolicitedResponses(session, responder, false).then(Mono.fromRunnable(() -> this.okComplete(request, responder)));
    }

    public void addProcessor(CapabilityImplementingProcessor implementor) {
        this.capabilities.add(implementor);
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return CAPS;
    }

    public Set<Capability> getSupportedCapabilities(ImapSession session) {
        HashSet<Capability> caps = new HashSet<Capability>();
        for (CapabilityImplementingProcessor capability : this.capabilities) {
            caps.addAll(capability.getImplementedCapabilities(session));
        }
        caps.removeAll(this.disabledCaps);
        return caps;
    }

    @Override
    protected MDCBuilder mdc(CapabilityRequest request) {
        return MDCBuilder.create().addToContext("action", "CAPABILITY");
    }
}

