/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.gco;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.Locale;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.FilterByVersion;
import org.apache.sis.xml.bind.gco.CharSequenceAdapter;
import org.apache.sis.xml.bind.gco.GO_CharacterString;
import org.opengis.util.InternationalString;

public class StringAdapter
extends XmlAdapter<GO_CharacterString, String> {
    public static String toString(CharSequence text) {
        Locale locale;
        Context context2;
        if (text == null) {
            return null;
        }
        if (text instanceof InternationalString && (context2 = Context.current()) != null && (locale = context2.getLocale()) != null) {
            return ((InternationalString)text).toString(locale);
        }
        return text.toString();
    }

    static String toString(GO_CharacterString value) {
        return value != null ? StringAdapter.toString(value.toCharSequence()) : null;
    }

    @Override
    public String unmarshal(GO_CharacterString value) {
        return StringAdapter.toString(value);
    }

    @Override
    public GO_CharacterString marshal(String value) {
        return CharSequenceAdapter.wrap(Context.current(), value, value);
    }

    public static final class Since2014
    extends StringAdapter {
        @Override
        public GO_CharacterString marshal(String value) {
            return FilterByVersion.CURRENT_METADATA.accept() ? super.marshal(value) : null;
        }
    }
}

