/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SimpleOrderedMap;

public final class ToleratedUpdateError {
    private static final String META_PRE = ToleratedUpdateError.class.getName() + "--";
    private static final int META_PRE_LEN = META_PRE.length();
    private final CmdType type;
    private final String id;
    private final String message;

    public static int getEffectiveMaxErrors(int maxErrors) {
        assert (-1 <= maxErrors);
        return -1 == maxErrors ? Integer.MAX_VALUE : maxErrors;
    }

    public static int getUserFriendlyMaxErrors(int maxErrors) {
        assert (-1 <= maxErrors);
        return Integer.MAX_VALUE == maxErrors ? -1 : maxErrors;
    }

    public static List<SimpleOrderedMap<String>> formatForResponseHeader(List<ToleratedUpdateError> errs) {
        ArrayList<SimpleOrderedMap<String>> result = new ArrayList<SimpleOrderedMap<String>>(errs.size());
        for (ToleratedUpdateError e : errs) {
            result.add(e.getSimpleMap());
        }
        return result;
    }

    public static ToleratedUpdateError parseMap(SimpleOrderedMap<String> data) {
        String id = (String)data.get("id");
        String message = (String)data.get("message");
        String t = (String)data.get("type");
        if (null == t || null == id || null == message) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Map does not represent a ToleratedUpdateError, must contain 'type', 'id', and 'message'");
        }
        try {
            return new ToleratedUpdateError(CmdType.valueOf(t), id, message);
        }
        catch (IllegalArgumentException iae) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Invalid type for ToleratedUpdateError: " + t, (Throwable)iae);
        }
    }

    public static ToleratedUpdateError parseMetadataIfToleratedUpdateError(String metadataKey, String metadataVal) {
        if (!metadataKey.startsWith(META_PRE)) {
            return null;
        }
        int typeEnd = metadataKey.indexOf(58, META_PRE_LEN);
        if (typeEnd < 0) {
            return null;
        }
        return new ToleratedUpdateError(CmdType.valueOf(metadataKey.substring(META_PRE_LEN, typeEnd)), metadataKey.substring(typeEnd + 1), metadataVal);
    }

    public ToleratedUpdateError(CmdType type, String id, String message) {
        assert (null != type);
        this.type = type;
        assert (null != id);
        this.id = id;
        assert (null != message);
        this.message = message;
    }

    public CmdType getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMetadataKey() {
        return META_PRE + this.type + ":" + this.id;
    }

    public String getMetadataValue() {
        return this.message.toString();
    }

    public SimpleOrderedMap<String> getSimpleMap() {
        SimpleOrderedMap<String> entry = new SimpleOrderedMap<String>();
        entry.add("type", this.type.toString());
        entry.add("id", this.id);
        entry.add("message", this.message);
        return entry;
    }

    public String toString() {
        return this.getMetadataKey() + "=>" + this.getMetadataValue();
    }

    public int hashCode() {
        int h = this.getClass().hashCode();
        h = h * 31 + this.type.hashCode();
        h = h * 31 + this.id.hashCode();
        h = h * 31 + this.message.hashCode();
        return h;
    }

    public boolean equals(Object o) {
        if (o instanceof ToleratedUpdateError) {
            ToleratedUpdateError that = (ToleratedUpdateError)o;
            return that.type.equals((Object)this.type) && that.id.equals(this.id) && that.message.equals(this.message);
        }
        return false;
    }

    public static enum CmdType {
        ADD,
        DELID,
        DELQ;

    }
}

