/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.metadata;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;

public abstract class AbstractMetadata
implements Metadata {
    private Metadata newInstance(Map<String, String> properties, Path path) {
        return new DefaultMetadata(this.getGroupId(), this.getArtifactId(), this.getVersion(), this.getType(), this.getNature(), path, properties);
    }

    @Override
    @Deprecated
    public Metadata setFile(File file) {
        File current = this.getFile();
        if (Objects.equals(current, file)) {
            return this;
        }
        return this.newInstance(this.getProperties(), file != null ? file.toPath() : null);
    }

    @Override
    public Metadata setPath(Path path) {
        Path current = this.getPath();
        if (Objects.equals(current, path)) {
            return this;
        }
        return this.newInstance(this.getProperties(), path);
    }

    @Override
    public Metadata setProperties(Map<String, String> properties) {
        Map<String, String> current = this.getProperties();
        if (current.equals(properties) || properties == null && current.isEmpty()) {
            return this;
        }
        return this.newInstance(AbstractMetadata.copyProperties(properties), this.getPath());
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.getProperties().get(key);
        return value != null ? value : defaultValue;
    }

    protected static Map<String, String> copyProperties(Map<String, String> properties) {
        if (properties != null && !properties.isEmpty()) {
            return Collections.unmodifiableMap(new HashMap<String, String>(properties));
        }
        return Collections.emptyMap();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        if (!this.getGroupId().isEmpty()) {
            buffer.append(this.getGroupId());
        }
        if (!this.getArtifactId().isEmpty()) {
            buffer.append(':').append(this.getArtifactId());
        }
        if (!this.getVersion().isEmpty()) {
            buffer.append(':').append(this.getVersion());
        }
        buffer.append('/').append(this.getType());
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Metadata)) {
            return false;
        }
        Metadata that = (Metadata)obj;
        return Objects.equals(this.getArtifactId(), that.getArtifactId()) && Objects.equals(this.getGroupId(), that.getGroupId()) && Objects.equals(this.getVersion(), that.getVersion()) && Objects.equals(this.getType(), that.getType()) && Objects.equals((Object)this.getNature(), (Object)that.getNature()) && Objects.equals(this.getPath(), that.getPath()) && Objects.equals(this.getProperties(), that.getProperties());
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.getGroupId().hashCode();
        hash = hash * 31 + this.getArtifactId().hashCode();
        hash = hash * 31 + this.getType().hashCode();
        hash = hash * 31 + this.getNature().hashCode();
        hash = hash * 31 + this.getVersion().hashCode();
        hash = hash * 31 + AbstractMetadata.hash(this.getPath());
        return hash;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }
}

