/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.statemachine.transition;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.mina.statemachine.State;
import org.apache.mina.statemachine.context.StateContext;
import org.apache.mina.statemachine.transition.AbstractSelfTransition;
import org.apache.mina.statemachine.transition.AmbiguousMethodException;
import org.apache.mina.statemachine.transition.MethodInvocationException;
import org.apache.mina.statemachine.transition.MethodTransition;
import org.apache.mina.statemachine.transition.NoSuchMethodException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodSelfTransition
extends AbstractSelfTransition {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodTransition.class);
    private Method method;
    private final Object target;
    private static final Object[] EMPTY_ARGUMENTS = new Object[0];

    public MethodSelfTransition(Method method, Object target) {
        this.method = method;
        this.target = target;
    }

    public MethodSelfTransition(String methodName, Object target) {
        this.target = target;
        Method[] candidates = target.getClass().getMethods();
        Method result = null;
        for (Method candidate : candidates) {
            if (!candidate.getName().equals(methodName)) continue;
            if (result != null) {
                throw new AmbiguousMethodException(methodName);
            }
            result = candidate;
        }
        if (result == null) {
            throw new NoSuchMethodException(methodName);
        }
        this.method = result;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public boolean doExecute(StateContext stateContext, State state) {
        Class<?>[] types = this.method.getParameterTypes();
        if (types.length == 0) {
            this.invokeMethod(EMPTY_ARGUMENTS);
            return true;
        }
        if (types.length > 2) {
            return false;
        }
        Object[] args = new Object[types.length];
        int i = 0;
        if (types[i].isAssignableFrom(StateContext.class)) {
            args[i++] = stateContext;
        }
        if (i < types.length && types[i].isAssignableFrom(State.class)) {
            args[i++] = state;
        }
        this.invokeMethod(args);
        return true;
    }

    private void invokeMethod(Object[] arguments) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Executing method " + this.method + " with arguments " + Arrays.asList(arguments));
            }
            this.method.invoke(this.target, arguments);
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ite.getCause();
            }
            throw new MethodInvocationException(this.method, (Throwable)ite);
        }
        catch (IllegalAccessException iae) {
            throw new MethodInvocationException(this.method, (Throwable)iae);
        }
    }
}

