/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.undo.UndoableEdit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.document.DocumentSpiPackageAccessor;
import org.netbeans.modules.editor.lib2.document.EditorDocumentHandler;
import org.netbeans.modules.editor.lib2.document.ModRootElement;
import org.netbeans.spi.editor.document.OnSaveTask;
import org.openide.util.Mutex;

public final class BeforeSaveTasks {
    private static final Logger LOG = Logger.getLogger(BeforeSaveTasks.class.getName());
    private static final ThreadLocal<Boolean> ignoreOnSaveTasks = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final BaseDocument doc;

    public static synchronized BeforeSaveTasks get(BaseDocument doc) {
        BeforeSaveTasks beforeSaveTasks = (BeforeSaveTasks)doc.getProperty(BeforeSaveTasks.class);
        if (beforeSaveTasks == null) {
            beforeSaveTasks = new BeforeSaveTasks(doc);
            doc.putProperty(BeforeSaveTasks.class, beforeSaveTasks);
        }
        return beforeSaveTasks;
    }

    public static <T> T runWithOnSaveTasksDisabled(Mutex.Action<T> run) {
        Boolean originalIgnore = ignoreOnSaveTasks.get();
        ignoreOnSaveTasks.set(true);
        try {
            T t = run.run();
            return t;
        }
        finally {
            ignoreOnSaveTasks.set(originalIgnore);
        }
    }

    private BeforeSaveTasks(BaseDocument doc) {
        this.doc = doc;
        Runnable beforeSaveRunnable = (Runnable)doc.getProperty("beforeSaveRunnable");
        if (beforeSaveRunnable != null) {
            throw new IllegalStateException("\"beforeSaveRunnable\" property of document " + doc + " is already occupied by " + beforeSaveRunnable);
        }
        beforeSaveRunnable = new Runnable(){

            @Override
            public void run() {
                BeforeSaveTasks.this.runTasks();
            }
        };
        doc.putProperty("beforeSaveRunnable", beforeSaveRunnable);
    }

    void runTasks() {
        if (ignoreOnSaveTasks.get() == Boolean.TRUE) {
            return;
        }
        String mimeType = DocumentUtilities.getMimeType(this.doc);
        Collection<OnSaveTask.Factory> factories = MimeLookup.getLookup(mimeType).lookupAll(OnSaveTask.Factory.class);
        OnSaveTask.Context context = DocumentSpiPackageAccessor.get().createContext(this.doc);
        ArrayList<OnSaveTask> tasks = new ArrayList<OnSaveTask>(factories.size());
        for (OnSaveTask.Factory factory : factories) {
            OnSaveTask task = factory.createTask(context);
            if (task == null) continue;
            tasks.add(task);
        }
        new TaskRunnable(this.doc, tasks, context).run();
    }

    private static final class TaskRunnable
    implements Runnable {
        final BaseDocument doc;
        final List<OnSaveTask> tasks;
        final OnSaveTask.Context context;
        int lockedTaskIndex;

        public TaskRunnable(BaseDocument doc, List<OnSaveTask> tasks, OnSaveTask.Context context) {
            this.doc = doc;
            this.tasks = tasks;
            this.context = context;
        }

        @Override
        public void run() {
            if (this.lockedTaskIndex < this.tasks.size()) {
                OnSaveTask task = this.tasks.get(this.lockedTaskIndex++);
                task.runLocked(this);
            } else {
                this.doc.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Runnable beforeSaveStart = (Runnable)doc.getProperty("beforeSaveStart");
                        if (beforeSaveStart != null) {
                            beforeSaveStart.run();
                        }
                        UndoableEdit atomicEdit = EditorDocumentHandler.startOnSaveTasks(doc);
                        assert (atomicEdit != null) : "Null atomic edit";
                        boolean success = false;
                        try {
                            DocumentSpiPackageAccessor.get().setUndoEdit(context, atomicEdit);
                            for (int i = 0; i < tasks.size(); ++i) {
                                OnSaveTask task = tasks.get(i);
                                DocumentSpiPackageAccessor.get().setTaskStarted(context, true);
                                task.performTask();
                            }
                            ModRootElement modRootElement = ModRootElement.get(doc);
                            if (modRootElement != null) {
                                modRootElement.resetMods(atomicEdit);
                            }
                            success = true;
                        }
                        finally {
                            EditorDocumentHandler.endOnSaveTasks(doc, success);
                            Runnable beforeSaveEnd = (Runnable)doc.getProperty("beforeSaveEnd");
                            if (beforeSaveEnd != null) {
                                beforeSaveEnd.run();
                            }
                        }
                    }
                });
            }
        }
    }
}

