/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar;

import com.github.junrar.UnrarCallback;
import com.github.junrar.crypt.Rijndael;
import com.github.junrar.exception.BadRarArchiveException;
import com.github.junrar.exception.CorruptHeaderException;
import com.github.junrar.exception.CrcErrorException;
import com.github.junrar.exception.HeaderNotInArchiveException;
import com.github.junrar.exception.InitDeciphererFailedException;
import com.github.junrar.exception.MainHeaderNullException;
import com.github.junrar.exception.NotRarArchiveException;
import com.github.junrar.exception.RarException;
import com.github.junrar.exception.UnsupportedRarEncryptedException;
import com.github.junrar.exception.UnsupportedRarV5Exception;
import com.github.junrar.io.RawDataIo;
import com.github.junrar.io.SeekableReadOnlyByteChannel;
import com.github.junrar.rarfile.AVHeader;
import com.github.junrar.rarfile.BaseBlock;
import com.github.junrar.rarfile.BlockHeader;
import com.github.junrar.rarfile.CommentHeader;
import com.github.junrar.rarfile.EAHeader;
import com.github.junrar.rarfile.EndArcHeader;
import com.github.junrar.rarfile.FileHeader;
import com.github.junrar.rarfile.MacInfoHeader;
import com.github.junrar.rarfile.MainHeader;
import com.github.junrar.rarfile.MarkHeader;
import com.github.junrar.rarfile.ProtectHeader;
import com.github.junrar.rarfile.RARVersion;
import com.github.junrar.rarfile.SignHeader;
import com.github.junrar.rarfile.SubBlockHeader;
import com.github.junrar.rarfile.SubBlockHeaderType;
import com.github.junrar.rarfile.UnixOwnersHeader;
import com.github.junrar.rarfile.UnrarHeadertype;
import com.github.junrar.unpack.ComprDataIO;
import com.github.junrar.unpack.Unpack;
import com.github.junrar.volume.FileVolumeManager;
import com.github.junrar.volume.InputStreamVolumeManager;
import com.github.junrar.volume.Volume;
import com.github.junrar.volume.VolumeManager;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Archive
implements Closeable,
Iterable<FileHeader> {
    private static final Logger logger = LoggerFactory.getLogger(Archive.class);
    private static final int MAX_HEADER_SIZE = 0x1400000;
    private static final int PIPE_BUFFER_SIZE = Archive.getPropertyAs("junrar.extractor.buffer-size", Integer::parseInt, 32768);
    private static final boolean USE_EXECUTOR = Archive.getPropertyAs("junrar.extractor.use-executor", Boolean::parseBoolean, true);
    private SeekableReadOnlyByteChannel channel;
    private final UnrarCallback unrarCallback;
    private final ComprDataIO dataIO;
    private final List<BaseBlock> headers = new ArrayList<BaseBlock>();
    private MarkHeader markHead = null;
    private MainHeader newMhd = null;
    private Unpack unpack;
    private int currentHeaderIndex;
    private long totalPackedSize = 0L;
    private long totalPackedRead = 0L;
    private VolumeManager volumeManager;
    private Volume volume;
    private FileHeader nextFileHeader;
    private String password;

    public Archive(VolumeManager volumeManager, UnrarCallback unrarCallback, String password) throws RarException, IOException {
        this.volumeManager = volumeManager;
        this.unrarCallback = unrarCallback;
        this.password = password;
        try {
            this.setVolume(this.volumeManager.nextVolume(this, null));
        }
        catch (RarException | IOException e) {
            try {
                this.close();
            }
            catch (IOException e1) {
                logger.error("Failed to close the archive after an internal error!");
            }
            throw e;
        }
        this.dataIO = new ComprDataIO(this);
    }

    public Archive(File firstVolume) throws RarException, IOException {
        this(new FileVolumeManager(firstVolume), null, null);
    }

    public Archive(File firstVolume, UnrarCallback unrarCallback) throws RarException, IOException {
        this(new FileVolumeManager(firstVolume), unrarCallback, null);
    }

    public Archive(File firstVolume, String password) throws RarException, IOException {
        this(new FileVolumeManager(firstVolume), null, password);
    }

    public Archive(File firstVolume, UnrarCallback unrarCallback, String password) throws RarException, IOException {
        this(new FileVolumeManager(firstVolume), unrarCallback, password);
    }

    public Archive(InputStream rarAsStream) throws RarException, IOException {
        this(new InputStreamVolumeManager(rarAsStream), null, null);
    }

    public Archive(InputStream rarAsStream, UnrarCallback unrarCallback) throws RarException, IOException {
        this(new InputStreamVolumeManager(rarAsStream), unrarCallback, null);
    }

    public Archive(InputStream rarAsStream, String password) throws IOException, RarException {
        this(new InputStreamVolumeManager(rarAsStream), null, password);
    }

    public Archive(InputStream rarAsStream, UnrarCallback unrarCallback, String password) throws IOException, RarException {
        this(new InputStreamVolumeManager(rarAsStream), unrarCallback, password);
    }

    private void setChannel(SeekableReadOnlyByteChannel channel, long length) throws IOException, RarException {
        this.totalPackedSize = 0L;
        this.totalPackedRead = 0L;
        this.close();
        this.channel = channel;
        try {
            this.readHeaders(length);
        }
        catch (BadRarArchiveException | CorruptHeaderException | UnsupportedRarEncryptedException | UnsupportedRarV5Exception e) {
            logger.warn("exception in archive constructor maybe file is encrypted, corrupt or support not yet implemented", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.warn("exception in archive constructor maybe file is encrypted, corrupt or support not yet implemented", (Throwable)e);
        }
        for (BaseBlock block : this.headers) {
            if (block.getHeaderType() != UnrarHeadertype.FileHeader) continue;
            this.totalPackedSize += ((FileHeader)block).getFullPackSize();
        }
        if (this.unrarCallback != null) {
            this.unrarCallback.volumeProgressChanged(this.totalPackedRead, this.totalPackedSize);
        }
    }

    public void bytesReadRead(int count) {
        if (count > 0) {
            this.totalPackedRead += (long)count;
            if (this.unrarCallback != null) {
                this.unrarCallback.volumeProgressChanged(this.totalPackedRead, this.totalPackedSize);
            }
        }
    }

    public SeekableReadOnlyByteChannel getChannel() {
        return this.channel;
    }

    public List<BaseBlock> getHeaders() {
        return new ArrayList<BaseBlock>(this.headers);
    }

    public List<FileHeader> getFileHeaders() {
        ArrayList<FileHeader> list = new ArrayList<FileHeader>();
        for (BaseBlock block : this.headers) {
            if (!block.getHeaderType().equals((Object)UnrarHeadertype.FileHeader)) continue;
            list.add((FileHeader)block);
        }
        return list;
    }

    public FileHeader nextFileHeader() {
        int n = this.headers.size();
        while (this.currentHeaderIndex < n) {
            BaseBlock block;
            if ((block = this.headers.get(this.currentHeaderIndex++)).getHeaderType() != UnrarHeadertype.FileHeader) continue;
            return (FileHeader)block;
        }
        return null;
    }

    public UnrarCallback getUnrarCallback() {
        return this.unrarCallback;
    }

    public boolean isEncrypted() throws RarException {
        if (this.newMhd != null) {
            return this.newMhd.isEncrypted();
        }
        throw new MainHeaderNullException();
    }

    public boolean isPasswordProtected() throws RarException {
        if (this.isEncrypted()) {
            return true;
        }
        return this.getFileHeaders().stream().anyMatch(FileHeader::isEncrypted);
    }

    private void readHeaders(long fileLength) throws IOException, RarException {
        this.markHead = null;
        this.newMhd = null;
        this.headers.clear();
        this.currentHeaderIndex = 0;
        int toRead = 0;
        HashSet<Long> processedPositions = new HashSet<Long>();
        block25: while (true) {
            long position;
            int size = 0;
            long newpos = 0L;
            RawDataIo rawData = new RawDataIo(this.channel);
            byte[] baseBlockBuffer = Archive.safelyAllocate(7L, 0x1400000);
            if (this.newMhd != null && this.newMhd.isEncrypted()) {
                byte[] salt = new byte[8];
                rawData.readFully(salt, 8);
                try {
                    Cipher cipher = Rijndael.buildDecipherer(this.password, salt);
                    rawData.setCipher(cipher);
                }
                catch (Exception e) {
                    throw new InitDeciphererFailedException(e);
                }
            }
            if ((position = this.channel.getPosition()) >= fileLength || (size = rawData.readFully(baseBlockBuffer, baseBlockBuffer.length)) == 0) break;
            BaseBlock block = new BaseBlock(baseBlockBuffer);
            block.setPositionInFile(position);
            UnrarHeadertype headerType = block.getHeaderType();
            if (headerType == null) {
                logger.warn("unknown block header!");
                throw new CorruptHeaderException();
            }
            switch (headerType) {
                case MarkHeader: {
                    this.markHead = new MarkHeader(block);
                    if (!this.markHead.isSignature()) {
                        if (this.markHead.getVersion() == RARVersion.V5) {
                            logger.warn("Support for rar version 5 is not yet implemented!");
                            throw new UnsupportedRarV5Exception();
                        }
                        throw new BadRarArchiveException();
                    }
                    if (!this.markHead.isValid()) {
                        throw new CorruptHeaderException("Invalid Mark Header");
                    }
                    this.headers.add(this.markHead);
                    continue block25;
                }
                case MainHeader: {
                    toRead = block.hasEncryptVersion() ? 7 : 6;
                    byte[] mainbuff = Archive.safelyAllocate(toRead, 0x1400000);
                    rawData.readFully(mainbuff, mainbuff.length);
                    MainHeader mainhead = new MainHeader(block, mainbuff);
                    this.headers.add(mainhead);
                    this.newMhd = mainhead;
                    continue block25;
                }
                case SignHeader: {
                    toRead = 8;
                    byte[] signBuff = Archive.safelyAllocate(toRead, 0x1400000);
                    rawData.readFully(signBuff, signBuff.length);
                    SignHeader signHead = new SignHeader(block, signBuff);
                    this.headers.add(signHead);
                    continue block25;
                }
                case AvHeader: {
                    toRead = 7;
                    byte[] avBuff = Archive.safelyAllocate(toRead, 0x1400000);
                    rawData.readFully(avBuff, avBuff.length);
                    AVHeader avHead = new AVHeader(block, avBuff);
                    this.headers.add(avHead);
                    continue block25;
                }
                case CommHeader: {
                    toRead = 6;
                    byte[] commBuff = Archive.safelyAllocate(toRead, 0x1400000);
                    rawData.readFully(commBuff, commBuff.length);
                    CommentHeader commHead = new CommentHeader(block, commBuff);
                    this.headers.add(commHead);
                    newpos = commHead.getPositionInFile() + (long)commHead.getHeaderSize(this.isEncrypted());
                    this.channel.setPosition(newpos);
                    if (processedPositions.contains(newpos)) {
                        throw new BadRarArchiveException();
                    }
                    processedPositions.add(newpos);
                    continue block25;
                }
                case EndArcHeader: {
                    EndArcHeader endArcHead;
                    toRead = 0;
                    if (block.hasArchiveDataCRC()) {
                        toRead += 4;
                    }
                    if (block.hasVolumeNumber()) {
                        toRead += 2;
                    }
                    if (toRead > 0) {
                        byte[] endArchBuff = Archive.safelyAllocate(toRead, 0x1400000);
                        rawData.readFully(endArchBuff, endArchBuff.length);
                        endArcHead = new EndArcHeader(block, endArchBuff);
                    } else {
                        endArcHead = new EndArcHeader(block, null);
                    }
                    if (!this.newMhd.isMultiVolume() && !endArcHead.isValid()) {
                        throw new CorruptHeaderException("Invalid End Archive Header");
                    }
                    this.headers.add(endArcHead);
                    return;
                }
            }
            byte[] blockHeaderBuffer = Archive.safelyAllocate(4L, 0x1400000);
            rawData.readFully(blockHeaderBuffer, blockHeaderBuffer.length);
            BlockHeader blockHead = new BlockHeader(block, blockHeaderBuffer);
            block10 : switch (blockHead.getHeaderType()) {
                case NewSubHeader: 
                case FileHeader: {
                    toRead = blockHead.getHeaderSize(false) - 7 - 4;
                    byte[] fileHeaderBuffer = Archive.safelyAllocate(toRead, 0x1400000);
                    try {
                        rawData.readFully(fileHeaderBuffer, fileHeaderBuffer.length);
                    }
                    catch (EOFException e) {
                        throw new CorruptHeaderException("Unexpected end of file");
                    }
                    FileHeader fh = new FileHeader(blockHead, fileHeaderBuffer);
                    this.headers.add(fh);
                    newpos = fh.getPositionInFile() + (long)fh.getHeaderSize(this.isEncrypted()) + fh.getFullPackSize();
                    this.channel.setPosition(newpos);
                    if (processedPositions.contains(newpos)) {
                        throw new BadRarArchiveException();
                    }
                    processedPositions.add(newpos);
                    break;
                }
                case ProtectHeader: {
                    toRead = blockHead.getHeaderSize(false) - 7 - 4;
                    byte[] protectHeaderBuffer = Archive.safelyAllocate(toRead, 0x1400000);
                    rawData.readFully(protectHeaderBuffer, protectHeaderBuffer.length);
                    ProtectHeader ph = new ProtectHeader(blockHead, protectHeaderBuffer);
                    newpos = ph.getPositionInFile() + (long)ph.getHeaderSize(this.isEncrypted()) + ph.getDataSize();
                    this.channel.setPosition(newpos);
                    if (processedPositions.contains(newpos)) {
                        throw new BadRarArchiveException();
                    }
                    processedPositions.add(newpos);
                    break;
                }
                case SubHeader: {
                    byte[] subHeadbuffer = Archive.safelyAllocate(3L, 0x1400000);
                    rawData.readFully(subHeadbuffer, subHeadbuffer.length);
                    SubBlockHeader subHead = new SubBlockHeader(blockHead, subHeadbuffer);
                    subHead.print();
                    SubBlockHeaderType subType = subHead.getSubType();
                    if (subType == null) continue block25;
                    switch (subType) {
                        case MAC_HEAD: {
                            byte[] macHeaderbuffer = Archive.safelyAllocate(8L, 0x1400000);
                            rawData.readFully(macHeaderbuffer, macHeaderbuffer.length);
                            MacInfoHeader macHeader = new MacInfoHeader(subHead, macHeaderbuffer);
                            macHeader.print();
                            this.headers.add(macHeader);
                            break block10;
                        }
                        case BEEA_HEAD: {
                            break block10;
                        }
                        case EA_HEAD: {
                            byte[] eaHeaderBuffer = Archive.safelyAllocate(10L, 0x1400000);
                            rawData.readFully(eaHeaderBuffer, eaHeaderBuffer.length);
                            EAHeader eaHeader = new EAHeader(subHead, eaHeaderBuffer);
                            eaHeader.print();
                            this.headers.add(eaHeader);
                            break block10;
                        }
                        case NTACL_HEAD: {
                            break block10;
                        }
                        case STREAM_HEAD: {
                            break block10;
                        }
                        case UO_HEAD: {
                            toRead = subHead.getHeaderSize(false);
                            toRead -= 7;
                            toRead -= 4;
                            byte[] uoHeaderBuffer = Archive.safelyAllocate(toRead -= 3, 0x1400000);
                            rawData.readFully(uoHeaderBuffer, uoHeaderBuffer.length);
                            UnixOwnersHeader uoHeader = new UnixOwnersHeader(subHead, uoHeaderBuffer);
                            uoHeader.print();
                            this.headers.add(uoHeader);
                            break block10;
                        }
                    }
                    break;
                }
                default: {
                    logger.warn("Unknown Header");
                    throw new NotRarArchiveException();
                }
            }
        }
    }

    private static byte[] safelyAllocate(long len, int maxSize) throws RarException {
        if (maxSize < 0) {
            throw new IllegalArgumentException("maxsize must be >= 0");
        }
        if (len < 0L || len > (long)maxSize) {
            throw new BadRarArchiveException();
        }
        return new byte[(int)len];
    }

    public void extractFile(FileHeader hd, OutputStream os) throws RarException {
        if (!this.headers.contains(hd)) {
            throw new HeaderNotInArchiveException();
        }
        try {
            this.doExtractFile(hd, os);
        }
        catch (Exception e) {
            if (e instanceof RarException) {
                throw (RarException)e;
            }
            throw new RarException(e);
        }
    }

    private static <T> T getPropertyAs(String key, Function<String, T> function, T defaultValue) {
        Objects.requireNonNull(defaultValue, "default value must not be null");
        try {
            String integerString = System.getProperty(key);
            if (integerString != null && !integerString.isEmpty()) {
                return function.apply(integerString);
            }
        }
        catch (NumberFormatException | SecurityException e) {
            logger.error("Could not parse the System Property '{}' into an '{}'. Defaulting to '{}'", new Object[]{key, defaultValue.getClass().getTypeName(), defaultValue, e});
        }
        return defaultValue;
    }

    public InputStream getInputStream(FileHeader hd) throws IOException {
        if (hd.getFullUnpackSize() <= 0L) {
            return new EmptyInputStream();
        }
        int bufferSize = (int)Math.max(Math.min(hd.getFullUnpackSize(), (long)PIPE_BUFFER_SIZE), 1L);
        PipedInputStream in = new PipedInputStream(bufferSize);
        PipedOutputStream out = new PipedOutputStream(in);
        Runnable r = () -> {
            try {
                this.extractFile(hd, out);
            }
            catch (RarException rarException) {
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        };
        if (USE_EXECUTOR) {
            ExtractorExecutorHolder.cachedExecutorService.submit(r);
        } else {
            new Thread(r).start();
        }
        return in;
    }

    private void doExtractFile(FileHeader hd, OutputStream os) throws RarException, IOException {
        this.dataIO.init(os);
        this.dataIO.init(hd);
        this.dataIO.setUnpFileCRC(this.isOldFormat() ? 0L : -1L);
        if (this.unpack == null) {
            this.unpack = new Unpack(this.dataIO);
        }
        if (!hd.isSolid()) {
            this.unpack.init(null);
        }
        this.unpack.setDestSize(hd.getFullUnpackSize());
        try {
            this.unpack.doUnpack(hd.getUnpVersion(), hd.isSolid());
            hd = this.dataIO.getSubHeader();
            long actualCRC = hd.isSplitAfter() ? this.dataIO.getPackedCRC() ^ 0xFFFFFFFFFFFFFFFFL : this.dataIO.getUnpFileCRC() ^ 0xFFFFFFFFFFFFFFFFL;
            int expectedCRC = hd.getFileCRC();
            if (actualCRC != (long)expectedCRC) {
                throw new CrcErrorException();
            }
        }
        catch (Exception e) {
            this.unpack.cleanUp();
            if (e instanceof RarException) {
                throw (RarException)e;
            }
            throw new RarException(e);
        }
    }

    public MainHeader getMainHeader() {
        return this.newMhd;
    }

    public boolean isOldFormat() {
        return this.markHead.isOldFormat();
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        if (this.unpack != null) {
            this.unpack.cleanUp();
        }
    }

    public VolumeManager getVolumeManager() {
        return this.volumeManager;
    }

    public void setVolumeManager(VolumeManager volumeManager) {
        this.volumeManager = volumeManager;
    }

    public Volume getVolume() {
        return this.volume;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setVolume(Volume volume) throws IOException, RarException {
        this.volume = volume;
        this.setChannel(volume.getChannel(), volume.getLength());
    }

    @Override
    public Iterator<FileHeader> iterator() {
        return new Iterator<FileHeader>(){

            @Override
            public FileHeader next() {
                FileHeader next = Archive.this.nextFileHeader != null ? Archive.this.nextFileHeader : Archive.this.nextFileHeader();
                return next;
            }

            @Override
            public boolean hasNext() {
                Archive.this.nextFileHeader = Archive.this.nextFileHeader();
                return Archive.this.nextFileHeader != null;
            }
        };
    }

    private static final class EmptyInputStream
    extends InputStream {
        private EmptyInputStream() {
        }

        @Override
        public int available() {
            return 0;
        }

        @Override
        public int read() {
            return -1;
        }
    }

    private static final class ExtractorExecutorHolder {
        private static final AtomicLong threadIndex = new AtomicLong();
        private static final ExecutorService cachedExecutorService = new ThreadPoolExecutor(0, ExtractorExecutorHolder.getMaxThreads(), (long)ExtractorExecutorHolder.getThreadKeepAlive(), TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), r -> {
            Thread t = new Thread(r, "junrar-extractor-" + threadIndex.getAndIncrement());
            t.setDaemon(true);
            return t;
        });

        private ExtractorExecutorHolder() {
        }

        private static int getMaxThreads() {
            return (Integer)Archive.getPropertyAs("junrar.extractor.max-threads", Integer::parseInt, Integer.MAX_VALUE);
        }

        private static int getThreadKeepAlive() {
            return (Integer)Archive.getPropertyAs("junrar.extractor.thread-keep-alive-seconds", Integer::parseInt, 5);
        }
    }
}

