/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.streampane;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.apache.pdfbox.debugger.ui.HighResolutionImageIcon;
import org.apache.pdfbox.debugger.ui.ImageUtil;
import org.apache.pdfbox.debugger.ui.RotationMenu;
import org.apache.pdfbox.debugger.ui.ZoomMenu;

class StreamImageView
implements ActionListener,
AncestorListener {
    private final BufferedImage image;
    private JScrollPane scrollPane;
    private JLabel label;
    private ZoomMenu zoomMenu;
    private RotationMenu rotationMenu;

    StreamImageView(BufferedImage image) {
        this.image = image;
        this.initUI();
    }

    private void initUI() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this.zoomMenu = ZoomMenu.getInstance();
        this.zoomMenu.changeZoomSelection(this.zoomMenu.getImageZoomScale());
        this.label = new JLabel();
        this.label.setBorder(new LineBorder(Color.BLACK));
        this.label.setAlignmentX(0.5f);
        this.addImage(this.zoomImage(this.image, this.zoomMenu.getImageZoomScale(), RotationMenu.getRotationDegrees()));
        panel.add(Box.createVerticalGlue());
        panel.add(this.label);
        panel.add(Box.createVerticalGlue());
        this.scrollPane = new JScrollPane();
        this.scrollPane.setPreferredSize(new Dimension(300, 400));
        this.scrollPane.addAncestorListener(this);
        this.scrollPane.setViewportView(panel);
    }

    JComponent getView() {
        return this.scrollPane;
    }

    private Image zoomImage(BufferedImage origin, float scale, int rotation) {
        BufferedImage rotatedImage = ImageUtil.getRotatedImage(origin, rotation);
        int resizedWidth = (int)Math.ceil((float)rotatedImage.getWidth() * scale);
        int resizedHeight = (int)Math.ceil((float)rotatedImage.getHeight() * scale);
        return rotatedImage.getScaledInstance(resizedWidth, resizedHeight, 4);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if (ZoomMenu.isZoomMenu(actionCommand) || RotationMenu.isRotationMenu(actionCommand)) {
            this.addImage(this.zoomImage(this.image, ZoomMenu.getZoomScale(), RotationMenu.getRotationDegrees()));
            this.zoomMenu.setImageZoomScale(ZoomMenu.getZoomScale());
        }
    }

    private void addImage(Image img) {
        AffineTransform tx = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform();
        this.label.setSize((int)Math.ceil((double)img.getWidth(null) / tx.getScaleX()), (int)Math.ceil((double)img.getHeight(null) / tx.getScaleY()));
        this.label.setIcon(new HighResolutionImageIcon(img, this.label.getWidth(), this.label.getHeight()));
        this.label.revalidate();
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.zoomMenu.addMenuListeners(this);
        this.zoomMenu.setEnableMenu(true);
        this.rotationMenu = RotationMenu.getInstance();
        this.rotationMenu.addMenuListeners(this);
        this.rotationMenu.setRotationSelection("0\u00b0");
        this.rotationMenu.setEnableMenu(true);
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        this.zoomMenu.setEnableMenu(false);
        this.rotationMenu.setEnableMenu(false);
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }
}

