/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.util.ldiff;

import com.sleepycat.je.rep.util.ldiff.Block;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class BlockBag
implements Iterable<Block> {
    private final HashMap<Long, List<Integer>> chksums;
    private final List<Block> blocks = new ArrayList<Block>();
    private int blockIndex = 0;

    public BlockBag() {
        this.chksums = new HashMap();
    }

    public void add(Block b) {
        Long chksum = b.getRollingChksum();
        Integer indx = this.blocks.size();
        this.blocks.add(b);
        List<Integer> indices = this.chksums.get(chksum);
        if (indices == null) {
            indices = new ArrayList<Integer>();
        }
        indices.add(indx);
        this.chksums.put(chksum, indices);
    }

    public List<Block> get(long chksum) {
        ArrayList<Block> ret = new ArrayList<Block>();
        List<Integer> indices = this.chksums.get(new Long(chksum));
        if (indices == null) {
            return null;
        }
        for (Integer indx : indices) {
            int i = indx;
            if (i < this.blockIndex) continue;
            ret.add(this.blocks.get(i));
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret;
    }

    @Override
    public Iterator<Block> iterator() {
        return new BagIterator();
    }

    public List<Block> remove(Block b) {
        int startIndex = this.blockIndex;
        while (this.blockIndex < this.blocks.size()) {
            Block b2 = this.blocks.get(this.blockIndex);
            ++this.blockIndex;
            if (b != b2) continue;
            break;
        }
        return this.blockIndex - startIndex <= 1 ? null : this.blocks.subList(startIndex, this.blockIndex - 1);
    }

    public List<Block> removeAll() {
        ArrayList<Block> ret = new ArrayList<Block>();
        while (this.blockIndex < this.blocks.size()) {
            Block b = this.blocks.get(this.blockIndex);
            ++this.blockIndex;
            ret.add(b);
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret;
    }

    public int getBlockIndex() {
        return this.blockIndex;
    }

    public Block getBlock() {
        return this.blocks.get(this.blockIndex);
    }

    public int size() {
        return this.blocks.size() - this.blockIndex;
    }

    private class BagIterator
    implements Iterator<Block> {
        private int offset = 0;

        BagIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.offset + BlockBag.this.blockIndex < BlockBag.this.blocks.size();
        }

        @Override
        public void remove() {
            BlockBag.this.remove((Block)BlockBag.this.blocks.get(BlockBag.this.blockIndex));
        }

        @Override
        public Block next() {
            return (Block)BlockBag.this.blocks.get(BlockBag.this.blockIndex + this.offset++);
        }
    }
}

