/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.thrift.internal.senders;

import io.jaegertracing.internal.JaegerSpan;
import io.jaegertracing.internal.exceptions.SenderException;
import io.jaegertracing.spi.Sender;
import io.jaegertracing.thrift.internal.reporters.protocols.JaegerThriftSpanConverter;
import io.jaegertracing.thrift.internal.senders.ThriftSenderBase;
import io.jaegertracing.thriftjava.Process;
import io.jaegertracing.thriftjava.Span;
import java.util.ArrayList;
import java.util.List;
import org.apache.thrift.transport.TTransportException;

public abstract class ThriftSender
extends ThriftSenderBase
implements Sender {
    private Process process;
    private int processBytesSize;
    private int spanBytesSize;
    private List<Span> spanBuffer = new ArrayList<Span>();

    public ThriftSender(ThriftSenderBase.ProtocolType protocolType, int maxPacketSize) throws TTransportException {
        super(protocolType, maxPacketSize);
    }

    public int append(JaegerSpan span) throws SenderException {
        int n;
        Span thriftSpan;
        int spanSize;
        if (this.process == null) {
            this.process = new Process(span.getTracer().getServiceName());
            this.process.setTags(JaegerThriftSpanConverter.buildTags(span.getTracer().tags()));
            this.processBytesSize = this.calculateProcessSize(this.process);
        }
        if ((spanSize = this.calculateSpanSize(thriftSpan = JaegerThriftSpanConverter.convertSpan(span))) > this.getMaxSpanBytes()) {
            throw new SenderException(String.format("ThriftSender received a span that was too large, size = %d, max = %d", spanSize, this.getMaxSpanBytes()), null, 1);
        }
        this.spanBytesSize += spanSize;
        if (this.spanBytesSize <= this.getMaxSpanBytes()) {
            this.spanBuffer.add(thriftSpan);
            if (this.spanBytesSize < this.getMaxSpanBytes()) {
                return 0;
            }
            return this.flush();
        }
        try {
            n = this.flush();
        }
        catch (SenderException e) {
            throw new SenderException(e.getMessage(), e.getCause(), e.getDroppedSpanCount() + 1);
        }
        this.spanBuffer.add(thriftSpan);
        this.spanBytesSize = spanSize;
        return n;
    }

    protected int calculateProcessSize(Process proc) throws SenderException {
        try {
            return this.getSize(proc);
        }
        catch (Exception e) {
            throw new SenderException("ThriftSender failed writing Process to memory buffer.", (Throwable)e, 1);
        }
    }

    protected int calculateSpanSize(Span span) throws SenderException {
        try {
            return this.getSize(span);
        }
        catch (Exception e) {
            throw new SenderException("ThriftSender failed writing Span to memory buffer.", (Throwable)e, 1);
        }
    }

    protected int getMaxSpanBytes() {
        return this.getMaxBatchBytes() - this.processBytesSize;
    }

    public abstract void send(Process var1, List<Span> var2) throws SenderException;

    public int flush() throws SenderException {
        if (this.spanBuffer.isEmpty()) {
            return 0;
        }
        int n = this.spanBuffer.size();
        try {
            this.send(this.process, this.spanBuffer);
        }
        catch (SenderException e) {
            throw new SenderException("Failed to flush spans.", (Throwable)e, n);
        }
        finally {
            this.spanBuffer.clear();
            this.spanBytesSize = 0;
        }
        return n;
    }

    public int close() throws SenderException {
        return this.flush();
    }

    @Override
    public String toString() {
        return "ThriftSender(process=" + this.process + ", processBytesSize=" + this.processBytesSize + ", spanBytesSize=" + this.spanBytesSize + ")";
    }
}

