/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client;

import java.util.Set;
import java.util.TreeSet;
import org.apache.rocketmq.client.consumer.DefaultMQPullConsumer;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.heartbeat.MessageModel;

public class MQHelper {
    private static final Logger log = LoggerFactory.getLogger(MQHelper.class);

    @Deprecated
    public static void resetOffsetByTimestamp(MessageModel messageModel, String consumerGroup, String topic, long timestamp) throws Exception {
        MQHelper.resetOffsetByTimestamp(messageModel, "DEFAULT", consumerGroup, topic, timestamp);
    }

    public static void resetOffsetByTimestamp(MessageModel messageModel, String instanceName, String consumerGroup, String topic, long timestamp) throws Exception {
        DefaultMQPullConsumer consumer = new DefaultMQPullConsumer(consumerGroup);
        consumer.setInstanceName(instanceName);
        consumer.setMessageModel(messageModel);
        consumer.start();
        Set<MessageQueue> mqs = null;
        try {
            mqs = consumer.fetchSubscribeMessageQueues(topic);
            if (mqs != null && !mqs.isEmpty()) {
                TreeSet<MessageQueue> mqsNew = new TreeSet<MessageQueue>(mqs);
                for (MessageQueue mq : mqsNew) {
                    long offset = consumer.searchOffset(mq, timestamp);
                    if (offset < 0L) continue;
                    consumer.updateConsumeOffset(mq, offset);
                    log.info("resetOffsetByTimestamp updateConsumeOffset success, {} {} {}", new Object[]{consumerGroup, offset, mq});
                }
            }
        }
        catch (Exception e) {
            log.warn("resetOffsetByTimestamp Exception", (Throwable)e);
            throw e;
        }
        finally {
            if (mqs != null) {
                consumer.getDefaultMQPullConsumerImpl().getOffsetStore().persistAll(mqs);
            }
            consumer.shutdown();
        }
    }
}

