/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.client.ws;

import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.WebSocketClientOptions;
import io.vertx.core.net.ClientOptionsBase;
import org.apache.servicecomb.foundation.vertx.VertxTLSBuilder;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClientOptionsSPI;

public abstract class WebSocketClientOptionsSPI
implements HttpClientOptionsSPI {
    public static WebSocketClientOptions createWebSocketClientOptions(WebSocketClientOptionsSPI spi) {
        WebSocketClientOptions webSocketClientOptions = new WebSocketClientOptions();
        HttpClientOptionsSPI.buildClientOptionsBase(spi, (ClientOptionsBase)webSocketClientOptions);
        webSocketClientOptions.setMaxFrameSize(spi.getMaxFrameSize());
        webSocketClientOptions.setMaxMessageSize(spi.getMaxMessageSize());
        webSocketClientOptions.setMaxConnections(spi.getMaxConnections());
        webSocketClientOptions.setTryUsePerFrameCompression(spi.getTryUsePerFrameCompression());
        webSocketClientOptions.setTryUsePerMessageCompression(spi.getTryUsePerMessageCompression());
        webSocketClientOptions.setCompressionLevel(spi.getCompressionLevel());
        webSocketClientOptions.setClosingTimeout(spi.getClosingTimeoutInSeconds());
        webSocketClientOptions.setUseAlpn(spi.isUseAlpn());
        if (spi.isSsl()) {
            VertxTLSBuilder.buildWebSocketClientOptions(spi.getConfigTag(), webSocketClientOptions);
        }
        return webSocketClientOptions;
    }

    public abstract int getMaxFrameSize();

    public abstract int getMaxMessageSize();

    public abstract int getMaxConnections();

    public abstract boolean getTryUsePerFrameCompression();

    public abstract boolean getTryUsePerMessageCompression();

    public abstract int getCompressionLevel();

    public abstract int getClosingTimeoutInSeconds();

    @Override
    public final HttpVersion getHttpVersion() {
        return HttpVersion.HTTP_1_1;
    }

    @Override
    public final boolean isTryUseCompression() {
        throw WebSocketClientOptionsSPI.unsupportedException();
    }

    @Override
    public final int getMaxWaitQueueSize() {
        throw WebSocketClientOptionsSPI.unsupportedException();
    }

    @Override
    public final int getMaxPoolSize() {
        throw WebSocketClientOptionsSPI.unsupportedException();
    }

    @Override
    public final boolean isKeepAlive() {
        throw WebSocketClientOptionsSPI.unsupportedException();
    }

    @Override
    public final int getMaxHeaderSize() {
        throw WebSocketClientOptionsSPI.unsupportedException();
    }

    @Override
    public final int getHttp2MultiplexingLimit() {
        throw WebSocketClientOptionsSPI.unsupportedException();
    }

    @Override
    public final int getHttp2MaxPoolSize() {
        throw WebSocketClientOptionsSPI.unsupportedException();
    }

    @Override
    public final int getKeepAliveTimeout() {
        throw WebSocketClientOptionsSPI.unsupportedException();
    }

    protected static UnsupportedOperationException unsupportedException() {
        return new UnsupportedOperationException("WebSocket Not Support this option.");
    }
}

