/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff.base;

import java.lang.reflect.Field;

public final class GeoKeys {
    public static final short ModelType = 1024;
    public static final short RasterType = 1025;
    public static final short Citation = 1026;
    public static final short GeodeticCRS = 2048;
    public static final short GeodeticCitation = 2049;
    public static final short GeodeticDatum = 2050;
    public static final short PrimeMeridian = 2051;
    public static final short GeogLinearUnits = 2052;
    public static final short GeogLinearUnitSize = 2053;
    public static final short GeogAngularUnits = 2054;
    public static final short GeogAngularUnitSize = 2055;
    public static final short Ellipsoid = 2056;
    public static final short SemiMajorAxis = 2057;
    public static final short SemiMinorAxis = 2058;
    public static final short InvFlattening = 2059;
    public static final short GeogAzimuthUnits = 2060;
    public static final short PrimeMeridianLongitude = 2061;
    public static final short ProjectedCRS = 3072;
    public static final short ProjectedCitation = 3073;
    public static final short Projection = 3074;
    public static final short ProjMethod = 3075;
    public static final short ProjLinearUnits = 3076;
    public static final short ProjLinearUnitSize = 3077;
    public static final short StdParallel1 = 3078;
    public static final short StdParallel2 = 3079;
    public static final short NatOriginLong = 3080;
    public static final short NatOriginLat = 3081;
    public static final short FalseEasting = 3082;
    public static final short FalseNorthing = 3083;
    public static final short FalseOriginLong = 3084;
    public static final short FalseOriginLat = 3085;
    public static final short FalseOriginEasting = 3086;
    public static final short FalseOriginNorthing = 3087;
    public static final short CenterLong = 3088;
    public static final short CenterLat = 3089;
    public static final short CenterEasting = 3090;
    public static final short CenterNorthing = 3091;
    public static final short ScaleAtNatOrigin = 3092;
    public static final short ScaleAtCenter = 3093;
    public static final short AzimuthAngle = 3094;
    public static final short StraightVertPoleLong = 3095;
    public static final short RectifiedGridAngle = 3096;
    static final short LAST_MAP_PROJECTION_PARAMETER = 3096;
    public static final short Vertical = 4096;
    public static final short VerticalCitation = 4097;
    public static final short VerticalDatum = 4098;
    public static final short VerticalUnits = 4099;

    private GeoKeys() {
    }

    public static String name(short key) {
        try {
            for (Field field : GeoKeys.class.getFields()) {
                if (field.getType() != Short.TYPE || field.getShort(null) != key) continue;
                return field.getName();
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        return Integer.toHexString(Short.toUnsignedInt(key));
    }
}

