/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.time.temporal.Temporal;
import java.util.Date;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.temporal.TemporalDate;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.DateType;

@TitleProperty(name="referenceDate")
@XmlType(name="CI_Date_Type", propOrder={"referenceDate", "dateType"})
@XmlRootElement(name="CI_Date")
public class DefaultCitationDate
extends ISOMetadata
implements CitationDate {
    private static final long serialVersionUID = 1032356967666782327L;
    private Temporal date;
    private DateType dateType;

    public DefaultCitationDate() {
    }

    public DefaultCitationDate(Temporal date, DateType dateType) {
        this.date = date;
        this.dateType = dateType;
    }

    @Deprecated(since="1.5", forRemoval=true)
    public DefaultCitationDate(Date date, DateType dateType) {
        this.date = TemporalDate.toTemporal(date);
        this.dateType = dateType;
    }

    public DefaultCitationDate(CitationDate object) {
        super(object);
        if (object != null) {
            this.dateType = object.getDateType();
            this.date = object instanceof DefaultCitationDate ? ((DefaultCitationDate)object).getReferenceDate() : TemporalDate.toTemporal(object.getDate());
        }
    }

    public static DefaultCitationDate castOrCopy(CitationDate object) {
        if (object == null || object instanceof DefaultCitationDate) {
            return (DefaultCitationDate)object;
        }
        return new DefaultCitationDate(object);
    }

    @Deprecated(since="1.5")
    public Date getDate() {
        return TemporalDate.toDate(this.getReferenceDate());
    }

    @Deprecated(since="1.5")
    public void setDate(Date newValue) {
        this.setReferenceDate(TemporalDate.toTemporal(newValue));
    }

    @XmlElement(name="date", required=true)
    @UML(identifier="date", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Temporal getReferenceDate() {
        return this.date;
    }

    public void setReferenceDate(Temporal newValue) {
        this.checkWritePermission(this.date);
        this.date = newValue;
    }

    @XmlElement(name="dateType", required=true)
    public DateType getDateType() {
        return this.dateType;
    }

    public void setDateType(DateType newValue) {
        this.checkWritePermission(this.dateType);
        this.dateType = newValue;
    }
}

