/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.adapter.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.sling.adapter.Adaption;
import org.apache.sling.adapter.internal.AdapterFactoryDescriptor;
import org.apache.sling.adapter.internal.AdapterFactoryDescriptorMap;
import org.apache.sling.adapter.internal.AdaptionImpl;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.adapter.SlingAdaptable;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.converter.Converter;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AdapterManager.class}, immediate=true, property={"service.description=Sling Adapter Manager", "service.vendor=The Apache Software Foundation"})
public class AdapterManagerImpl
implements AdapterManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    static final String ALLOWED_IN_PRIVATE = "adapter.allowed.in.private.package";
    private final Map<String, AdapterFactoryDescriptorMap> descriptors = new HashMap<String, AdapterFactoryDescriptorMap>();
    private final ConcurrentMap<String, Map<String, List<AdapterFactoryDescriptor>>> factoryCache = new ConcurrentHashMap<String, Map<String, List<AdapterFactoryDescriptor>>>();
    private final PackageAdmin packageAdmin;

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        Map<String, List<AdapterFactoryDescriptor>> factories = this.getAdapterFactories(adaptable.getClass());
        List<AdapterFactoryDescriptor> descList = factories.get(type.getName());
        if (descList != null && descList.size() > 0) {
            for (AdapterFactoryDescriptor desc : descList) {
                AdapterFactory factory = desc.getFactory();
                if (factory == null) continue;
                this.log.debug("Trying adapter factory {} to map {} to {}", new Object[]{factory, adaptable, type});
                Object adaptedObject = factory.getAdapter(adaptable, type);
                if (adaptedObject == null) continue;
                this.log.debug("Using adapter factory {} to map {} to {}", new Object[]{factory, adaptable, type});
                return (AdapterType)adaptedObject;
            }
        }
        this.log.debug("No adapter factory found to map {} to {}", adaptable, type);
        return null;
    }

    @Activate
    public AdapterManagerImpl(@Reference PackageAdmin pckAdmin) {
        this.packageAdmin = pckAdmin;
        SlingAdaptable.setAdapterManager((AdapterManager)this);
    }

    @Deactivate
    protected void deactivate() {
        SlingAdaptable.unsetAdapterManager((AdapterManager)this);
    }

    @Reference(service=AdapterFactory.class, updated="updatedAdapterFactory", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindAdapterFactory(AdapterFactory factory, ServiceReference<AdapterFactory> reference) {
        this.registerAdapterFactory(factory, reference);
    }

    protected void unbindAdapterFactory(ServiceReference<AdapterFactory> reference) {
        this.unregisterAdapterFactory(reference);
    }

    protected void updatedAdapterFactory(AdapterFactory factory, ServiceReference<AdapterFactory> reference) {
        this.unregisterAdapterFactory(reference);
        this.registerAdapterFactory(factory, reference);
    }

    Map<String, AdapterFactoryDescriptorMap> getFactories() {
        return this.descriptors;
    }

    Map<String, Map<String, List<AdapterFactoryDescriptor>>> getFactoryCache() {
        return this.factoryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void registerAdapterFactory(AdapterFactory factory, ServiceReference<AdapterFactory> reference) {
        void var10_15;
        Converter converter = Converters.standardConverter();
        Object[] adaptables = (String[])converter.convert(reference.getProperty("adaptables")).to(String[].class);
        Object[] adapters = (String[])converter.convert(reference.getProperty("adapters")).to(String[].class);
        boolean allowedInPrivatePackage = (Boolean)((Converting)converter.convert(reference.getProperty(ALLOWED_IN_PRIVATE)).defaultValue((Object)false)).to(Boolean.class);
        if (adaptables == null || adaptables.length == 0 || adapters == null || adapters.length == 0) {
            return;
        }
        for (String string : adaptables) {
            if (allowedInPrivatePackage || AdapterManagerImpl.checkPackage(this.packageAdmin, string)) continue;
            this.log.warn("Adaptable class {} in factory service {} is not in an exported package.", (Object)string, reference.getProperty("service.id"));
        }
        for (String string : adapters) {
            if (allowedInPrivatePackage || AdapterManagerImpl.checkPackage(this.packageAdmin, string)) continue;
            this.log.warn("Adapter class {} in factory service {} is not in an exported package.", (Object)string, reference.getProperty("service.id"));
        }
        AdapterFactoryDescriptor factoryDesc = new AdapterFactoryDescriptor(factory, (String[])adapters, (String[])adaptables);
        Object[] objectArray = adaptables;
        int n = objectArray.length;
        boolean bl = false;
        while (var10_15 < n) {
            String string = objectArray[var10_15];
            AdapterFactoryDescriptorMap adfMap = null;
            AdapterFactoryDescriptorMap adapterFactoryDescriptorMap = this.descriptors;
            synchronized (adapterFactoryDescriptorMap) {
                adfMap = this.descriptors.computeIfAbsent(string, key -> new AdapterFactoryDescriptorMap());
            }
            adapterFactoryDescriptorMap = adfMap;
            synchronized (adapterFactoryDescriptorMap) {
                adfMap.put(reference, factoryDesc);
            }
            ++var10_15;
        }
        this.factoryCache.clear();
        Hashtable<String, Object[]> props = new Hashtable<String, Object[]>();
        ((Dictionary)props).put("adaptables", adaptables);
        ((Dictionary)props).put("adapters", adapters);
        factoryDesc.setAdaption((ServiceRegistration<Adaption>)reference.getBundle().getBundleContext().registerService(Adaption.class, (Object)AdaptionImpl.INSTANCE, props));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Registered service {} with {} : {} and {} : {}", new Object[]{Adaption.class.getName(), "adaptables", Arrays.toString(adaptables), "adapters", Arrays.toString(adapters)});
        }
    }

    static String getPackageName(String clazz) {
        int lastDot = clazz.lastIndexOf(46);
        return lastDot <= 0 ? "" : clazz.substring(0, lastDot);
    }

    static boolean checkPackage(PackageAdmin packageAdmin, String clazz) {
        String packageName = AdapterManagerImpl.getPackageName(clazz);
        if (packageName.startsWith("java.")) {
            return true;
        }
        return packageAdmin.getExportedPackage(packageName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAdapterFactory(ServiceReference<AdapterFactory> reference) {
        ArrayList<AdapterFactoryDescriptorMap> list = new ArrayList<AdapterFactoryDescriptorMap>();
        Map<String, AdapterFactoryDescriptorMap> map = this.descriptors;
        synchronized (map) {
            for (AdapterFactoryDescriptorMap map2 : this.descriptors.values()) {
                list.add(map2);
            }
        }
        AdapterFactoryDescriptor removedDescriptor = null;
        Iterator<AdapterFactoryDescriptorMap> iterator = list.iterator();
        while (iterator.hasNext()) {
            AdapterFactoryDescriptorMap map2;
            AdapterFactoryDescriptorMap adapterFactoryDescriptorMap = map2 = iterator.next();
            synchronized (adapterFactoryDescriptorMap) {
                AdapterFactoryDescriptor factoryDesc = (AdapterFactoryDescriptor)map2.remove(reference);
                if (factoryDesc != null) {
                    removedDescriptor = factoryDesc;
                }
            }
        }
        if (removedDescriptor != null) {
            this.factoryCache.clear();
            ServiceRegistration<Adaption> reg = removedDescriptor.getAdaption();
            if (reg != null) {
                removedDescriptor.setAdaption(null);
                try {
                    reg.unregister();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unregistered service {} with {} : {} and {} : {}", new Object[]{Adaption.class.getName(), "adaptables", Arrays.toString(removedDescriptor.getAdaptables()), "adapters", Arrays.toString(removedDescriptor.getAdapters())});
            }
        }
    }

    private Map<String, List<AdapterFactoryDescriptor>> getAdapterFactories(Class<?> clazz) {
        String className = clazz.getName();
        Map<String, List<AdapterFactoryDescriptor>> entry = (Map<String, List<AdapterFactoryDescriptor>>)this.factoryCache.get(className);
        if (entry == null) {
            entry = this.createAdapterFactoryMap(clazz);
            this.factoryCache.put(className, entry);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Map<String, List<AdapterFactoryDescriptor>> createAdapterFactoryMap(Class<?> clazz) {
        Object object;
        HashMap<String, List<AdapterFactoryDescriptor>> afm = new HashMap<String, List<AdapterFactoryDescriptor>>();
        Class<?>[] afdMap = null;
        Map<String, AdapterFactoryDescriptorMap> map = this.descriptors;
        // MONITORENTER : map
        afdMap = this.descriptors.get(clazz.getName());
        // MONITOREXIT : map
        if (afdMap != null) {
            object = afdMap;
            // MONITORENTER : afdMap
            ArrayList afdSet = new ArrayList(afdMap.values());
            // MONITOREXIT : object
            for (AdapterFactoryDescriptor afd : afdSet) {
                String[] adapters;
                for (String adapter : adapters = afd.getAdapters()) {
                    ArrayList<AdapterFactoryDescriptor> factoryDescriptors = (ArrayList<AdapterFactoryDescriptor>)afm.get(adapter);
                    if (factoryDescriptors == null) {
                        factoryDescriptors = new ArrayList<AdapterFactoryDescriptor>();
                        afm.put(adapter, factoryDescriptors);
                    }
                    factoryDescriptors.add(afd);
                }
            }
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        object = interfaces;
        int n = ((Class<?>[])object).length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                Class<?> superClazz = clazz.getSuperclass();
                if (superClazz == null) return afm;
                this.copyAdapterFactories(afm, superClazz);
                return afm;
            }
            Class<?> iFace = object[n2];
            this.copyAdapterFactories(afm, iFace);
            ++n2;
        }
    }

    private void copyAdapterFactories(Map<String, List<AdapterFactoryDescriptor>> dest, Class<?> clazz) {
        Map<String, List<AdapterFactoryDescriptor>> scMap = this.getAdapterFactories(clazz);
        for (Map.Entry<String, List<AdapterFactoryDescriptor>> entry : scMap.entrySet()) {
            List factoryDescriptors = dest.computeIfAbsent(entry.getKey(), id -> new ArrayList());
            for (AdapterFactoryDescriptor descriptor : entry.getValue()) {
                factoryDescriptors.add(descriptor);
            }
        }
    }
}

