/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.content;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.ExtensionType;
import org.apache.sling.feature.io.IOUtils;
import org.apache.sling.feature.launcher.spi.LauncherPrepareContext;
import org.apache.sling.feature.launcher.spi.extensions.ExtensionContext;
import org.apache.sling.feature.launcher.spi.extensions.ExtensionHandler;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.fs.io.ImportOptions;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.PackageExistsException;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.PackageId;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.ExecutionPlanBuilder;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.PackageTask;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.impl.AbstractPackageRegistry;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.impl.FSPackageRegistry;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.impl.InstallationScope;
import relocated_for_contentpackage.org.apache.jackrabbit.vault.packaging.registry.taskoption.ImportOptionsPackageTaskOption;

public class ContentHandler
implements ExtensionHandler {
    private static final String SYS_PROP_USE_STRICT_MODE = ContentHandler.class.getPackageName() + ".useStrictMode";
    private static final String SYS_PROP_REINSTALL_SNAPSHOTS = ContentHandler.class.getPackageName() + ".reinstallSnapshots";
    public static final String PACKAGEREGISTRY_HOME = "packageregistry.home";
    private static final String REPOSITORY_HOME = "repository.home";
    private static final String REGISTRY_FOLDER = "packageregistry";

    private static ExecutionPlanBuilderWithDetails buildExecutionPlan(Collection<Artifact> artifacts, Set<PackageId> satisfiedPackages, LauncherPrepareContext prepareContext, File registryHome, boolean useStrictMode, boolean reinstallSnapshots) throws Exception {
        ArrayList<PackageReference> packageReferences = new ArrayList<PackageReference>();
        for (Artifact a : artifacts) {
            URL file = prepareContext.getArtifactFile(a.getId());
            File tmp = IOUtils.getFileFromURL((URL)file, (boolean)true, null);
            if (tmp == null || tmp.length() <= 0L) continue;
            packageReferences.add(new PackageReference(tmp, a));
        }
        if (!registryHome.exists()) {
            registryHome.mkdirs();
        }
        FSPackageRegistry registry = new FSPackageRegistry(registryHome, InstallationScope.UNSCOPED, new AbstractPackageRegistry.SecurityConfig(null, null), true);
        ExecutionPlanBuilder builder = registry.createExecutionPlan();
        builder.with(satisfiedPackages);
        boolean hasAnySnapshot = false;
        for (PackageReference pkgRef : packageReferences) {
            hasAnySnapshot |= pkgRef.isSnapshot;
            try {
                PackageId pid = registry.registerExternal(pkgRef.file, pkgRef.isSnapshot && reinstallSnapshots);
                ImportOptions importOptions = new ImportOptions();
                importOptions.setStrict(useStrictMode);
                ImportOptionsPackageTaskOption options = new ImportOptionsPackageTaskOption(importOptions);
                builder.addTask().with(pid).withOptions(options).with(PackageTask.Type.EXTRACT);
            }
            catch (PackageExistsException packageExistsException) {}
        }
        builder.validate();
        satisfiedPackages.addAll(builder.preview());
        return new ExecutionPlanBuilderWithDetails(builder, hasAnySnapshot);
    }

    public boolean handle(ExtensionContext context, Extension extension) throws Exception {
        File registryHome = this.getRegistryHomeDir(context);
        if (extension.getType() == ExtensionType.ARTIFACTS && extension.getName().equals("content-packages")) {
            boolean useStrictMode = Boolean.getBoolean(SYS_PROP_USE_STRICT_MODE);
            boolean reinstallSnapshots = Boolean.getBoolean(SYS_PROP_REINSTALL_SNAPSHOTS);
            TreeMap<Integer, Collection> orderedArtifacts = new TreeMap<Integer, Collection>();
            for (Artifact a : extension.getArtifacts()) {
                int order = a.getMetadata().get("start-order") != null ? a.getStartOrder() : Integer.MAX_VALUE;
                orderedArtifacts.computeIfAbsent(order, id -> new ArrayList()).add(a);
            }
            ArrayList<String> executionPlans = new ArrayList<String>();
            HashSet<PackageId> satisfiedPackages = new HashSet<PackageId>();
            boolean anyPlanIncludesSnapshots = false;
            for (Collection artifacts : orderedArtifacts.values()) {
                ExecutionPlanBuilderWithDetails builderWithDetails = ContentHandler.buildExecutionPlan(artifacts, satisfiedPackages, (LauncherPrepareContext)context, registryHome, useStrictMode, reinstallSnapshots);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                builderWithDetails.builder.save(baos);
                executionPlans.add(baos.toString(StandardCharsets.UTF_8));
                anyPlanIncludesSnapshots |= builderWithDetails.includesSnapshots;
            }
            if (anyPlanIncludesSnapshots) {
                if (reinstallSnapshots) {
                    context.getLogger().info("Found at least one SNAPSHOT package - configuring ExecutionPlanRepoInitializer to reprocess all plans that contain SNAPSHOT packages.");
                } else {
                    context.getLogger().info("Found at least one SNAPSHOT package but ExecutionPlanRepoInitializer is not configured by default to reinstall SNAPSHOTS. Set system property {} to true to enable.", (Object)SYS_PROP_REINSTALL_SNAPSHOTS);
                }
            }
            Configuration initcfg = new Configuration("org.apache.sling.jcr.packageinit.impl.ExecutionPlanRepoInitializer");
            initcfg.getProperties().put("executionplans", executionPlans.toArray(new String[executionPlans.size()]));
            initcfg.getProperties().put("statusfilepath", registryHome.getAbsolutePath() + File.separator + "executedplans.file");
            initcfg.getProperties().put("reinstallSnapshots", anyPlanIncludesSnapshots && reinstallSnapshots);
            context.addConfiguration(initcfg.getPid(), null, initcfg.getProperties());
            Configuration registrycfg = new Configuration("org.apache.jackrabbit.vault.packaging.registry.impl.FSPackageRegistry");
            registrycfg.getProperties().put("homePath", registryHome.getPath());
            context.addConfiguration(registrycfg.getPid(), null, registrycfg.getProperties());
            return true;
        }
        return false;
    }

    private File getRegistryHomeDir(ExtensionContext context) {
        File registryHome;
        String registryPath = System.getProperty(PACKAGEREGISTRY_HOME);
        if (registryPath != null) {
            registryHome = Paths.get(registryPath, new String[0]).toFile();
        } else {
            String repoHome = (String)context.getFrameworkProperties().get(REPOSITORY_HOME);
            if (repoHome == null) {
                throw new IllegalStateException("Neither registry.home set nor repository.home configured.");
            }
            registryHome = Paths.get(repoHome, REGISTRY_FOLDER).toFile();
        }
        if (!registryHome.exists()) {
            registryHome.mkdirs();
        }
        if (!registryHome.isDirectory()) {
            throw new IllegalStateException("Registry home points to file - must be directory: " + String.valueOf(registryHome));
        }
        return registryHome;
    }

    static class PackageReference {
        private File file;
        private boolean isSnapshot;

        public PackageReference(File file, Artifact artifact) {
            this.file = file;
            this.isSnapshot = artifact.getId().getVersion().endsWith("-SNAPSHOT");
        }
    }

    static class ExecutionPlanBuilderWithDetails {
        private ExecutionPlanBuilder builder;
        private boolean includesSnapshots;

        public ExecutionPlanBuilderWithDetails(ExecutionPlanBuilder builder, boolean includesSnapshots) {
            this.builder = builder;
            this.includesSnapshots = includesSnapshots;
        }
    }
}

