/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.ListObject;
import org.apache.sysds.runtime.util.ProgramConverter;

public class LocalVariableMap
implements Cloneable {
    private static final String eol = System.getProperty("line.separator");
    private static final String ELEMENT_DELIM = "\u236a";
    private static final IDSequence _seq = new IDSequence();
    private final ConcurrentHashMap<String, Data> localMap;
    private long localID;
    private HashSet<String> outputs = null;

    public LocalVariableMap() {
        this.localMap = new ConcurrentHashMap();
        this.localID = _seq.getNextID();
    }

    public LocalVariableMap(LocalVariableMap vars) {
        this.localMap = new ConcurrentHashMap<String, Data>(vars.localMap);
        this.localID = _seq.getNextID();
    }

    public void setID(long ID) {
        this.localID = ID;
    }

    public Set<String> keySet() {
        return this.localMap.keySet();
    }

    public Set<Map.Entry<String, Data>> entrySet() {
        return this.localMap.entrySet();
    }

    public Data get(String name) {
        return this.localMap.get(name);
    }

    public void put(String name, Data val) {
        this.localMap.put(name, val);
    }

    public void putAll(Map<String, Data> vals) {
        this.localMap.putAll(vals);
    }

    public void putAll(LocalVariableMap vars) {
        this.putAll(vars.localMap);
    }

    public Data remove(String name) {
        return this.localMap.remove(name);
    }

    public void removeAll() {
        this.localMap.clear();
    }

    public void removeAllIn(Set<String> excludeList) {
        this.localMap.entrySet().removeIf(e -> excludeList.contains(e.getKey()));
    }

    public void removeAllNotIn(Set<String> excludeList) {
        this.localMap.entrySet().removeIf(e -> !excludeList.contains(e.getKey()));
    }

    public boolean hasReferences(Data d) {
        for (Data o : this.localMap.values()) {
            if (!(o instanceof ListObject ? ((ListObject)o).contains(d) : o == d)) continue;
            return true;
        }
        return false;
    }

    public void setRegisteredOutputs(HashSet<String> outputs) {
        this.outputs = outputs;
    }

    public HashSet<String> getRegisteredOutputs() {
        return this.outputs;
    }

    public double getPinnedDataSize() {
        HashMap<Integer, Data> dict = new HashMap<Integer, Data>();
        double total = 0.0;
        for (Map.Entry<String, Data> e : this.localMap.entrySet()) {
            int hash = System.identityHashCode(e.getValue());
            if (dict.containsKey(hash) || !(e.getValue() instanceof CacheableData)) continue;
            dict.put(hash, e.getValue());
            double size = ((CacheableData)e.getValue()).getDataSize();
            total += size;
        }
        return total;
    }

    public void releaseAcquiredData() {
        this.localMap.values().stream().filter(d -> d instanceof CacheableData).map(d -> (CacheableData)d).filter(d -> d.getStatus() == CacheableData.CacheStatus.READ).forEach(d -> d.release());
    }

    public String serialize() {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (Map.Entry<String, Data> e : this.localMap.entrySet()) {
            if (count != 0) {
                sb.append(ELEMENT_DELIM);
            }
            sb.append(ProgramConverter.serializeDataObject(e.getKey(), e.getValue()));
            ++count;
        }
        return sb.toString();
    }

    public static LocalVariableMap deserialize(String varStr) {
        StringTokenizer st2 = new StringTokenizer(varStr, ELEMENT_DELIM);
        LocalVariableMap vars = new LocalVariableMap();
        while (st2.hasMoreTokens()) {
            String tmp = st2.nextToken().trim();
            Object[] tmp2 = ProgramConverter.parseDataObject(tmp);
            vars.put((String)tmp2[0], (Data)tmp2[1]);
        }
        return vars;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Local Variable Map ID = \"");
        sb.append(this.localID);
        sb.append("\":");
        sb.append(eol);
        for (Map.Entry<String, Data> pair : this.localMap.entrySet()) {
            sb.append("  ");
            sb.append(pair.getKey());
            sb.append(" = ");
            sb.append(pair.getValue().toString(true));
            sb.append(eol);
        }
        return sb.toString();
    }

    public Object clone() {
        return new LocalVariableMap(this);
    }
}

