/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.common.Opcodes;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.AggBinaryOp;
import org.apache.sysds.hops.AggUnaryOp;
import org.apache.sysds.hops.BinaryOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.IndexingOp;
import org.apache.sysds.hops.LiteralOp;
import org.apache.sysds.hops.ParameterizedBuiltinOp;
import org.apache.sysds.hops.ReorgOp;
import org.apache.sysds.hops.TernaryOp;
import org.apache.sysds.hops.UnaryOp;
import org.apache.sysds.hops.codegen.SpoofFusedOp;
import org.apache.sysds.lops.PartialAggregate;
import org.apache.sysds.lops.compile.Dag;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederatedUDF;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.InstructionParser;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.DataGenCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysds.runtime.instructions.fed.ReorgFEDInstruction;
import org.apache.sysds.runtime.instructions.spark.ComputationSPInstruction;
import org.apache.sysds.runtime.instructions.spark.RandSPInstruction;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageCodegenItem;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.utils.Statistics;

public class LineageItemUtils {
    public static final String LPLACEHOLDER = "IN#";
    public static final String FUNC_DELIM = "_";
    private static final boolean FUNCTION_DEBUGGING = false;
    public static final String SERIALIZATION_OPCODE = "serialize";

    public static LineageItem.LineageItemType getType(String str) {
        if (str.length() == 1) {
            switch (str) {
                case "C": {
                    return LineageItem.LineageItemType.Creation;
                }
                case "L": {
                    return LineageItem.LineageItemType.Literal;
                }
                case "I": {
                    return LineageItem.LineageItemType.Instruction;
                }
                case "D": {
                    return LineageItem.LineageItemType.Dedup;
                }
            }
            throw new DMLRuntimeException("Unknown LineageItemType given!");
        }
        throw new DMLRuntimeException("Unknown LineageItemType given!");
    }

    private static String getString(LineageItem.LineageItemType lit) {
        switch (lit) {
            case Creation: {
                return "C";
            }
            case Literal: {
                return "L";
            }
            case Instruction: {
                return "I";
            }
            case Dedup: {
                return "D";
            }
        }
        throw new DMLRuntimeException("Unknown LineageItemType given!");
    }

    private static String getString(LineageItem li) {
        return LineageItemUtils.getString(li.getType());
    }

    public static boolean isFunctionDebugging() {
        return false;
    }

    public static String explainLineageType(LineageItem li, Statistics.LineageNGramExtension ext) {
        if (li.getType() == LineageItem.LineageItemType.Literal) {
            String[] splt = li.getData().split("\u00b7");
            if (splt.length >= 3) {
                return splt[1] + "\u00b7" + splt[2];
            }
            return "\u00b7";
        }
        return ext != null ? ext.getDataType() + "\u00b7" + ext.getValueType() : "\u00b7\u00b7";
    }

    public static String explainLineageWithTypes(LineageItem li, Statistics.LineageNGramExtension ext) {
        if (li.getType() == LineageItem.LineageItemType.Literal) {
            String[] splt = li.getData().split("\u00b7");
            if (splt.length >= 3) {
                return "L\u00b7" + splt[1] + "\u00b7" + splt[2];
            }
            return "L\u00b7\u00b7";
        }
        return li.getOpcode() + "\u00b7" + (String)(ext != null ? ext.getDataType() + "\u00b7" + ext.getValueType() : "\u00b7");
    }

    public static String explainLineageAsInstruction(LineageItem li, Statistics.LineageNGramExtension ext) {
        StringBuilder sb = new StringBuilder(LineageItemUtils.explainLineageWithTypes(li, ext));
        sb.append("(");
        if (li.getInputs() != null) {
            int ctr = 0;
            for (LineageItem liIn : li.getInputs()) {
                if (ctr++ != 0) {
                    sb.append(" \u00b0 ");
                }
                if (liIn.getType() == LineageItem.LineageItemType.Literal) {
                    sb.append("L_" + LineageItemUtils.explainLineageType(liIn, Statistics.getExtendedLineage(li)));
                    continue;
                }
                sb.append(LineageItemUtils.explainLineageType(liIn, Statistics.getExtendedLineage(li)));
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public static String explainSingleLineageItem(LineageItem li) {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(li.getId()).append(") ");
        sb.append("(").append(LineageItemUtils.getString(li)).append(") ");
        if (li.isLeaf()) {
            if (li.getOpcode().startsWith(LPLACEHOLDER)) {
                sb.append(li.getOpcode()).append(" ");
            } else {
                sb.append(li.getData()).append(" ");
            }
        } else {
            if (li.getType() == LineageItem.LineageItemType.Dedup) {
                sb.append(li.getOpcode()).append(li.getData()).append(" ");
            } else {
                sb.append(li.getOpcode()).append(" ");
            }
            String ids = Arrays.stream(li.getInputs()).map(i -> String.format("(%d)", i.getId())).collect(Collectors.joining(" "));
            sb.append(ids);
            if (DMLScript.LINEAGE_DEBUGGER) {
                sb.append(" ").append("[").append(li.getSpecialValueBits()).append("]");
            }
        }
        return sb.toString().trim();
    }

    public static LineageItem[] getLineage(ExecutionContext ec, CPOperand ... operands) {
        return (LineageItem[])Arrays.stream(operands).filter(c -> c != null).map(c -> ec.getLineage().getOrCreate((CPOperand)c)).toArray(LineageItem[]::new);
    }

    public static void traceFedUDF(ExecutionContext ec, FederatedUDF udf) {
        if (udf.getLineageItem(ec) == null) {
            return;
        }
        if (udf.hasSingleLineage()) {
            Pair<String, LineageItem> item = udf.getLineageItem(ec);
            ec.getLineage().set((String)item.getKey(), (LineageItem)item.getValue());
        } else {
            Pair<String, LineageItem>[] items;
            for (Pair<String, LineageItem> item : items = udf.getLineageItems(ec)) {
                ec.getLineage().set((String)item.getKey(), (LineageItem)item.getValue());
            }
        }
    }

    public static FederatedResponse setUDFResponse(FederatedUDF udf, MatrixObject mo) {
        if (udf instanceof ReorgFEDInstruction.DiagMatrix || udf instanceof ReorgFEDInstruction.Rdiag) {
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, (Object)new int[]{(int)mo.getNumRows(), (int)mo.getNumColumns()});
        }
        return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS_EMPTY);
    }

    public static void constructLineageFromHops(Hop[] roots, String claName, Hop[] inputs, HashMap<Long, Hop> spoofmap) {
        if (LineageCodegenItem.getCodegenLTrace(claName) == null) {
            HashMap<Long, LineageItem> operands = new HashMap<Long, LineageItem>();
            for (Hop root : roots) {
                root.resetVisitStatus();
            }
            for (Hop root : roots) {
                LineageItemUtils.rConstructLineageFromHops(root, inputs, operands, spoofmap);
            }
            LineageItem out = (LineageItem)operands.get(roots[0].getHopID());
            if (roots.length > 1) {
                LineageItem[] outputs = (LineageItem[])Arrays.stream(roots).map(h -> new LineageItem("", Opcodes.CAST_AS_MATRIX.toString(), new LineageItem[]{(LineageItem)operands.get(h.getHopID())})).toArray(LineageItem[]::new);
                out = new LineageItem("", Opcodes.CBIND.toString(), outputs);
            }
            LineageCodegenItem.setCodegenLTrace(claName, out);
            for (Hop root : roots) {
                root.resetVisitStatus();
            }
        }
    }

    public static void rConstructLineageFromHops(Hop root, Hop[] inputs, Map<Long, LineageItem> operands, HashMap<Long, Hop> spoofmap) {
        boolean spoof;
        if (root.isVisited()) {
            return;
        }
        boolean bl = spoof = root instanceof SpoofFusedOp && ArrayUtils.contains((Object[])inputs, (Object)spoofmap.get(root.getHopID()));
        if (ArrayUtils.contains((Object[])inputs, (Object)root) || spoof) {
            Hop tmp = spoof ? spoofmap.get(root.getHopID()) : root;
            int pos = ArrayUtils.indexOf((Object[])inputs, (Object)tmp);
            LineageItem li = new LineageItem(LPLACEHOLDER + pos, "Create" + String.valueOf(root.getHopID()));
            operands.put(tmp.getHopID(), li);
            return;
        }
        for (int i = 0; i < root.getInput().size(); ++i) {
            LineageItemUtils.rConstructLineageFromHops(root.getInput().get(i), inputs, operands, spoofmap);
        }
        LineageItem li = null;
        LineageItem[] LIinputs = (LineageItem[])root.getInput().stream().map(h -> ArrayUtils.contains((Object[])inputs, spoofmap.get(h.getHopID())) ? (Hop)spoofmap.get(h.getHopID()) : h).map(h -> (LineageItem)operands.get(h.getHopID())).toArray(LineageItem[]::new);
        String name = Dag.getNextUniqueVarname(root.getDataType());
        if (root instanceof ReorgOp) {
            li = new LineageItem(name, Opcodes.TRANSPOSE.toString(), LIinputs);
        } else if (root instanceof UnaryOp) {
            String opcode = ((UnaryOp)root).getOp().toString();
            li = new LineageItem(name, opcode, LIinputs);
        } else if (root instanceof AggBinaryOp) {
            li = new LineageItem(name, Opcodes.MMULT.toString(), LIinputs);
        } else if (root instanceof BinaryOp) {
            li = new LineageItem(name, ((BinaryOp)root).getOp().toString(), LIinputs);
        } else if (root instanceof TernaryOp) {
            String opcode = ((TernaryOp)root).getOp().toString();
            li = new LineageItem(name, opcode, LIinputs);
        } else if (root instanceof AggUnaryOp) {
            Types.AggOp op = ((AggUnaryOp)root).getOp();
            Types.Direction dir = ((AggUnaryOp)root).getDirection();
            String opcode = PartialAggregate.getOpcode(op, dir);
            li = new LineageItem(name, opcode, LIinputs);
        } else if (root instanceof IndexingOp) {
            li = new LineageItem(name, "rightIndex", LIinputs);
        } else if (root instanceof ParameterizedBuiltinOp) {
            String opcode = ((ParameterizedBuiltinOp)root).getOp().toString();
            if (opcode.equalsIgnoreCase(Opcodes.REPLACE.toString())) {
                li = new LineageItem(name, opcode, LIinputs);
            }
        } else if (root instanceof SpoofFusedOp) {
            li = LineageCodegenItem.getCodegenLTrace(((SpoofFusedOp)root).getClassName());
        } else if (root instanceof LiteralOp) {
            li = LineageItemUtils.createScalarLineageItem((LiteralOp)root);
        } else {
            throw new DMLRuntimeException("Unsupported hop: " + root.getOpString());
        }
        operands.put(root.getHopID(), li);
        root.setVisited();
    }

    @Deprecated
    public static LineageItem rDecompress(LineageItem item) {
        if (item.getType() == LineageItem.LineageItemType.Dedup) {
            LineageItem dedupInput = LineageItemUtils.rDecompress(item.getInputs()[0]);
            ArrayList<LineageItem> inputs = new ArrayList<LineageItem>();
            for (LineageItem li : item.getInputs()[1].getInputs()) {
                inputs.add(LineageItemUtils.rDecompress(li));
            }
            LineageItem li = new LineageItem(item.getInputs()[1].getData(), item.getInputs()[1].getOpcode(), inputs.toArray(new LineageItem[0]));
            li.resetVisitStatusNR();
            LineageItemUtils.rSetDedupInputOntoOutput(item.getData(), li, dedupInput);
            li.resetVisitStatusNR();
            return li;
        }
        ArrayList<LineageItem> inputs = new ArrayList<LineageItem>();
        if (item.getInputs() != null) {
            for (LineageItem li : item.getInputs()) {
                inputs.add(LineageItemUtils.rDecompress(li));
            }
        }
        return new LineageItem(item.getData(), item.getOpcode(), inputs.toArray(new LineageItem[0]));
    }

    public static void writeTraceToHDFS(String trace, String fname) {
        try {
            HDFSTool.writeStringToHDFS(trace, fname);
            FileSystem fs = IOUtilFunctions.getFileSystem(fname);
            if (fs instanceof LocalFileSystem) {
                Path path = new Path(fname);
                IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fs, path);
            }
        }
        catch (IOException e) {
            throw new DMLRuntimeException(e);
        }
    }

    private static void rSetDedupInputOntoOutput(String name, LineageItem item, LineageItem dedupInput) {
        if (item.isVisited()) {
            return;
        }
        if (item.getInputs() != null) {
            for (int i = 0; i < item.getInputs().length; ++i) {
                CPOperand tmp;
                LineageItem li = item.getInputs()[i];
                if (li.getType() == LineageItem.LineageItemType.Literal && !(tmp = new CPOperand(li.getData())).isLiteral() && tmp.getName().equals(name)) {
                    item.getInputs()[i] = dedupInput;
                }
                if (li.getType() == LineageItem.LineageItemType.Creation) {
                    item.getInputs()[i] = dedupInput;
                }
                LineageItemUtils.rSetDedupInputOntoOutput(name, li, dedupInput);
            }
        }
        item.setVisited();
    }

    public static LineageItem replace(LineageItem root, LineageItem liOld, LineageItem liNew) {
        if (liNew == null) {
            throw new DMLRuntimeException("Invalid null lineage item for " + liOld.getId());
        }
        root.resetVisitStatusNR();
        LineageItemUtils.rReplaceNR(root, liOld, liNew);
        root.resetVisitStatusNR();
        return root;
    }

    public static void rReplaceNR(LineageItem current, LineageItem liOld, LineageItem liNew) {
        Stack<LineageItem> q = new Stack<LineageItem>();
        q.push(current);
        while (!q.empty()) {
            LineageItem tmp = (LineageItem)q.pop();
            if (tmp.isVisited() || tmp.getInputs() == null) continue;
            for (int i = 0; i < tmp.getInputs().length; ++i) {
                LineageItem ctmp = tmp.getInputs()[i];
                if (liOld.getId() == ctmp.getId() && liOld.equals(ctmp)) {
                    tmp.setInput(i, liNew);
                    continue;
                }
                q.push(ctmp);
            }
            tmp.setVisited(true);
        }
    }

    @Deprecated
    private static void rReplace(LineageItem current, LineageItem liOld, LineageItem liNew) {
        if (current.isVisited() || current.getInputs() == null) {
            return;
        }
        if (liNew == null) {
            throw new DMLRuntimeException("Invalid null lineage item for " + liOld.getId());
        }
        for (int i = 0; i < current.getInputs().length; ++i) {
            LineageItem tmp = current.getInputs()[i];
            if (liOld.equals(tmp)) {
                current.setInput(i, liNew);
                continue;
            }
            LineageItemUtils.rReplace(tmp, liOld, liNew);
        }
        current.setVisited();
    }

    public static void replaceDagLeaves(ExecutionContext ec, LineageItem root, CPOperand[] newLeaves) {
        root.resetVisitStatusNR();
        LineageItemUtils.rReplaceDagLeaves(root, LineageItemUtils.getLineage(ec, newLeaves));
        root.resetVisitStatusNR();
    }

    public static void rReplaceDagLeaves(LineageItem root, LineageItem[] newleaves) {
        if (root.isVisited() || root.isLeaf()) {
            return;
        }
        for (int i = 0; i < root.getInputs().length; ++i) {
            LineageItem li = root.getInputs()[i];
            if (li.isLeaf() && li.getType() != LineageItem.LineageItemType.Literal && li.getData().startsWith(LPLACEHOLDER)) {
                root.setInput(i, newleaves[Integer.parseInt(li.getData().substring(3))]);
                continue;
            }
            LineageItemUtils.rReplaceDagLeaves(li, newleaves);
        }
        root.resetHash();
        root.setVisited();
    }

    public static void rGetDagLeaves(HashSet<LineageItem> leaves, LineageItem root) {
        if (root.isVisited()) {
            return;
        }
        if (root.isLeaf()) {
            leaves.add(root);
        } else {
            for (LineageItem li : root.getInputs()) {
                LineageItemUtils.rGetDagLeaves(leaves, li);
            }
        }
        root.setVisited();
    }

    public static void checkCycles(LineageItem current) {
        current.resetVisitStatusNR();
        LineageItemUtils.rCheckCycles(current, new HashSet<Long>(), true);
        current.resetVisitStatusNR();
    }

    public static void rCheckCycles(LineageItem current, Set<Long> probe, boolean useObjIdent) {
        long id;
        if (current.isVisited()) {
            return;
        }
        long l = id = useObjIdent ? (long)System.identityHashCode(current) : current.getId();
        if (probe.contains(id)) {
            throw new DMLRuntimeException("Cycle detected for " + current.toString());
        }
        probe.add(id);
        if (current.getInputs() != null) {
            for (LineageItem li : current.getInputs()) {
                LineageItemUtils.rCheckCycles(li, probe, useObjIdent);
            }
        }
        current.setVisited();
    }

    public static boolean containsRandDataGen(HashSet<LineageItem> entries, LineageItem root) {
        if (entries.contains(root) || root.isVisited()) {
            return false;
        }
        boolean isRand = LineageItemUtils.isNonDeterministic(root);
        if (!root.isLeaf() && !isRand) {
            for (LineageItem input : root.getInputs()) {
                isRand |= LineageItemUtils.containsRandDataGen(entries, input);
            }
        }
        root.setVisited();
        return isRand;
    }

    private static boolean isNonDeterministic(LineageItem li) {
        if (li.getType() != LineageItem.LineageItemType.Creation) {
            return false;
        }
        boolean isND = false;
        DataGenCPInstruction cprand = null;
        RandSPInstruction sprand = null;
        Instruction ins = InstructionParser.parseSingleInstruction(li.getData());
        if (ins instanceof DataGenCPInstruction) {
            cprand = (DataGenCPInstruction)ins;
        } else if (ins instanceof RandSPInstruction) {
            sprand = (RandSPInstruction)ins;
        } else {
            return false;
        }
        switch (li.getOpcode().toUpperCase()) {
            case "RAND": {
                if (cprand != null && (cprand.getMinValue() != cprand.getMaxValue() || cprand.getSparsity() != 1.0)) {
                    isND = true;
                }
                if (sprand == null || sprand.getMinValue() == sprand.getMaxValue() && sprand.getSparsity() == 1.0) break;
                isND = true;
                break;
            }
            case "SAMPLE": {
                isND = true;
                break;
            }
            default: {
                isND = false;
            }
        }
        return isND;
    }

    public static LineageItem[] getLineageItemInputstoSB(ArrayList<String> inputs, ExecutionContext ec) {
        if (LineageCacheConfig.ReuseCacheType.isNone() && !DMLScript.LINEAGE_DEDUP) {
            return null;
        }
        ArrayList<CPOperand> CPOpInputs = inputs.size() > 0 ? new ArrayList<CPOperand>() : null;
        for (int i = 0; i < inputs.size(); ++i) {
            Data value = ec.getVariable(inputs.get(i));
            if (value == null) continue;
            CPOpInputs.add(new CPOperand(value instanceof ScalarObject ? value.toString() : inputs.get(i), value.getValueType(), value.getDataType()));
        }
        return CPOpInputs != null ? LineageItemUtils.getLineage(ec, CPOpInputs.toArray(new CPOperand[CPOpInputs.size()])) : null;
    }

    public static boolean hasValidInsts(ArrayList<Instruction> insts) {
        int count = 0;
        boolean hasSPInst = false;
        boolean hasFrameInput = false;
        for (Instruction ins : insts) {
            if (ins instanceof VariableCPInstruction) continue;
            ++count;
            if (ins instanceof ComputationSPInstruction && !ins.getOpcode().equals("chkpoint") || ins.getOpcode().equals(Opcodes.PREFETCH.toString())) {
                hasSPInst = true;
            }
            if (!(ins instanceof ComputationCPInstruction) || !((ComputationCPInstruction)ins).hasFrameInput()) continue;
            hasFrameInput = true;
        }
        return count >= 10 || hasSPInst || hasFrameInput;
    }

    public static void addAllDataLineage(ExecutionContext ec) {
        for (Map.Entry<String, Data> e : ec.getVariables().entrySet()) {
            if (!(e.getValue() instanceof CacheableData)) continue;
            CacheableData cdata = (CacheableData)e.getValue();
            String fromVar = "pREAD" + e.getKey();
            ec.traceLineage(VariableCPInstruction.prepCreatevarInstruction(fromVar, "CacheableData::" + cdata.getUniqueID(), false, "binary"));
            ec.traceLineage(VariableCPInstruction.prepMoveInstruction(fromVar, e.getKey()));
        }
    }

    public static LineageItem createScalarLineageItem(LiteralOp lop) {
        StringBuilder sb = new StringBuilder(lop.getName());
        sb.append("\u00b7");
        sb.append(lop.getDataType().toString());
        sb.append("\u00b7");
        sb.append(lop.getValueType().toString());
        sb.append("\u00b7");
        sb.append(true);
        return new LineageItem(sb.toString());
    }

    public static LineageItem getSerializedFedResponseLineageItem(LineageItem li) {
        return new LineageItem(SERIALIZATION_OPCODE, new LineageItem[]{li});
    }
}

