/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;

public abstract class LibMatrixSparseToDense {
    public static final Log LOG = LogFactory.getLog((String)LibMatrixSparseToDense.class.getName());
    public static long PAR_THRESHOLD = 1000000L;

    private LibMatrixSparseToDense() {
    }

    public static void sparseToDense(MatrixBlock r, int k) {
        SparseBlock a = r.sparseBlock;
        int m = r.rlen;
        if (a == null) {
            return;
        }
        r.sparse = false;
        if (!r.allocateDenseBlock(false)) {
            r.denseBlock.reset();
        }
        DenseBlock c = r.denseBlock;
        if (k > 1 && r.getNonZeros() > PAR_THRESHOLD && r.getNumRows() > 1) {
            LibMatrixSparseToDense.multiThreadedToDense(a, c, m, k);
        } else {
            LibMatrixSparseToDense.singleThreadedToDense(a, c, m);
        }
        r.sparseBlock = null;
    }

    private static void singleThreadedToDense(SparseBlock a, DenseBlock c, int m) {
        for (int i = 0; i < m; ++i) {
            LibMatrixSparseToDense.processRow(a, c, i);
        }
    }

    private static void multiThreadedToDense(SparseBlock a, DenseBlock c, int m, int k) {
        ExecutorService pool = CommonThreadPool.get(k);
        try {
            ArrayList tasks = new ArrayList();
            int blkz = Math.max(1, m / k);
            for (int i = 0; i < m; i += blkz) {
                int n = i;
                int end = Math.min(m, i + blkz);
                tasks.add(pool.submit(() -> LibMatrixSparseToDense.processRange(a, c, start, end)));
            }
            for (Future future : tasks) {
                future.get();
            }
        }
        catch (Exception e) {
            throw new DMLRuntimeException("Failed parallel to dense", e);
        }
        finally {
            pool.shutdown();
        }
    }

    private static void processRange(SparseBlock a, DenseBlock c, int rl, int ru) {
        for (int i = rl; i < ru; ++i) {
            LibMatrixSparseToDense.processRow(a, c, i);
        }
    }

    private static void processRow(SparseBlock a, DenseBlock c, int i) {
        if (!a.isEmpty(i)) {
            int apos = a.pos(i);
            int alen = a.size(i);
            int[] aix = a.indexes(i);
            double[] avals = a.values(i);
            double[] cvals = c.values(i);
            int cix = c.pos(i);
            for (int j = apos; j < apos + alen; ++j) {
                cvals[cix + aix[j]] = avals[j];
            }
        }
    }
}

