/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.DataInput;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.bitmap.ABitmap;
import org.apache.sysds.runtime.compress.bitmap.Bitmap;
import org.apache.sysds.runtime.compress.bitmap.MultiColBitmap;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.AColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.IContainADictionary;
import org.apache.sysds.runtime.compress.colgroup.IContainDefaultTuple;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IdentityDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IdentityDictionarySlice;
import org.apache.sysds.runtime.compress.colgroup.dictionary.MatrixBlockDictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.PlaceHolderDict;
import org.apache.sysds.runtime.compress.colgroup.dictionary.QDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.lib.CLALibCombineGroups;
import org.apache.sysds.runtime.compress.utils.ACount;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.compress.utils.DblArrayCountHashMap;
import org.apache.sysds.runtime.compress.utils.DoubleCountHashMap;
import org.apache.sysds.runtime.compress.utils.HashMapLongInt;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseRowVector;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.Pair;

public interface DictionaryFactory {
    public static final Log LOG = LogFactory.getLog((String)DictionaryFactory.class.getName());

    public static IDictionary read(DataInput in) throws IOException {
        Type type = Type.values()[in.readByte()];
        switch (type) {
            case FP64_DICT: {
                return Dictionary.read(in);
            }
            case INT8_DICT: {
                return QDictionary.read(in);
            }
            case PLACE_HOLDER: {
                return PlaceHolderDict.read(in);
            }
            case IDENTITY: {
                return IdentityDictionary.read(in);
            }
            case IDENTITY_SLICE: {
                return IdentityDictionarySlice.read(in);
            }
        }
        return MatrixBlockDictionary.read(in);
    }

    public static long getInMemorySize(int nrValues, int nrColumns, double tupleSparsity, boolean lossy) {
        if (lossy) {
            return QDictionary.getInMemorySize(nrValues * nrColumns);
        }
        if (nrColumns > 1 && tupleSparsity < 0.4) {
            return MatrixBlockDictionary.getInMemorySize(nrValues, nrColumns, tupleSparsity);
        }
        return Dictionary.getInMemorySize(nrValues * nrColumns);
    }

    public static IDictionary create(DblArrayCountHashMap map, int nCols, boolean addZeroTuple, double sparsity) {
        ACount<T>[] vals = map.extractValues();
        int nVals = vals.length;
        int nTuplesOut = nVals + (addZeroTuple ? 1 : 0);
        if (sparsity < 0.4) {
            MatrixBlock retB = new MatrixBlock(nTuplesOut, nCols, true);
            retB.allocateSparseRowsBlock();
            SparseBlock sb = retB.getSparseBlock();
            for (int i = 0; i < nVals; ++i) {
                ACount dac = vals[i];
                double[] dv = ((DblArray)dac.key()).getData();
                for (int k = 0; k < dv.length; ++k) {
                    sb.append(dac.id, k, dv[k]);
                }
            }
            retB.recomputeNonZeros();
            retB.examSparsity(true);
            return MatrixBlockDictionary.create(retB);
        }
        double[] resValues = new double[nTuplesOut * nCols];
        for (int i = 0; i < nVals; ++i) {
            ACount dac = vals[i];
            System.arraycopy(((DblArray)dac.key()).getData(), 0, resValues, dac.id * nCols, nCols);
        }
        return Dictionary.create(resValues);
    }

    public static IDictionary create(ABitmap ubm) {
        return DictionaryFactory.create(ubm, 1.0);
    }

    public static IDictionary create(ABitmap ubm, double sparsity) {
        int nCol = ubm.getNumColumns();
        if (ubm instanceof Bitmap) {
            return Dictionary.create(((Bitmap)ubm).getValues());
        }
        if (sparsity < 0.4 && nCol > 4) {
            MultiColBitmap mcbm = (MultiColBitmap)ubm;
            MatrixBlock m = new MatrixBlock(ubm.getNumValues(), nCol, true);
            m.allocateSparseRowsBlock();
            SparseBlock sb = m.getSparseBlock();
            int nVals = ubm.getNumValues();
            for (int i = 0; i < nVals; ++i) {
                double[] tuple = mcbm.getValues(i);
                for (int col = 0; col < nCol; ++col) {
                    sb.append(i, col, tuple[col]);
                }
            }
            m.recomputeNonZeros();
            m.examSparsity(true);
            return MatrixBlockDictionary.create(m);
        }
        MultiColBitmap mcbm = (MultiColBitmap)ubm;
        int nVals = ubm.getNumValues();
        double[] resValues = new double[nVals * nCol];
        for (int i = 0; i < nVals; ++i) {
            System.arraycopy(mcbm.getValues(i), 0, resValues, i * nCol, nCol);
        }
        return Dictionary.create(resValues);
    }

    public static IDictionary create(ABitmap ubm, int defaultIndex, double[] defaultTuple, double sparsity, boolean addZero) {
        int nCol = ubm.getNumColumns();
        int nVal = ubm.getNumValues() - (addZero ? 0 : 1);
        if (nCol > 4 && sparsity < 0.4) {
            int i;
            MultiColBitmap mcbm = (MultiColBitmap)ubm;
            MatrixBlock m = new MatrixBlock(nVal, nCol, true);
            m.allocateSparseRowsBlock();
            SparseBlock sb = m.getSparseBlock();
            for (i = 0; i < defaultIndex; ++i) {
                sb.set(i, new SparseRowVector(mcbm.getValues(i)), false);
            }
            System.arraycopy(mcbm.getValues(defaultIndex), 0, defaultTuple, 0, nCol);
            for (i = defaultIndex; i < ubm.getNumValues() - 1; ++i) {
                sb.set(i, new SparseRowVector(mcbm.getValues(i + 1)), false);
            }
            m.recomputeNonZeros();
            m.examSparsity(true);
            return MatrixBlockDictionary.create(m);
        }
        double[] dict = new double[nCol * nVal];
        if (ubm instanceof Bitmap) {
            double[] bmv = ((Bitmap)ubm).getValues();
            System.arraycopy(bmv, 0, dict, 0, defaultIndex);
            defaultTuple[0] = bmv[defaultIndex];
            System.arraycopy(bmv, defaultIndex + 1, dict, defaultIndex, bmv.length - defaultIndex - 1);
        } else {
            int i;
            MultiColBitmap mcbm = (MultiColBitmap)ubm;
            for (i = 0; i < defaultIndex; ++i) {
                System.arraycopy(mcbm.getValues(i), 0, dict, i * nCol, nCol);
            }
            System.arraycopy(mcbm.getValues(defaultIndex), 0, defaultTuple, 0, nCol);
            for (i = defaultIndex; i < ubm.getNumValues() - 1; ++i) {
                System.arraycopy(mcbm.getValues(i + 1), 0, dict, i * nCol, nCol);
            }
        }
        return Dictionary.create(dict);
    }

    public static IDictionary create(DoubleCountHashMap map) {
        double[] resValues = map.getDictionary();
        return Dictionary.create(resValues);
    }

    public static IDictionary combineDictionaries(AColGroupCompressed a, AColGroupCompressed b) {
        return DictionaryFactory.combineDictionaries(a, b, null);
    }

    public static IDictionary combineDictionaries(AColGroupCompressed a, AColGroupCompressed b, HashMapLongInt filter) {
        if (a instanceof ColGroupEmpty && b instanceof ColGroupEmpty) {
            return null;
        }
        AColGroup.CompressionType ac = a.getCompType();
        AColGroup.CompressionType bc = b.getCompType();
        boolean ae = a instanceof IContainADictionary;
        boolean be = b instanceof IContainADictionary;
        if (ae && be) {
            IDictionary ad = ((IContainADictionary)((Object)a)).getDictionary();
            IDictionary bd = ((IContainADictionary)((Object)b)).getDictionary();
            if (ac.isConst()) {
                if (bc.isConst()) {
                    return Dictionary.create(CLALibCombineGroups.constructDefaultTuple(a, b));
                }
                if (bc.isDense()) {
                    double[] at = ((IContainDefaultTuple)((Object)a)).getDefaultTuple();
                    Pair<int[], int[]> r = IColIndex.reorderingIndexes(a.getColIndices(), b.getColIndices());
                    return DictionaryFactory.combineConstLeft(at, bd, b.getNumCols(), r.getKey(), r.getValue(), filter);
                }
            } else if (ac.isDense()) {
                if (bc.isConst()) {
                    Pair<int[], int[]> r = IColIndex.reorderingIndexes(a.getColIndices(), b.getColIndices());
                    double[] bt = ((IContainDefaultTuple)((Object)b)).getDefaultTuple();
                    return DictionaryFactory.combineSparseConstSparseRet(ad, a.getNumCols(), bt, r.getKey(), r.getValue(), filter);
                }
                if (bc.isDense()) {
                    return DictionaryFactory.combineFullDictionaries(ad, a.getColIndices(), bd, b.getColIndices(), filter);
                }
                if (bc.isSDC()) {
                    double[] tuple = ((IContainDefaultTuple)((Object)b)).getDefaultTuple();
                    return DictionaryFactory.combineSDCRight(ad, a.getColIndices(), bd, tuple, b.getColIndices(), filter);
                }
            } else if (ac.isSDC() && bc.isSDC()) {
                double[] at = ((IContainDefaultTuple)((Object)a)).getDefaultTuple();
                double[] bt = ((IContainDefaultTuple)((Object)b)).getDefaultTuple();
                return DictionaryFactory.combineSDCFilter(ad, at, a.getColIndices(), bd, bt, b.getColIndices(), filter);
            }
        }
        throw new NotImplementedException("Not supporting combining: " + a + " " + b);
    }

    public static IDictionary combineDictionariesSparse(AColGroupCompressed a, AColGroupCompressed b) {
        return DictionaryFactory.combineDictionariesSparse(a, b, null);
    }

    public static IDictionary combineDictionariesSparse(AColGroupCompressed a, AColGroupCompressed b, HashMapLongInt filter) {
        AColGroup.CompressionType ac = a.getCompType();
        AColGroup.CompressionType bc = b.getCompType();
        if (filter != null) {
            throw new NotImplementedException("Not supported filter for sparse join yet!");
        }
        if (ac.isSDC()) {
            IDictionary ad = ((IContainADictionary)((Object)a)).getDictionary();
            if (bc.isConst()) {
                Pair<int[], int[]> r = IColIndex.reorderingIndexes(a.getColIndices(), b.getColIndices());
                double[] bt = ((IContainDefaultTuple)((Object)b)).getDefaultTuple();
                return DictionaryFactory.combineSparseConstSparseRet(ad, a.getNumCols(), bt, r.getKey(), r.getValue());
            }
            if (bc.isSDC()) {
                IDictionary bd = ((IContainADictionary)((Object)b)).getDictionary();
                if (a.sameIndexStructure(b)) {
                    if (IColIndex.inOrder(a.getColIndices(), b.getColIndices())) {
                        return ad.cbind(bd, b.getNumCols());
                    }
                    if (IColIndex.inOrder(b.getColIndices(), a.getColIndices())) {
                        return bd.cbind(ad, b.getNumCols());
                    }
                    Pair<int[], int[]> r = IColIndex.reorderingIndexes(a.getColIndices(), b.getColIndices());
                    return DictionaryFactory.cbindReorder(ad, bd, r.getKey(), r.getValue());
                }
            }
        } else if (ac.isConst()) {
            double[] at = ((IContainDefaultTuple)((Object)a)).getDefaultTuple();
            if (bc.isSDC()) {
                IDictionary bd = ((IContainADictionary)((Object)b)).getDictionary();
                Pair<int[], int[]> r = IColIndex.reorderingIndexes(a.getColIndices(), b.getColIndices());
                return DictionaryFactory.combineConstLeftAll(at, bd, b.getNumCols(), r.getKey(), r.getValue());
            }
        }
        throw new NotImplementedException("Not supporting combining dense: " + a + " " + b);
    }

    private static IDictionary cbindReorder(IDictionary a, IDictionary b, int[] ai, int[] bi) {
        int nca = ai.length;
        int ncb = bi.length;
        int ra = a.getNumberOfValues(nca);
        int rb = b.getNumberOfValues(ncb);
        MatrixBlock ma = a.getMBDict(nca).getMatrixBlock();
        MatrixBlock mb = b.getMBDict(ncb).getMatrixBlock();
        if (ra != rb) {
            throw new DMLCompressionException("Invalid cbind reorder, different sizes of dictionaries");
        }
        MatrixBlock out = new MatrixBlock(ra, nca + ncb, false);
        for (int r = 0; r < ra; ++r) {
            int c;
            for (c = 0; c < nca; ++c) {
                out.set(r, ai[c], ma.get(r, c));
            }
            for (c = 0; c < ncb; ++c) {
                out.set(r, bi[c], mb.get(r, c));
            }
        }
        return new MatrixBlockDictionary(out);
    }

    public static IDictionary combineFullDictionaries(IDictionary a, int nca, IDictionary b, int ncb) {
        return DictionaryFactory.combineFullDictionaries(a, nca, b, ncb, null);
    }

    public static IDictionary combineFullDictionaries(IDictionary a, IColIndex ai, IDictionary b, IColIndex bi, HashMapLongInt filter) {
        int nca = ai.size();
        int ncb = bi.size();
        return DictionaryFactory.combineFullDictionaries(a, ai, nca, b, bi, ncb, filter);
    }

    public static IDictionary combineFullDictionaries(IDictionary a, int nca, IDictionary b, int ncb, HashMapLongInt filter) {
        return DictionaryFactory.combineFullDictionaries(a, null, nca, b, null, ncb, filter);
    }

    public static IDictionary combineFullDictionaries(IDictionary a, IColIndex ai, int nca, IDictionary b, IColIndex bi, int ncb, HashMapLongInt filter) {
        int filterSize;
        int ra = a.getNumberOfValues(nca);
        int rb = b.getNumberOfValues(ncb);
        MatrixBlock ma = a.getMBDict(nca).getMatrixBlock();
        MatrixBlock mb = b.getMBDict(ncb).getMatrixBlock();
        int n = filterSize = filter != null ? filter.size() : ra * rb;
        if (filterSize == 0) {
            return null;
        }
        MatrixBlock out = new MatrixBlock(filterSize, nca + ncb, false);
        out.allocateBlock();
        if (ai != null && bi != null && !IColIndex.inOrder(ai, bi)) {
            Pair<int[], int[]> reordering = IColIndex.reorderingIndexes(ai, bi);
            if (filter != null) {
                DictionaryFactory.combineFullDictionariesOOOFilter(out, filter, ra, rb, nca, ncb, reordering.getKey(), reordering.getValue(), ma, mb);
            } else {
                DictionaryFactory.combineFullDictionariesOOONoFilter(out, ra, rb, nca, ncb, reordering.getKey(), reordering.getValue(), ma, mb);
            }
        } else if (filter != null) {
            DictionaryFactory.combineFullDictionariesFilter(out, filter, ra, rb, nca, ncb, ma, mb);
        } else {
            DictionaryFactory.combineFullDictionariesNoFilter(out, ra, rb, nca, ncb, ma, mb);
        }
        out.examSparsity(true);
        return new MatrixBlockDictionary(out);
    }

    private static void combineFullDictionariesFilter(MatrixBlock out, HashMapLongInt filter, int ra, int rb, int nca, int ncb, MatrixBlock ma, MatrixBlock mb) {
        for (HashMapLongInt.KV k : filter) {
            int c;
            int r = (int)k.k;
            int o = k.v;
            int ia = r % ra;
            int ib = r / ra;
            for (c = 0; c < nca; ++c) {
                out.set(o, c, ma.get(ia, c));
            }
            for (c = 0; c < ncb; ++c) {
                out.set(o, c + nca, mb.get(ib, c));
            }
        }
    }

    private static void combineFullDictionariesOOOFilter(MatrixBlock out, HashMapLongInt filter, int ra, int rb, int nca, int ncb, int[] ai, int[] bi, MatrixBlock ma, MatrixBlock mb) {
        for (HashMapLongInt.KV k : filter) {
            int c;
            int r = (int)k.k;
            int o = k.v;
            int ia = r % ra;
            int ib = r / ra;
            for (c = 0; c < nca; ++c) {
                out.set(o, ai[c], ma.get(ia, c));
            }
            for (c = 0; c < ncb; ++c) {
                out.set(o, bi[c], mb.get(ib, c));
            }
        }
    }

    private static void combineFullDictionariesOOONoFilter(MatrixBlock out, int ra, int rb, int nca, int ncb, int[] ai, int[] bi, MatrixBlock ma, MatrixBlock mb) {
        for (int r = 0; r < out.getNumRows(); ++r) {
            int c;
            int ia = r % ra;
            int ib = r / ra;
            for (c = 0; c < nca; ++c) {
                out.set(r, ai[c], ma.get(ia, c));
            }
            for (c = 0; c < ncb; ++c) {
                out.set(r, bi[c], mb.get(ib, c));
            }
        }
    }

    private static void combineFullDictionariesNoFilter(MatrixBlock out, int ra, int rb, int nca, int ncb, MatrixBlock ma, MatrixBlock mb) {
        for (int r = 0; r < out.getNumRows(); ++r) {
            int c;
            int ia = r % ra;
            int ib = r / ra;
            for (c = 0; c < nca; ++c) {
                out.set(r, c, ma.get(ia, c));
            }
            for (c = 0; c < ncb; ++c) {
                out.set(r, c + nca, mb.get(ib, c));
            }
        }
    }

    public static IDictionary combineSDCRightNoFilter(IDictionary a, int nca, IDictionary b, double[] tub) {
        return DictionaryFactory.combineSDCRightNoFilter(a, null, nca, b, tub, null);
    }

    public static IDictionary combineSDCRightNoFilter(IDictionary a, IColIndex ai, int nca, IDictionary b, double[] tub, IColIndex bi) {
        int r;
        if (ai != null || bi != null) {
            throw new NotImplementedException();
        }
        int ncb = tub.length;
        int ra = a.getNumberOfValues(nca);
        int rb = b.getNumberOfValues(ncb);
        MatrixBlock ma = a.getMBDict(nca).getMatrixBlock();
        MatrixBlock mb = b.getMBDict(ncb).getMatrixBlock();
        MatrixBlock out = new MatrixBlock(ra * (rb + 1), nca + ncb, false);
        out.allocateBlock();
        for (r = 0; r < ra; ++r) {
            int c;
            for (c = 0; c < nca; ++c) {
                out.set(r, c, ma.get(r, c));
            }
            for (c = 0; c < ncb; ++c) {
                out.set(r, c + nca, tub[c]);
            }
        }
        for (r = ra; r < out.getNumRows(); ++r) {
            int c;
            int ia = r % ra;
            int ib = r / ra - 1;
            for (c = 0; c < nca; ++c) {
                out.set(r, c, ma.get(ia, c));
            }
            for (c = 0; c < ncb; ++c) {
                out.set(r, c + nca, mb.get(ib, c));
            }
        }
        return new MatrixBlockDictionary(out);
    }

    public static IDictionary combineSDCRight(IDictionary a, IColIndex ai, IDictionary b, double[] tub, IColIndex bi, HashMapLongInt filter) {
        return DictionaryFactory.combineSDCRight(a, ai, ai.size(), b, tub, bi, filter);
    }

    public static IDictionary combineSDCRight(IDictionary a, int nca, IDictionary b, double[] tub, HashMapLongInt filter) {
        return DictionaryFactory.combineSDCRight(a, null, nca, b, tub, null, filter);
    }

    public static IDictionary combineSDCRight(IDictionary a, IColIndex ai, int nca, IDictionary b, double[] tub, IColIndex bi, HashMapLongInt filter) {
        if (filter == null) {
            return DictionaryFactory.combineSDCRightNoFilter(a, ai, nca, b, tub, bi);
        }
        int ncb = tub.length;
        int ra = a.getNumberOfValues(nca);
        int rb = b.getNumberOfValues(ncb);
        MatrixBlock ma = a.getMBDict(nca).getMatrixBlock();
        MatrixBlock mb = b.getMBDict(ncb).getMatrixBlock();
        MatrixBlock out = new MatrixBlock(filter.size(), nca + ncb, false);
        out.allocateBlock();
        if (ai != null && bi != null) {
            Pair<int[], int[]> re = IColIndex.reorderingIndexes(ai, bi);
            DictionaryFactory.combineSDCRightOOOFilter(out, nca, ncb, tub, ra, rb, ma, mb, re.getKey(), re.getValue(), filter);
        } else {
            DictionaryFactory.combineSDCRightFilter(out, nca, ncb, tub, ra, rb, ma, mb, filter);
        }
        return new MatrixBlockDictionary(out);
    }

    private static void combineSDCRightFilter(MatrixBlock out, int nca, int ncb, double[] tub, int ra, int rb, MatrixBlock ma, MatrixBlock mb, HashMapLongInt filter) {
        int o;
        int r;
        for (r = 0; r < ra; ++r) {
            int c;
            o = filter.get(r);
            if (o == -1) continue;
            for (c = 0; c < nca; ++c) {
                out.set(o, c, ma.get(r, c));
            }
            for (c = 0; c < ncb; ++c) {
                out.set(o, c + nca, tub[c]);
            }
        }
        for (r = ra; r < ra * rb + ra; ++r) {
            int c;
            o = filter.get(r);
            if (o == -1) continue;
            int ia = r % ra;
            int ib = r / ra - 1;
            for (c = 0; c < nca; ++c) {
                out.set(o, c, ma.get(ia, c));
            }
            for (c = 0; c < ncb; ++c) {
                out.set(o, c + nca, mb.get(ib, c));
            }
        }
    }

    private static void combineSDCRightOOOFilter(MatrixBlock out, int nca, int ncb, double[] tub, int ra, int rb, MatrixBlock ma, MatrixBlock mb, int[] ai, int[] bi, HashMapLongInt filter) {
        int o;
        int r;
        for (r = 0; r < ra; ++r) {
            int c;
            o = filter.get(r);
            if (o == -1) continue;
            for (c = 0; c < nca; ++c) {
                out.set(o, ai[c], ma.get(r, c));
            }
            for (c = 0; c < ncb; ++c) {
                out.set(o, bi[c], tub[c]);
            }
        }
        for (r = ra; r < ra * rb + ra; ++r) {
            int c;
            o = filter.get(r);
            if (o == -1) continue;
            int ia = r % ra;
            int ib = r / ra - 1;
            for (c = 0; c < nca; ++c) {
                out.set(o, ai[c], ma.get(ia, c));
            }
            for (c = 0; c < ncb; ++c) {
                out.set(o, bi[c], mb.get(ib, c));
            }
        }
    }

    public static IDictionary combineSDCNoFilter(IDictionary a, double[] tua, IDictionary b, double[] tub) {
        return DictionaryFactory.combineSDCNoFilter(a, tua, null, b, tub, null);
    }

    public static IDictionary combineSDCNoFilter(IDictionary a, double[] tua, IColIndex ai, IDictionary b, double[] tub, IColIndex bi) {
        int nca = tua.length;
        int ncb = tub.length;
        int ra = a.getNumberOfValues(nca);
        int rb = b.getNumberOfValues(ncb);
        MatrixBlock ma = a.getMBDict(nca).getMatrixBlock();
        MatrixBlock mb = b.getMBDict(ncb).getMatrixBlock();
        MatrixBlock out = new MatrixBlock((ra + 1) * (rb + 1), nca + ncb, false);
        out.allocateBlock();
        if (ai != null || bi != null) {
            Pair<int[], int[]> re = IColIndex.reorderingIndexes(ai, bi);
            DictionaryFactory.combineSDCNoFilterOOO(nca, ncb, tua, tub, out, ma, mb, ra, rb, re.getKey(), re.getValue());
        } else {
            DictionaryFactory.combineSDCNoFilter(nca, ncb, tua, tub, out, ma, mb, ra, rb);
        }
        return new MatrixBlockDictionary(out);
    }

    private static void combineSDCNoFilter(int nca, int ncb, double[] tua, double[] tub, MatrixBlock out, MatrixBlock ma, MatrixBlock mb, int ra, int rb) {
        int r;
        int c;
        for (c = 0; c < nca; ++c) {
            out.set(0, c, tua[c]);
        }
        for (c = 0; c < ncb; ++c) {
            out.set(0, c + nca, tub[c]);
        }
        for (r = 1; r < ra + 1; ++r) {
            int c2;
            for (c2 = 0; c2 < nca; ++c2) {
                out.set(r, c2, ma.get(r - 1, c2));
            }
            for (c2 = 0; c2 < ncb; ++c2) {
                out.set(r, c2 + nca, tub[c2]);
            }
        }
        for (r = ra + 1; r < out.getNumRows(); ++r) {
            int c3;
            int ia = r % (ra + 1) - 1;
            int ib = r / (ra + 1) - 1;
            if (ia == -1) {
                for (c3 = 0; c3 < nca; ++c3) {
                    out.set(r, c3, tua[c3]);
                }
            } else {
                for (c3 = 0; c3 < nca; ++c3) {
                    out.set(r, c3, ma.get(ia, c3));
                }
            }
            for (c3 = 0; c3 < ncb; ++c3) {
                out.set(r, c3 + nca, mb.get(ib, c3));
            }
        }
    }

    private static void combineSDCNoFilterOOO(int nca, int ncb, double[] tua, double[] tub, MatrixBlock out, MatrixBlock ma, MatrixBlock mb, int ra, int rb, int[] ai, int[] bi) {
        int r;
        int c;
        for (c = 0; c < nca; ++c) {
            out.set(0, ai[c], tua[c]);
        }
        for (c = 0; c < ncb; ++c) {
            out.set(0, bi[c], tub[c]);
        }
        for (r = 1; r < ra + 1; ++r) {
            int c2;
            for (c2 = 0; c2 < nca; ++c2) {
                out.set(r, ai[c2], ma.get(r - 1, c2));
            }
            for (c2 = 0; c2 < ncb; ++c2) {
                out.set(r, bi[c2], tub[c2]);
            }
        }
        for (r = ra + 1; r < out.getNumRows(); ++r) {
            int c3;
            int ia = r % (ra + 1) - 1;
            int ib = r / (ra + 1) - 1;
            if (ia == -1) {
                for (c3 = 0; c3 < nca; ++c3) {
                    out.set(r, ai[c3], tua[c3]);
                }
            } else {
                for (c3 = 0; c3 < nca; ++c3) {
                    out.set(r, ai[c3], ma.get(ia, c3));
                }
            }
            for (c3 = 0; c3 < ncb; ++c3) {
                out.set(r, bi[c3], mb.get(ib, c3));
            }
        }
    }

    public static IDictionary combineSDCFilter(IDictionary a, double[] tua, IDictionary b, double[] tub, HashMapLongInt filter) {
        return DictionaryFactory.combineSDCFilter(a, tua, null, b, tub, null, filter);
    }

    public static IDictionary combineSDCFilter(IDictionary a, double[] tua, IColIndex ai, IDictionary b, double[] tub, IColIndex bi, HashMapLongInt filter) {
        if (filter == null) {
            return DictionaryFactory.combineSDCNoFilter(a, tua, ai, b, tub, bi);
        }
        int nca = tua.length;
        int ncb = tub.length;
        int ra = a.getNumberOfValues(nca);
        int rb = b.getNumberOfValues(ncb);
        MatrixBlock ma = a.getMBDict(nca).getMatrixBlock();
        MatrixBlock mb = b.getMBDict(ncb).getMatrixBlock();
        MatrixBlock out = new MatrixBlock(filter.size(), nca + ncb, false);
        out.allocateBlock();
        if (ai != null && bi != null) {
            Pair<int[], int[]> re = IColIndex.reorderingIndexes(ai, bi);
            DictionaryFactory.combineSDCFilterOOO(filter, nca, ncb, tua, tub, out, ma, mb, ra, rb, re.getKey(), re.getValue());
        } else {
            DictionaryFactory.combineSDCFilter(filter, nca, ncb, tua, tub, out, ma, mb, ra, rb);
        }
        return new MatrixBlockDictionary(out);
    }

    private static void combineSDCFilter(HashMapLongInt filter, int nca, int ncb, double[] tua, double[] tub, MatrixBlock out, MatrixBlock ma, MatrixBlock mb, int ra, int rb) {
        int o;
        int r;
        int o0 = filter.get(0L);
        if (o0 != -1) {
            int c;
            for (c = 0; c < nca; ++c) {
                out.set(o0, c, tua[c]);
            }
            for (c = 0; c < ncb; ++c) {
                out.set(o0, c + nca, tub[c]);
            }
        }
        for (r = 1; r < ra + 1; ++r) {
            int c;
            o = filter.get(r);
            if (o == -1) continue;
            for (c = 0; c < nca; ++c) {
                out.set(o, c, ma.get(r - 1, c));
            }
            for (c = 0; c < ncb; ++c) {
                out.set(o, c + nca, tub[c]);
            }
        }
        for (r = ra + 1; r < ra * rb + ra + rb + 1; ++r) {
            int c;
            o = filter.get(r);
            if (o == -1) continue;
            int ia = r % (ra + 1) - 1;
            int ib = r / (ra + 1) - 1;
            if (ia == -1) {
                for (c = 0; c < nca; ++c) {
                    out.set(o, c, tua[c]);
                }
            } else {
                for (c = 0; c < nca; ++c) {
                    out.set(o, c, ma.get(ia, c));
                }
            }
            for (c = 0; c < ncb; ++c) {
                out.set(o, c + nca, mb.get(ib, c));
            }
        }
    }

    private static void combineSDCFilterOOO(HashMapLongInt filter, int nca, int ncb, double[] tua, double[] tub, MatrixBlock out, MatrixBlock ma, MatrixBlock mb, int ra, int rb, int[] ai, int[] bi) {
        int o;
        int r;
        int o0 = filter.get(0L);
        if (o0 != -1) {
            int c;
            for (c = 0; c < nca; ++c) {
                out.set(o0, ai[c], tua[c]);
            }
            for (c = 0; c < ncb; ++c) {
                out.set(o0, bi[c], tub[c]);
            }
        }
        for (r = 1; r < ra + 1; ++r) {
            int c;
            o = filter.get(r);
            if (o == -1) continue;
            for (c = 0; c < nca; ++c) {
                out.set(o, ai[c], ma.get(r - 1, c));
            }
            for (c = 0; c < ncb; ++c) {
                out.set(o, bi[c], tub[c]);
            }
        }
        for (r = ra + 1; r < ra * rb + ra + rb + 1; ++r) {
            int c;
            o = filter.get(r);
            if (o == -1) continue;
            int ia = r % (ra + 1) - 1;
            int ib = r / (ra + 1) - 1;
            if (ia == -1) {
                for (c = 0; c < nca; ++c) {
                    out.set(o, ai[c], tua[c]);
                }
            } else {
                for (c = 0; c < nca; ++c) {
                    out.set(o, ai[c], ma.get(ia, c));
                }
            }
            for (c = 0; c < ncb; ++c) {
                out.set(o, bi[c], mb.get(ib, c));
            }
        }
    }

    private static IDictionary combineSparseConstSparseRet(IDictionary a, int nca, double[] tub, int[] ai, int[] bi) {
        int ncb = tub.length;
        int ra = a.getNumberOfValues(nca);
        MatrixBlock ma = a.getMBDict(nca).getMatrixBlock();
        MatrixBlock out = new MatrixBlock(ra, nca + ncb, false);
        out.allocateBlock();
        for (int r = 0; r < ra; ++r) {
            int c;
            for (c = 0; c < nca; ++c) {
                out.set(r, ai[c], ma.get(r, c));
            }
            for (c = 0; c < ncb; ++c) {
                out.set(r, bi[c], tub[c]);
            }
        }
        return new MatrixBlockDictionary(out);
    }

    private static IDictionary combineSparseConstSparseRet(IDictionary a, int nca, double[] tub, int[] ai, int[] bi, HashMapLongInt filter) {
        if (filter == null) {
            return DictionaryFactory.combineSparseConstSparseRet(a, nca, tub, ai, bi);
        }
        throw new NotImplementedException();
    }

    private static IDictionary combineConstLeftAll(double[] tua, IDictionary b, int ncb, int[] ai, int[] bi) {
        int nca = tua.length;
        int rb = b.getNumberOfValues(ncb);
        MatrixBlock mb = b.getMBDict(ncb).getMatrixBlock();
        MatrixBlock out = new MatrixBlock(rb, nca + ncb, false);
        out.allocateBlock();
        for (int r = 0; r < rb; ++r) {
            int c;
            for (c = 0; c < nca; ++c) {
                out.set(r, ai[c], tua[c]);
            }
            for (c = 0; c < ncb; ++c) {
                out.set(r, bi[c], mb.get(r, c));
            }
        }
        return new MatrixBlockDictionary(out);
    }

    private static IDictionary combineConstLeft(double[] tua, IDictionary b, int ncb, int[] ai, int[] bi, HashMapLongInt filter) {
        if (filter == null) {
            return DictionaryFactory.combineConstLeftAll(tua, b, ncb, ai, bi);
        }
        throw new NotImplementedException();
    }

    public static IDictionary cBindDictionaries(int nCol, List<IDictionary> dicts) {
        MatrixBlockDictionary baseDict = dicts.get(0).getMBDict(nCol);
        MatrixBlock base = baseDict == null ? new MatrixBlock(1, nCol, true) : baseDict.getMatrixBlock();
        MatrixBlock[] others = new MatrixBlock[dicts.size() - 1];
        for (int i = 1; i < dicts.size(); ++i) {
            MatrixBlock otherBase;
            MatrixBlockDictionary otherDict = dicts.get(i).getMBDict(nCol);
            others[i - 1] = otherBase = otherDict == null ? new MatrixBlock(1, nCol, true) : otherDict.getMatrixBlock();
        }
        MatrixBlock ret = base.append(others, null, true);
        return MatrixBlockDictionary.create(ret, true);
    }

    public static IDictionary cBindDictionaries(IDictionary left, IDictionary right, int nColLeft, int nColRight) {
        MatrixBlockDictionary base = left.getMBDict(nColLeft);
        MatrixBlockDictionary add = right.getMBDict(nColRight);
        MatrixBlock a = base == null ? (add != null ? new MatrixBlock(add.getNumberOfValues(nColRight), nColLeft, true) : new MatrixBlock(1, nColLeft, true)) : base.getMatrixBlock();
        MatrixBlock b = add == null ? new MatrixBlock(a.getNumRows(), nColRight, true) : add.getMatrixBlock();
        MatrixBlock ret = a.append(b, null, true);
        return MatrixBlockDictionary.create(ret, true);
    }

    public static enum Type {
        FP64_DICT,
        MATRIX_BLOCK_DICT,
        INT8_DICT,
        IDENTITY,
        IDENTITY_SLICE,
        PLACE_HOLDER;

    }
}

