/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysds.runtime.io.FrameReaderTextCSV;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.utils.stats.Timing;

public class FrameReaderTextCSVParallel
extends FrameReaderTextCSV {
    public FrameReaderTextCSVParallel(FileFormatPropertiesCSV props) {
        super(props);
    }

    @Override
    protected void readCSVFrameFromHDFS(Path path, JobConf job, FileSystem fs, FrameBlock dest, Types.ValueType[] schema, String[] names, long rlen, long clen) throws IOException {
        Timing time = new Timing(true);
        int numThreads = OptimizerUtils.getParallelTextReadParallelism();
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        InputSplit[] splits = informat.getSplits(job, numThreads);
        if (HDFSTool.isDirectory(fs, path)) {
            splits = IOUtilFunctions.sortInputSplits(splits);
        }
        ExecutorService pool = CommonThreadPool.get(numThreads);
        try {
            if (splits.length == 1) {
                new ReadRowsTask(splits[0], informat, job, dest, 0, true).call();
                return;
            }
            ArrayList<Future<Long>> cret = new ArrayList<Future<Long>>();
            for (int i = 0; i < splits.length - 1; ++i) {
                cret.add(pool.submit(new CountRowsTask(splits[i], informat, job, this._props.hasHeader() && i == 0)));
            }
            LOG.debug((Object)("Spawned all row counting tasks CSV : " + time.stop()));
            long offset = 0L;
            ArrayList<Future<Object>> tasks2 = new ArrayList<Future<Object>>();
            for (int i = 0; i < splits.length - 1; ++i) {
                long l = (Long)((Future)cret.get(i)).get();
                tasks2.add(pool.submit(new ReadRowsTask(splits[i], informat, job, dest, (int)offset, i == 0)));
                offset += l;
            }
            tasks2.add(pool.submit(new ReadRowsTask(splits[splits.length - 1], informat, job, dest, (int)offset, splits.length == 1)));
            LOG.debug((Object)("Spawned all reading tasks CSV : " + time.stop()));
            for (Future future : tasks2) {
                future.get();
            }
            LOG.debug((Object)("Finished Reading CSV : " + time.stop()));
        }
        catch (Exception e) {
            throw new IOException("Failed parallel read of text csv input.", e);
        }
        finally {
            pool.shutdown();
        }
    }

    @Override
    protected Pair<Integer, Integer> computeCSVSize(Path path, JobConf job, FileSystem fs) throws IOException {
        int numThreads = OptimizerUtils.getParallelTextReadParallelism();
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        InputSplit[] splits = informat.getSplits(job, numThreads);
        int ncol = IOUtilFunctions.countNumColumnsCSV(splits, (InputFormat)informat, job, this._props.getDelim());
        long nrow = 0L;
        ExecutorService pool = CommonThreadPool.get(numThreads);
        try {
            ArrayList<CountRowsTask> tasks = new ArrayList<CountRowsTask>();
            for (int i = 0; i < splits.length; ++i) {
                tasks.add(new CountRowsTask(splits[i], informat, job, this._props.hasHeader() && i == 0));
            }
            List cret = pool.invokeAll(tasks);
            for (Future count : cret) {
                nrow += ((Long)count.get()).longValue();
            }
            if (nrow > Integer.MAX_VALUE) {
                throw new DMLRuntimeException("invalid read with over Integer number of rows");
            }
            Pair<Integer, Integer> pair = new Pair<Integer, Integer>((int)nrow, ncol);
            return pair;
        }
        catch (Exception e) {
            throw new IOException("Failed parallel read of text csv input.", e);
        }
        finally {
            pool.shutdown();
        }
    }

    private class ReadRowsTask
    implements Callable<Object> {
        private InputSplit _split = null;
        private TextInputFormat _informat = null;
        private JobConf _job = null;
        private FrameBlock _dest = null;
        private int _offset = -1;
        private boolean _isFirstSplit = false;

        public ReadRowsTask(InputSplit split, TextInputFormat informat, JobConf job, FrameBlock dest, int offset, boolean first) {
            this._split = split;
            this._informat = informat;
            this._job = job;
            this._dest = dest;
            this._offset = offset;
            this._isFirstSplit = first;
        }

        @Override
        public Object call() throws Exception {
            FrameReaderTextCSVParallel.this.readCSVFrameFromInputSplit(this._split, (InputFormat<LongWritable, Text>)this._informat, this._job, this._dest, this._dest.getSchema(), this._dest.getColumnNames(), this._dest.getNumRows(), this._dest.getNumColumns(), this._offset, this._isFirstSplit);
            return null;
        }
    }

    private static class CountRowsTask
    implements Callable<Long> {
        private InputSplit _split;
        private TextInputFormat _informat;
        private JobConf _job;
        private boolean _hasHeader;

        public CountRowsTask(InputSplit split, TextInputFormat informat, JobConf job, boolean hasHeader) {
            this._split = split;
            this._informat = informat;
            this._job = job;
            this._hasHeader = hasHeader;
        }

        @Override
        public Long call() throws Exception {
            long count = FrameReaderTextCSV.countLinesInSplit(this._split, this._informat, this._job, this._hasHeader);
            return count;
        }
    }
}

