/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.jsr223;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import java.util.Collections;
import java.util.Set;
import org.apache.tinkerpop.gremlin.jsr223.AbstractGremlinPlugin;
import org.apache.tinkerpop.gremlin.jsr223.GremlinLangCustomizer;
import org.apache.tinkerpop.gremlin.jsr223.GremlinLangScriptEngineFactory;

public class GremlinLangPlugin
extends AbstractGremlinPlugin {
    private static final String NAME = "tinkerpop.gremlin-language";
    private static final GremlinLangScriptEngineFactory factory = new GremlinLangScriptEngineFactory();
    private static final Set<String> APPLIES_TO = Collections.singleton(factory.getEngineName());

    private GremlinLangPlugin(Builder builder) {
        super(NAME, APPLIES_TO, new GremlinLangCustomizer(builder.cacheEnabled, builder.caffeineSpec != null ? Caffeine.from((CaffeineSpec)builder.caffeineSpec) : Caffeine.newBuilder()));
    }

    public static Builder build() {
        return new Builder();
    }

    public static class Builder {
        private boolean cacheEnabled = false;
        private CaffeineSpec caffeineSpec = null;

        public Builder cacheEnabled(boolean cacheEnabled) {
            this.cacheEnabled = cacheEnabled;
            return this;
        }

        public Builder caffeine(String spec) {
            this.caffeineSpec = CaffeineSpec.parse((String)spec);
            return this;
        }

        public GremlinLangPlugin create() {
            return new GremlinLangPlugin(this);
        }
    }
}

