/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.io;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class BufferPool {
    private static final Log log = LogFactory.getLog(BufferPool.class);
    public static final int DEFAULT_POOL_SIZE = Integer.getInteger("org.apache.catalina.tribes.io.BufferPool.DEFAULT_POOL_SIZE", 0x6400000);
    protected static final StringManager sm = StringManager.getManager(BufferPool.class);
    protected static volatile BufferPool instance = null;
    protected int maxSize;
    protected final AtomicInteger size = new AtomicInteger(0);
    protected final ConcurrentLinkedQueue<XByteBuffer> queue = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BufferPool getBufferPool() {
        if (instance != null) return instance;
        Class<BufferPool> clazz = BufferPool.class;
        synchronized (BufferPool.class) {
            if (instance != null) return instance;
            BufferPool pool = new BufferPool();
            pool.setMaxSize(DEFAULT_POOL_SIZE);
            log.info((Object)sm.getString("bufferPool.created", Integer.toString(DEFAULT_POOL_SIZE), pool.getClass().getName()));
            instance = pool;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private BufferPool() {
    }

    public XByteBuffer getBuffer(int minSize, boolean discard) {
        XByteBuffer buffer = this.queue.poll();
        if (buffer != null) {
            this.size.addAndGet(-buffer.getCapacity());
        }
        if (buffer == null) {
            buffer = new XByteBuffer(minSize, discard);
        } else if (buffer.getCapacity() <= minSize) {
            buffer.expand(minSize);
        }
        buffer.setDiscard(discard);
        buffer.reset();
        return buffer;
    }

    public void returnBuffer(XByteBuffer buffer) {
        if (this.size.get() + buffer.getCapacity() <= this.maxSize) {
            this.size.addAndGet(buffer.getCapacity());
            this.queue.offer(buffer);
        }
    }

    public void clear() {
        this.queue.clear();
        this.size.set(0);
    }

    public void setMaxSize(int bytes) {
        this.maxSize = bytes;
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

